<?php
include_once($server_root.'/router/router_lib.inc.php') ;

function paracrm_qapps_getToolbarData( $post_data )
{
	global $_opDB ;
	
	// Qapps publiés
	$arr_pub_qapps = array() ;
	$query = "SELECT target_qapp_id FROM input_qapp_src" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		if( $arr['target_qapp_id'] > 0 ) {
			$arr_pub_qapps[] = $arr['target_qapp_id'] ;
		}
	}
	// Qapps
	$query = "SELECT qapp_id as qappId, qapp_uuid as qappUuid, qapp_name as text
				FROM qapp ORDER BY qapp_name" ;
	$result = $_opDB->query($query) ;
	$TAB_qapps = array();
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$TAB_qapps[] = array(
			'qappId' => $arr['qappId'],
			'qappUuid' => $arr['qappUuid'],
			'text' => $arr['text'],
			'authReadOnly' => false,
			'isPublished' => in_array($arr['qappId'],$arr_pub_qapps),
		) ;
	}
	
	$arr_auth_status = array(
		'disableAdmin' => !Auth_Manager::getInstance()->auth_query_sdomain_admin( Auth_Manager::sdomain_getCurrent() ),
		'readOnly' => !Auth_Manager::getInstance()->auth_query_sdomain_action(
			Auth_Manager::sdomain_getCurrent(),
			'queries',
			NULL,
			$write=true
		)
	) ;
	
	return array('success'=>true,'auth_status'=>$arr_auth_status,'data_qapps'=>$TAB_qapps) ;
}















function paracrm_qapps_qappTransaction( $post_data ) {
	if( $post_data['_action'] == 'qapps_qappTransaction' && $post_data['_subaction'] == 'init' )
	{
		// ouverture transaction
		$transaction_id = $_SESSION['next_transaction_id']++ ;
		
		$_SESSION['transactions'][$transaction_id] = array() ;
		$_SESSION['transactions'][$transaction_id]['transaction_code'] = 'paracrm_qapps_qappTransaction' ;
		
		$arr_saisie = array() ;
		$_SESSION['transactions'][$transaction_id]['arr_saisie'] = $arr_saisie ;
		$_SESSION['transactions'][$transaction_id]['arr_buildsUUID'] = array() ;
		
		$post_data['_transaction_id'] = $transaction_id ;
	}
	
	
	if( $post_data['_action'] == 'qapps_qappTransaction' && $post_data['_transaction_id'] )
	{
		if( !$_SESSION['transactions'][$post_data['_transaction_id']] )
			return NULL ;
		$transaction_id = $post_data['_transaction_id'] ;
		$arr_transaction = $_SESSION['transactions'][$transaction_id] ;
		if( $arr_transaction['transaction_code'] != 'paracrm_qapps_qappTransaction' )
			return NULL ;
			
		$arr_saisie = $arr_transaction['arr_saisie'] ;
		
		if( $post_data['_subaction'] == 'init' )
		{
			$json =  paracrm_qapps_qappTransaction_init( $post_data , $arr_saisie ) ;
		}
		if( $post_data['_subaction'] == 'files_getList' )
		{
			$json =  paracrm_qapps_qappTransaction_filesGetList( $post_data , $arr_saisie ) ;
		}
		if( $post_data['_subaction'] == 'file_action' )
		{
			$json =  paracrm_qapps_qappTransaction_fileAction( $post_data , $arr_saisie ) ;
		}
		if( $post_data['_subaction'] == 'file_download' )
		{
			$json =  paracrm_qapps_qappTransaction_fileDownload( $post_data , $arr_saisie ) ;
		}
		if( $post_data['_subaction'] == 'file_upload' )
		{
			$json =  paracrm_qapps_qappTransaction_fileUpload( $post_data , $arr_saisie ) ;
		}
		if( $post_data['_subaction'] == 'submit' )
		{
			$json =  paracrm_qapps_qappTransaction_submit( $post_data , $arr_saisie ) ;
		}
		
		if( $post_data['_subaction'] == 'toggle_publish' )
		{
			$json =  paracrm_queries_qappTransaction_togglePublish( $post_data , $arr_saisie ) ;
		}
		
		if( $post_data['_subaction'] == 'save' || $post_data['_subaction'] == 'saveas' || $post_data['_subaction'] == 'delete' )
		{
			$json =  paracrm_qapps_qappTransaction_save( $post_data , $arr_saisie ) ;
		}
		
		if( $post_data['_subaction'] == 'build' )
		{
			sleep(2);
			$json =  paracrm_queries_qappTransaction_buildCreate( $post_data , $arr_saisie ) ;
		}
		
		if( $post_data['_subaction'] == 'end' )
		{
			foreach( $_SESSION['transactions'][$transaction_id]['arr_buildsUUID'] as $build_uuid ) {
				libRouter_buildDelete($build_uuid);
			}
			unset($_SESSION['transactions'][$transaction_id]) ;
			return array('success'=>true) ;
		}
		
		if( is_array($arr_saisie) )
		{
			$_SESSION['transactions'][$transaction_id]['arr_saisie'] = $arr_saisie ;
		}
		else
		{
			unset($_SESSION['transactions'][$transaction_id]) ;
		}
		
		if( ($post_data['_subaction'] == 'build') && ($json['build_status']=='OK') ) {
			session_write_close();
			
			if( $_COOKIE["OP5APP"] ) {
				$uuids = json_decode($_COOKIE["OP5APP"],true);
			}
			if( !is_array($uuids) ) {
				$uuids = array();
			}
			if( !in_array($json['build_uuid'],$uuids) ) {
				$uuids[] = $json['build_uuid'];
			}
			setcookie("OP5APP", json_encode($uuids),0,'/');
		}
		
		return $json ;
	}
}

function paracrm_qapps_qappTransaction_init( $post_data , &$arr_saisie ) {
	global $_opDB ;
	
	if( $post_data['qapp_id'] && !is_numeric($post_data['qapp_id']) ) {
		$query = "SELECT qapp_id FROM qapp WHERE qapp_name='{$post_data['qapp_id']}'" ;
		$post_data['qapp_id'] = $_opDB->query_uniqueValue($query) ;
	}
	
	/*
	************ INITIALISATION *********
	- structure 'tree' du fichier
	- remplissage des champs
	*******************************
	*/
	if( $post_data['is_new'] == 'true' )
	{
		$arr_saisie['qapp_cfg_obj'] = array(
			'assets' => array(),
		);
		$qapp_file_ssid = 0 ;
		$arr_saisie['files'] = array() ;
		foreach( paracrm_qapp_lib_getNewFiles() as $tpl_file ) {
			$qapp_file_ssid++ ;
			$tpl_file['qapp_file_ssid'] = $qapp_file_ssid ;
			$tpl_file['file_base64'] = base64_encode('') ;
			$arr_saisie['files'][] = $tpl_file;
		}
	}
	elseif( $post_data['qapp_id'] > 0 )
	{
		$query = "SELECT * FROM qapp WHERE qapp_id='{$post_data['qapp_id']}'" ;
		$result = $_opDB->query($query) ;
		$arr = $_opDB->fetch_assoc($result) ;
		if( !$arr )
		{
			$transaction_id = $post_data['_transaction_id'] ;
			unset($_SESSION['transactions'][$transaction_id]) ;
			return array('success'=>false) ;
		}
		$arr_saisie['qapp_id'] = $arr['qapp_id'] ;
		$arr_saisie['qapp_name'] = $arr['qapp_name'] ;
		$arr_saisie['qapp_cfg_obj'] = json_decode($arr['qapp_cfg_json'],true) ;
		
		$arr_saisie['files'] = array();
		$query = "SELECT * FROM qapp_file WHERE qapp_id='{$arr_saisie['qapp_id']}' ORDER BY qapp_file_ssid" ;
		$result = $_opDB->query($query) ;
		$c=0;
		while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
			$c++;
			$arr_saisie['files'][] = array(
				'qapp_file_ssid' => $c,
				'file_name' => $arr['file_name'],
				'file_type' => $arr['file_type'],
				'file_is_main' => ($arr['file_is_main']=='O'),
				'file_base64' => ($arr['file_base64']),
			);
		}
	}
	else
	{
		$transaction_id = $post_data['_transaction_id'] ;
		unset($_SESSION['transactions'][$transaction_id]) ;
		return array('success'=>false) ;
	}
	
	return array(
		'success'=>true,
		'transaction_id' => $post_data['_transaction_id'],
		'data' => array(
			'qapp_id' => $arr_saisie['qapp_id'],
			'qapp_name' => $arr_saisie['qapp_name'],
			'qapp_cfg_obj' => $arr_saisie['qapp_cfg_obj'],
			'lib_assets' => paracrm_qapp_lib_getAssets(),
		)
	) ;
}
function paracrm_qapps_qappTransaction_tool_findFileIdx( $arr_files, $qapp_file_ssid ) {
	foreach( $arr_files as $idx => $file ) {
		if( $file['qapp_file_ssid'] == $qapp_file_ssid ) {
			return $idx;
		}
	}
	return false ;
}
function paracrm_qapps_qappTransaction_fileAction( $post_data , &$arr_saisie ) {
	$fn_evalName = function($txt_name) {
		$txt_name = preg_replace("/[^a-zA-Z0-9-_.]/", "",$txt_name);
		$extension = end(explode('.',$txt_name));
		$radical = substr($txt_name,0,strlen($txt_name)-(strlen($extension)+1));
		if( !$radical || !$extension ) {
			throw new Exception("Invalid file name");
		}
		switch( strtolower($extension) ) {
			case 'js' :
			case 'css' :
			case 'html' :
			case 'png' :
			case 'svg' :
				break ;
			default :
				throw new Exception("Unsupported type {$extension}");
		}
		return array($txt_name,$extension);
	};
	switch( $post_data['file_action'] ) {
		case 'new' :
			try {
				list($file_name, $file_type) = $fn_evalName($post_data['file_name']);
			} catch( Exception $e ) {
				return array('success'=>false, 'error'=>$e->getMessage());
			}
			$max_ssid = 0 ;
			foreach( $arr_saisie['files'] as $file ) {
				if( strtolower($file['file_name']) == strtolower($file_name) ) {
					return array('success'=>false, 'error'=>'Existing filename');
				}
				if( $max_ssid < $file['qapp_file_ssid'] ) {
					$max_ssid = $file['qapp_file_ssid'] ;
				}
			}
			$arr_saisie['files'][] = array(
				'qapp_file_ssid' => $max_ssid+1,
				'file_name' => $file_name,
				'file_type' => $file_type,
				'file_is_main' => false,
				'file_base64' => '',
			);
			return array('success'=>true);
		case 'delete' :
			$file_idx = paracrm_qapps_qappTransaction_tool_findFileIdx($arr_saisie['files'],$post_data['qapp_file_ssid']);
			if( $file_idx===false ){
				return array('success'=>false);
			}
			unset($arr_saisie['files'][$file_idx]);
			return array('success'=>true);
		default :
			return array('success'=>false);
	}
}
function paracrm_qapps_qappTransaction_filesGetList( $post_data , &$arr_saisie ) {
	return array('success'=>true, 'data'=>array_values($arr_saisie['files'])) ;
}
function paracrm_qapps_qappTransaction_fileDownload( $post_data, &$arr_saisie ) {
	$file_idx = paracrm_qapps_qappTransaction_tool_findFileIdx($arr_saisie['files'],$post_data['qapp_file_ssid']);
	if( $file_idx===false ){
		return array('success'=>false);
	}
	return array('success'=>true, 'data'=>$arr_saisie['files'][$file_idx]);
}
function paracrm_qapps_qappTransaction_fileUpload( $post_data, &$arr_saisie ) {
	$file_idx = paracrm_qapps_qappTransaction_tool_findFileIdx($arr_saisie['files'],$post_data['qapp_file_ssid']);
	if( $file_idx===false ){
		return array('success'=>false);
	}
	$arr_saisie['files'][$file_idx]['file_base64'] = $post_data['file_base64'];
	return array('success'=>true);
}
function paracrm_qapps_qappTransaction_submit( $post_data , &$arr_saisie ) {
	global $_opDB ;
	
	$form_data = json_decode($post_data['data'],true);
	
	$arr_saisie['qapp_cfg_obj'] = $form_data['qapp_cfg_obj'] ;
	foreach( $form_data['files'] as $file_data ) {
		$file_idx = paracrm_qapps_qappTransaction_tool_findFileIdx($arr_saisie['files'],$file_data['qapp_file_ssid']);
		if( $file_idx===false ){
			return array('success'=>false);
		}
		$arr_saisie['files'][$file_idx]['file_base64'] = $file_data['file_base64'];
	}
	
	return array('success'=>true) ;
}
function paracrm_qapps_qappTransaction_save( $post_data , &$arr_saisie )
{
	global $_opDB ;
	
	if( !Auth_Manager::getInstance()->auth_query_sdomain_action(
		Auth_Manager::sdomain_getCurrent(),
		'queries',
		NULL,
		$write=true
	)) {
			return Auth_Manager::auth_getDenialResponse() ;
	}
	
	if( $post_data['_subaction'] == 'save' )
	{
		if( !$arr_saisie['qapp_id'] )
			return array('success'=>false) ;
		
		$arr_cond = array() ;
		$arr_cond['qapp_id'] = $arr_saisie['qapp_id'] ;
		$arr_update = array() ;
		$arr_update['qapp_cfg_json'] = json_encode($arr_saisie['qapp_cfg_obj']) ;
		$_opDB->update('qapp',$arr_update,$arr_cond) ;
		
		$query = "DELETE FROM qapp_file WHERE qapp_id='{$arr_saisie['qapp_id']}'" ;
		$_opDB->query($query) ;
		$c=0;
		foreach( $arr_saisie['files'] as $file ) {
			$c++;
			$arr_ins = array(
				'qapp_id' => $arr_saisie['qapp_id'],
				'qapp_file_ssid' => $c,
				'file_name' => $file['file_name'],
				'file_type' => $file['file_type'],
				'file_is_main' => $file['file_is_main'] ? 'O':'',
				'file_base64' => $file['file_base64'],
			);
			$_opDB->insert('qapp_file',$arr_ins) ;
		}
		
		return array('success'=>true,'qapp_id'=>$arr_saisie['qapp_id']) ;
	}

	if( $post_data['_subaction'] == 'saveas' )
	{
		$arr_ins = array() ;
		$arr_ins['qapp_name'] = $post_data['qapp_name'] ;
		$_opDB->insert('qapp',$arr_ins) ;
		
		$arr_saisie['qapp_id'] = $_opDB->insert_id() ;
		
		$arr_cond = array() ;
		$arr_cond['qapp_id'] = $arr_saisie['qapp_id'] ;
		$arr_update = array() ;
		$arr_update['qapp_cfg_json'] = json_encode($arr_saisie['qapp_cfg_obj']) ;
		$_opDB->update('qapp',$arr_update,$arr_cond) ;
		
		$query = "DELETE FROM qapp_file WHERE qapp_id='{$arr_saisie['qapp_id']}'" ;
		$_opDB->query($query) ;
		$c=0;
		foreach( $arr_saisie['files'] as $file ) {
			$c++;
			$arr_ins = array(
				'qapp_id' => $arr_saisie['qapp_id'],
				'qapp_file_ssid' => $c,
				'file_name' => $file['file_name'],
				'file_type' => $file['file_type'],
				'file_is_main' => $file['file_is_main'] ? 'O':'',
				'file_base64' => $file['file_base64'],
			);
			$_opDB->insert('qapp_file',$arr_ins) ;
		}
		
		return array('success'=>true,'qapp_id'=>$arr_saisie['qapp_id']) ;
	}
	
	
	if( $post_data['_subaction'] == 'delete' )
	{
		if( !$arr_saisie['qapp_id'] )
			return array('success'=>false) ;
		
		$tables = array() ;
		$tables[] = 'qapp' ;
		$tables[] = 'qapp_file' ;
		foreach( $tables as $dbtab )
		{
			$query = "DELETE FROM $dbtab WHERE qapp_id='{$arr_saisie['qapp_id']}'" ;
			$_opDB->query($query) ;
		}
		
		return array('success'=>true) ;
	}
}
function paracrm_queries_qappTransaction_togglePublish( $post_data , $arr_saisie ) {
	global $_opDB ;
	
	$qapp_id = $arr_saisie['qapp_id'] ;
	$is_published = ($post_data['isPublished']=='true')?true:false ;
	
	$query = "DELETE FROM input_qapp_src WHERE target_qapp_id='$qapp_id'" ;
	$_opDB->query($query) ;
	
	if( $is_published ) {
		$arr_ins = array() ;
		$arr_ins['target_qapp_id'] = $qapp_id ;
		$_opDB->insert('input_qapp_src',$arr_ins) ;
	}
	
	// TODO : publish !
	if( $is_published ) {
		$json = paracrm_queries_qappTransaction_buildCreate($post_data,$arr_saisie,true);
		if( $json['success'] ) {
			$qapp_uuid = $json['publish_uuid'] ;
		}
	} else {
		// TODO ? purge
		$query = "SELECT qapp_uuid FROM qapp WHERE qapp_id='$qapp_id'" ;
		$qapp_uuid = $_opDB->query_uniqueValue($query) ;
		if( $qapp_uuid ) {
			libRouter_buildDelete($qapp_uuid) ;
		}
		$qapp_uuid = '' ;
	}
	$arr_cond = array() ;
	$arr_cond['qapp_id'] = $arr_saisie['qapp_id'] ;
	$arr_update = array() ;
	$arr_update['qapp_uuid'] = $qapp_uuid ;
	$_opDB->update('qapp',$arr_update,$arr_cond) ;
	
	return array('success'=>true);
}

function paracrm_queries_qappTransaction_buildCreate($post_data, &$arr_saisie, $do_publish=false ) {
	$transaction_id = $post_data['_transaction_id'] ;
	
	$build_obj = array(
		'build_is_tmp'=> $do_publish ? 0 : 1,
		'qsql' => array(array(
			'domain_id' => DatabaseMgr_Base::dbCurrent_getDomainId(),
			'sdomain_id' => DatabaseMgr_Sdomain::dbCurrent_getSdomainId(),
		)),
		'static' => array(),
	);
	
	$build_obj['static'][] = array(
		'get_path' => '/'.'index.html',
		'out_mimetype' => 'text/html',
		'out_base64' => base64_encode(paracrm_qapp_lib_buildMainAsHtml($arr_saisie)),
	);
	foreach( $arr_saisie['files'] as $file ) {
		$mimetype = 'text/plain' ;
		switch( $file['file_type'] ) {
			case 'html' : $mimetype = 'text/html'; break;
			case 'css' : $mimetype = 'text/css'; break;
			case 'js' : $mimetype = 'text/javascript'; break;
			
			case 'png' : $mimetype = 'image/png'; break;
			case 'svg' : $mimetype = 'image/svg+xml'; break;
			
			case 'json' : $mimetype = 'application/json'; break;
			
			default: break;
		}
		
		$build_obj['static'][] = array(
			'get_path' => '/'.$file['file_name'],
			'out_mimetype' => $mimetype,
			'out_base64' => $file['file_base64'],
		);
	}
	
	if( $do_publish ) {
		$existing_uuid = 'ffffffff-ffff-ffff-ffff-'.str_pad((int)$arr_saisie['qapp_id'], 12, "0", STR_PAD_LEFT) ;
	} else {
		$existing_uuid = null ;
		if( $_SESSION['transactions'][$transaction_id]['arr_buildsUUID'] ) {
			$existing_uuid = end($_SESSION['transactions'][$transaction_id]['arr_buildsUUID']);
		}
	}
	$build_uuid = libRouter_buildCreate($build_obj, $existing_uuid);
	if( $do_publish ) {
		return array('success'=>true, 'publish_uuid'=>$existing_uuid);
	}
	
	$transaction_id = $post_data['_transaction_id'] ;
	if( !is_array($_SESSION['transactions'][$transaction_id]['arr_buildsUUID']) )
		return array('success'=>false,'build_status'=>'NO_RES') ;
	
	$_SESSION['transactions'][$transaction_id]['arr_buildsUUID'][] = $build_uuid ;
	
	return array('success'=>true,'build_status'=>'OK','build_uuid'=>$build_uuid) ;
}






function paracrm_qapp_lib_getAssets() {
	global $_opDB ;
	return libRouter_assets_getList() ;
}
function paracrm_qapp_lib_getNewFiles() {
	$arr_files = array() ;
	$arr_files[] = array(
		'file_name' => 'main.html',
		'file_type' => 'html',
		'file_is_main' => true
	);
	$arr_files[] = array(
		'file_name' => 'main.css',
		'file_type' => 'css',
		'file_is_main' => true
	);
	$arr_files[] = array(
		'file_name' => 'main.js',
		'file_type' => 'js',
		'file_is_main' => true
	);
	return $arr_files ;
}




function paracrm_qapp_lib_buildMainAsHtml($arr_saisie) {
	$main_htmlbody = $main_css = $main_js = NULL ;
	foreach( $arr_saisie['files'] as $file ) {
		if( !$file['file_is_main'] ) {
			continue ;
		}
		$file_content = base64_decode($file['file_base64']);
		switch( $file['file_type'] ) {
			case 'html' :
				$main_htmlbody = $file_content;
				break ;
			case 'css' :
				$main_css = $file_content ;
				break ;
			case 'js' :
				$main_js = $file_content ;
				break ;
		}
	}
	
	$h = array() ;
	$h[] = '<html>' ;
		$h[] = '<head>' ;
		
		//TODO assets !!
		foreach( paracrm_qapp_lib_getAssets() as $asset ) {
			$asset_id = $asset['asset_id'] ;
			if( in_array($asset_id,$arr_saisie['qapp_cfg_obj']['assets']) ) {
				foreach( $asset['paths'] as $asset_path ) {
					switch( pathinfo($asset_path)['extension'] ) {
						case 'css' :
							$h[] = "<link rel=\"stylesheet\" href=\"./{$asset_path}\">" ;
							break ;
						case 'js' :
							$h[] = "<script src=\"./{$asset_path}\"></script>" ;
							break ;
					}
				}
			}
		}
		
		if( $main_css ) {
			$h[] = '<link rel="stylesheet" href="./main.css">' ;
		}
		$h[] = '</head>' ;
	
		$h[] = '<body>' ;
		$h[] = $main_htmlbody ;
		if( $main_js ) {
			$h[] = '<script src="./main.js" type="module"></script>' ;
		}
		$h[] = '</body>' ;
	$h[] = '</html>' ;
	
	$out = '' ;
	foreach( $h as $line ) {
		$out.= $line."\n" ;
	}
	return $out ;
}


?>
