<?php

function specDbsEzeer_attach_uploadTmp( $post_data ) {
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	media_contextOpen( $_sdomain_id ) ;
	
	foreach( $_FILES as $mkey => $dummy ) {
		$src_filename = $_FILES[$mkey]['name'] ;
		$src_path = $_FILES[$mkey]['tmp_name'] ;
		
		if( function_exists('finfo_open') ) {
			$finfo = finfo_open(FILEINFO_MIME_TYPE);
			$mimetype = finfo_file($finfo, $src_path) ;
		} elseif( $src_filename ) {
			$ttmp = explode('.',$src_filename) ;
			$mimetype = end($ttmp) ;
		} else {
			return array('success'=>false, 'error'=>'Upload vide ?') ;
		}

		$media_id = media_bin_processUploaded( $src_path ) ;
		break;
	}
	if( !$media_id ) {
		return array('success'=>false, 'error'=>'Pas de media id') ;
	}

	$media_size = /*round(((filesize($src_path)*9.77)/10000),1)*/ filesize($src_path);
	$json = array(
		'success'=>($media_size>0),
		'data'=>array(
			'media_id'=>$media_id,
			'filename'=>$src_filename,
			'size'=>$media_size,
			'path'=>$src_path
		)
	) ;

	media_contextClose() ;
	return $json ;	
}
function specDbsEzeer_attach_deleteTmp( $post_data ) {
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	$p_arrMediaIds = json_decode($post_data['arr_media_id']) ;
	foreach( $p_arrMediaIds as $media_id ) {
		media_contextOpen( $_sdomain_id ) ;
		media_bin_delete($media_id) ;
		media_contextClose() ;
	}
	return array('success'=>true) ;
}

function specDbsEzeer_attach_downloadB64( $post_data ) {
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	media_contextOpen( $_sdomain_id ) ;
	if( $post_data['media_id'] ) {
		$media_id = $post_data['media_id'] ;
	} elseif( $post_data['file_code'] && $post_data['filerecord_id'] ) {
		$media_id = media_bin_toolFile_getId($post_data['file_code'],$post_data['filerecord_id']) ;
	}
	$bin = media_bin_getBinary($media_id) ;
	$mimetype = media_bin_getMimeType($media_id) ;
	media_contextClose() ;
	
	return array('success'=>true, 'bin_base64'=>base64_encode($bin), 'bin_mimetype'=>$mimetype) ;
}

function specDbsEzeer_attach_recycleAsTmp( $post_data ) {
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	usleep( 100*1000 ) ;
	if( $post_data['file_code'] && $post_data['filerecord_id'] ) {
		media_contextOpen( $_sdomain_id ) ;
		$media_id = media_bin_toolFile_getId($post_data['file_code'],$post_data['filerecord_id']) ;
		$bin = media_bin_getBinary($media_id) ;
		$mimetype = media_bin_getMimeType($media_id) ;
		
		if( $bin ) {
			$tmp_mediaId = media_bin_processBuffer($bin) ;
		}
		
		media_contextClose() ;
		
		if( $tmp_mediaId ) {
			$json = array(
				'success'=>true,
				'data'=>array(
					'media_id'=>$tmp_mediaId,
				)
			) ;
			return $json ;
		}
	}
	return array('success'=>false) ;
}

?>
