<?php

function specDbsEzeer_lib_domdoc_htmlize( $body_html ) {
	$body_html = trim($body_html) ;
	
	if( preg_match('/^<html.*?>/im',$body_html) ) {
		return $body_html ;
	}
	
	$binary_html = '' ;
	$binary_html.= '<html>' ;
		$binary_html.= '<head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /></head>';
		$binary_html.= "<body>".$body_html.'</body>' ;
	$binary_html.= '</html>' ;
	
	return $binary_html ;
}

function specDbsEzeer_lib_domdoc_email_stripCitation( $binary_html ) {
	$new_binary_html = specDbsEzeer_lib_domdoc_email_stripCitationIf( $binary_html ) ;
	if( !$new_binary_html ) {
		return $binary_html ;
	}
	return $new_binary_html ;
}
function specDbsEzeer_lib_domdoc_email_stripCitationIf( $binary_html ) {
	//return $binary_html ;

	// NOTICE strip newlines, unused
	//$binary_html = preg_replace('/[\n\r]/', '', $binary_html) ;
	
	// NOTICE strip outlook tags (bad rewrite?)
	$binary_html = str_replace(array('<o:p>','</o:p>'),array('',''),$binary_html) ;
	
	// NOTICE strip meta tags (wrong ISO8859-1 for outlook)
	$binary_html = preg_replace('/<meta.*?>/im', '', $binary_html);
	
	// HACK? UNUSED preg_match examples for meta replace
	//preg_match( '@<meta\s+http-equiv="Content-Type"\s+content="([\w/]+)(;\s*charset=([^\s"]+))?@i', $binary_html, $matches );
	//preg_match( '@<meta\s+http-equiv="Content-Type"\s+content="[\w/]+;\s*charset=([^\s"]+)?@i', $binary_html, $matches );

	$doc = new DOMDocument();
	$doc->preserveWhiteSpace = false ;
	@$doc->loadHTML('<?xml version="1.0" encoding="UTF-8"?><html>'.$binary_html.'</html>',LIBXML_HTML_NODEFDTD|LIBXML_NOBLANKS|LIBXML_NOENT);
	switch( specDbsEzeer_lib_domdoc_email_probeAuthor( $doc ) ) {
		case 'outlook' :
			$ret = specDbsEzeer_lib_domdoc_email_stripCitation_outlook($doc) ;
			break ;
		case 'gmail' :
			$ret = specDbsEzeer_lib_domdoc_email_stripCitation_gmail($doc) ;
			break ;
		default :
			$ret = specDbsEzeer_lib_domdoc_email_stripCitation_blockquote($doc) ;
			break ;
	}
	$html_buffer = @$doc->saveHTML($doc->documentElement) ;
	$html_buffer = html_entity_decode($html_buffer) ; //NOTICE unneeded ?
	
	// NOTICE strip XML tag, unused
	//$html_buffer = preg_replace('/<\?xml.*?\/>/im', '', $html_buffer);
	
	if( !$ret ) {
		return null ;
	}
	return $html_buffer ;
}
function specDbsEzeer_lib_domdoc_email_probeAuthor( $dom_doc ) {
	$body_div = specDbsEzeer_lib_domdoc_email_util_getMainBodyDiv($dom_doc) ;
	if( $body_div ) {
		$className = (string)$body_div->attributes->getNamedItem('class')->nodeValue ;
		if( stripos($className,'WordSection') !== FALSE ) {
			return 'outlook' ;
		}
		
		foreach( specDbsEzeer_lib_domdoc_email_util_getChildren($body_div) as $idx => $body_sdiv ) {
			$className = (string)$body_sdiv->attributes->getNamedItem('class')->nodeValue ;
			if( $className=='gmail_quote' ) {
				return 'gmail' ;
			}
		}
	}
	return null ;
}

function specDbsEzeer_lib_domdoc_email_stripCitation_outlook( $dom_doc ) {
	$hasDone = false ;
	
	// BODYDIV > DIV > 1xDIV(border-top) > 1xp(MsoNormal)
	$body_div = specDbsEzeer_lib_domdoc_email_util_getMainBodyDiv($dom_doc) ;
	foreach( specDbsEzeer_lib_domdoc_email_util_getChildren($body_div) as $idx => $body_sdiv ) {
		if( $body_sdiv->nodeName != 'div' ) {
			continue ;
		}
		if( count(specDbsEzeer_lib_domdoc_email_util_getChildren($body_sdiv)) != 1 ) {
			continue ;
		}
		
		$bodydiv_div = $body_sdiv ;
		$bodydiv_div_1div = null ;
		
		$tmp_style = $bodydiv_div->attributes->getNamedItem('style') ;
		$tmp_style_str = null ;
		if( $tmp_style ) {
			$tmp_style_str = (string)$tmp_style->value ;
		}
		if( strpos($tmp_style_str,'border-top') !== FALSE ) {
			$bodydiv_div_1div = $bodydiv_div ;
		} elseif( count(specDbsEzeer_lib_domdoc_email_util_getChildren($bodydiv_div))==1 ) {
			$tmp = specDbsEzeer_lib_domdoc_email_util_getChildren($bodydiv_div)[0] ;
			$tmp_style = $tmp->attributes->getNamedItem('style') ;
			if( $tmp_style ) {
				$tmp_style_str = (string)$tmp_style->value ;
				if( strpos($tmp_style_str,'border-top') !== FALSE ) {
					$bodydiv_div_1div = $tmp ;
				}
			}
		}
		if( !$bodydiv_div_1div ) {
			continue ;
		}
		if( count(specDbsEzeer_lib_domdoc_email_util_getChildren($bodydiv_div_1div))==1 ) {
			$tmp = specDbsEzeer_lib_domdoc_email_util_getChildren($bodydiv_div_1div)[0] ;
			if( $tmp->nodeName == 'p' ) {
				$tmp_class_str = $tmp->attributes->getNamedItem('class')->nodeValue ;
				if( strpos($tmp_class_str,'MsoNormal') !== FALSE ) {
					$bodydiv_div_1div_p = $tmp ;
				}
			}
		}
		if( $bodydiv_div_1div_p ) {
			//found !
			//echo "removing idx {$idx}"."\n" ;
			specDbsEzeer_lib_domdoc_email_util_removeFrom($body_div,$body_sdiv) ;
			$hasDone = true ;
			break ;
		}
	}
	return $hasDone ;
}
function specDbsEzeer_lib_domdoc_email_stripCitation_gmail( $dom_doc ) {
	$hasDone = false ;
	
	$body_div = specDbsEzeer_lib_domdoc_email_util_getMainBodyDiv($dom_doc) ;
	foreach( specDbsEzeer_lib_domdoc_email_util_getChildren($body_div) as $idx => $body_sdiv ) {
		$className = (string)$body_sdiv->attributes->getNamedItem('class')->nodeValue ;
		if( $className=='gmail_quote' ) {
			$body_div->removeChild($body_sdiv) ;
			$hasDone = true ;
			break ;
		}
	}
	return $hasDone ;
}
function specDbsEzeer_lib_domdoc_email_stripCitation_blockquote( $dom_doc ) {
	$hasDone = false ;
	
	//evalutation des blockquotes
	$body_div = specDbsEzeer_lib_domdoc_email_util_getMainBodyDiv($dom_doc) ;
	$body_div_subs = specDbsEzeer_lib_domdoc_email_util_getChildren($body_div) ;
	
	$map_idx_strlen = array() ;
	if( $body_div_subs ) {
	foreach( $body_div_subs as $idx => $body_sdiv ) {
		if( $body_sdiv->nodeName == 'blockquote' ) {
			$map_idx_strlen[$idx] = strlen($body_sdiv->textContent) ;
		}
	}
	}
	
	if( $map_idx_strlen ) {
		arsort($map_idx_strlen) ;
		$toRemove = key($map_idx_strlen) ;
		foreach( $body_div_subs as $idx => $body_sdiv ) {
			if( $idx == $toRemove ) {
				$body_div->removeChild($body_sdiv) ;
				$hasDone = true ;
				break ;
			}
		}
	}
	return $hasDone ;
}


function specDbsEzeer_lib_domdoc_email_util_removeFrom( $dom_node, $dom_subnode_from ) {
	$idx_remove = -1 ;
	foreach( $dom_node->childNodes as $idx => $dom_subnode ) {
		if( $dom_subnode === $dom_subnode_from ) {
			$idx_remove = $idx ;
			break ;
		}
	}
	//echo "idx remove {$idx}"."\n" ;
	if( $idx_remove >= 0 ) {
		for( $i=($dom_node->childNodes->length - 1) ; $i>=$idx_remove ; $i-- ) {
			$todelete = $dom_node->childNodes->item($i) ;
			$dom_node->removeChild($todelete) ;
		}
	}
}
function specDbsEzeer_lib_domdoc_email_util_getChildren( $dom_node, $tag_name=NULL ) {
	$arr = array() ;
	if( !$dom_node || !is_a($dom_node,'DOMNode') ) {
		return null ;
	}
	foreach( $dom_node->childNodes as $c ) {
		if( $c->nodeType != XML_ELEMENT_NODE ) {
			continue ;
		}
		if( !is_null($tag_name) && ($c->nodeName != $tag_name) ) {
			continue ;
		}
		$arr[] = $c ;
	}
	return $arr ;
}
function specDbsEzeer_lib_domdoc_email_util_getMainBodyDiv( $dom_doc ) {
	// TODO
	// - search for WordSection
	// - 
	// - sinon : bodydiv = table + div (hack microsoft) => div ?
	// - sinon : bodydiv = body
	$dom_body = $dom_doc->getElementsByTagName('body')[0] ;
	if( !$dom_body ) {
		return null ;
	}
	
	$searchForWordSection = function( $dom_div, $c=0 ) use (&$searchForWordSection) {
		$tmp_class_str = $dom_div->attributes->getNamedItem('class')->nodeValue ;
		if( stripos($tmp_class_str,'WordSection') !== FALSE ) {
			return $dom_div ;
		}
		if( $c >= 3 ) {
			// max iteration
			return null ;
		}
		foreach( specDbsEzeer_lib_domdoc_email_util_getChildren($dom_div,'div') as $dom_iter ) {
			if( $dom_wordsection = $searchForWordSection($dom_iter,$c+1) ) {
				return $dom_wordsection ;
			}
		}
	};
	if( $dom_wordsection = $searchForWordSection($dom_body) ) {
		return $dom_wordsection ;
	}
	
	$nb_div = $nb_blockquote = $nb_table = 0 ;
	foreach( specDbsEzeer_lib_domdoc_email_util_getChildren($dom_body) as $dom_body_sub ) {
		switch( $dom_body_sub->nodeName ) {
			case 'blockquote' :
				$nb_blockquote++ ;
				break ;
			case 'div' :
				$nb_div++ ;
				break ;
			case 'table' :
				$nb_table++ ;
				break ;
		}
	}
	if( ($nb_table==1) && ($nb_div==1) && ($nb_blockquote==0) ) {
		return specDbsEzeer_lib_domdoc_email_util_getChildren($dom_body,'div')[0] ;
	}
	
	return $dom_body ;
}








function specDbsEzeer_lib_domdoc_email_reformatForCitation( $binary_html ) {
	//BUG : ticket #106931
	//BUG : ticket #106433
	
	
	
	
	$dom_doc = new DOMDocument();
	$dom_doc->preserveWhiteSpace = false ;
	@$dom_doc->loadHTML('<?xml version="1.0" encoding="UTF-8"?><html>'.$binary_html.'</html>',LIBXML_HTML_NODEFDTD|LIBXML_NOBLANKS|LIBXML_NOENT);
	
	$dom_body = $dom_doc->getElementsByTagName('body')[0] ;
	if( !$dom_body ) {
		return $binary_html ;
	}
	
	
	$binary_output = '' ;
	
	$dom_style = $dom_doc->getElementsByTagName('style')[0] ;
	if( $dom_style ) {
		$binary_output.= '<style>' ;
		$binary_output.= $dom_style->nodeValue ;
		$binary_output.= '</style>' ;
	}
	$binary_output.= '<div>' ;
	foreach( $dom_body->childNodes as $dom_body_sub ) {
		$binary_output.= $dom_doc->saveHTML( $dom_body_sub ) ;
	}
	$binary_output.= '</div>' ;
	
	return $binary_output ;
}

?>
