<?php

function specDbsEzeer_lib_email_getMaxAttachSize() {
	return (10 * 1000 * 1000) ;
}

function specDbsEzeer_lib_email_to_getFromAdr( $login_userId ) {
	global $_opDB ;
	
	$user_row = paracrm_lib_data_getRecord('bible_entry','PPL_USER',$login_userId) ;
	if( $user_row && json_decode($user_row['field_LINK_GROUP'],true) ) {} else {
		return NULL ;
	}
	$link_group_ids = json_decode($user_row['field_LINK_GROUP'],true) ;
	if( count($link_group_ids) != 1 ) {
		print_r($link_group_ids) ;
		return NULL ;
	}
	$group_id = reset($link_group_ids) ;
	$group_row = paracrm_lib_data_getRecord('bible_treenode','PPL_GROUP',$group_id) ;
	if( $group_row && $group_row['field_EMAILFROM_ADR'] ) {
		return $group_row['field_EMAILFROM_ADR'] ;
	}
	return NULL ;
}
function specDbsEzeer_lib_email_to_formatBody( $ticket_filerecord_id, $body_html, $login_userId, $arr_ticketactionFilerecordIds=NULL ) {
	global $_opDB ;
	
	$row_ticket = $rows_ticketaction = NULL ;
	$json = specDbsEzeer_ticket_getRecord(array(
		'ticket_filerecord_id' => $ticket_filerecord_id,
		'keep_citation' => 1,
	)) ;
	if( $json['success'] ) {
		$row_ticket = $json['data'] ;
	}
	if( $row_ticket && $arr_ticketactionFilerecordIds ) {
		$rows_ticketaction = array() ;
		foreach( $row_ticket['actions'] as $iter_ticketaction ) {
			$ticketaction_filerecord_id = $iter_ticketaction['ticketaction_filerecord_id'] ;
			if( !in_array($ticketaction_filerecord_id,$arr_ticketactionFilerecordIds) ) {
				continue ;
			}
			$rows_ticketaction[$ticketaction_filerecord_id] = $iter_ticketaction ;
		}
		krsort($rows_ticketaction) ;
		$rows_ticketaction = array_values($rows_ticketaction) ;
	}
	
	$user_row = paracrm_lib_data_getRecord('bible_entry','PPL_USER',$login_userId) ;
	if( $user_row && $user_row['field_EMAILFROM_SIGNATURE'] ) {
		$body_html .= '<br><br>' ;
		$body_html .= $user_row['field_EMAILFROM_SIGNATURE'] ;
	}
	if( $rows_ticketaction ) {
		foreach( $rows_ticketaction as $row_ticketaction ) {
			$header = array() ;
				$header[] = array('title'=>'Date','value'=>date('d/m/Y H:i',strtotime($row_ticketaction['action_date']))) ;
				if( $row_ticketaction['spec_email_is_on'] ) {
					$header[] = array('title'=>'Email from','value'=>$row_ticketaction['spec_email_from']) ;
					$header[] = array('title'=>'Subject','value'=>$row_ticketaction['spec_email_subject']) ;
				} else {
					$header[] = array('title'=>'Action','value'=>$row_ticketaction['action_user']) ;
				}
			$body_html .= '<hr>' ;
			
			$body_html .= '<table border="0" cellpadding="2" cellspacing="2">' ;
			foreach( $header as $row ) {
				$body_html .= '<tr>' ;
					$body_html .= "<td width='100'><i>{$row['title']}</i></td>" ;
					$body_html .= "<td>{$row['value']}</td>" ;
				$body_html .= '</tr>' ;
			}
			$body_html .= '</table>' ;
			
			$body_html .= '<blockquote style="margin-left: 8px; border-left: 4px solid #00C; padding-left: 4px">' ;
				//$body_html .= specDbsEzeer_lib_domdoc_email_reformatForCitation($row_ticketaction['body_html']) ;
				$body_html .= $row_ticketaction['body_html'] ;
			$body_html .= '</blockquote>' ;
		}
	}
	
	return $body_html ;
}
function specDbsEzeer_lib_email_to_buildEmailOutbox( $ticket_filerecord_id, $ticketaction_filerecord_id ) {
	$row_ticket = $row_ticketaction = NULL ;
	$json = specDbsEzeer_ticket_getRecord(array(
		'ticket_filerecord_id' => $ticket_filerecord_id
	)) ;
	if( !$json['success'] ) {
		return NULL ;
	}
	$row_ticket = $json['data'] ;
	foreach( $row_ticket['actions'] as $iter_ticketaction ) {
		if( $iter_ticketaction['ticketaction_filerecord_id'] == $ticketaction_filerecord_id ) {
			$row_ticketaction = $iter_ticketaction ;
		}
	}
	if( !$row_ticketaction ) {
		return NULL ;
	}
	
	if( !$row_ticketaction['spec_email_is_outbox'] ) {
		return NULL ;
	}
	
	//print_r( $row_ticketaction ) ;
	
	$mail = PhpMailer::getInstance() ;
	$mail->isSMTP();
	$mail->CharSet = "utf-8";
	$mail->setFrom($row_ticketaction['spec_email_from']);
	foreach( explode(',',$row_ticketaction['spec_email_to']) as $emailAdr_to ) {
		$emailAdr_to = trim($emailAdr_to) ;
		if( !$emailAdr_to ) {
			continue ;
		}
		$mail->addAddress($emailAdr_to) ;
	}
	foreach( explode(',',$row_ticketaction['spec_email_cc']) as $emailAdr_cc ) {
		$emailAdr_cc = trim($emailAdr_cc) ;
		if( !$emailAdr_cc ) {
			continue ;
		}
		$mail->addCC($emailAdr_cc) ;
	}
	$mail->Subject  = $row_ticketaction['spec_email_subject'] ;
	if( $row_ticketaction['body_html'] ) {
		$mail->msgHTML($row_ticketaction['body_html']) ;
	} elseif( $row_ticketaction['body_text'] ) {
		$mail->Body = $row_ticketaction['body_text'];
	} else {
		return NULL ;
	}
	
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	foreach( $row_ticketaction['attachments'] as $row_ticketaction_attachment ) {
		$filename = $row_ticketaction_attachment['attach_filename'] ;
		$attach_filerecord_id = $row_ticketaction_attachment['attach_filerecord_id'] ;
		
		media_contextOpen( $_sdomain_id ) ;
		$bin = media_bin_getBinary( media_bin_toolFile_getId('ATTACH',$attach_filerecord_id) ) ;
		media_contextClose() ;
		
		if( $bin ) {
			$mail->addStringAttachment($bin, $filename) ;
		}
	}
	
	if (!$mail->preSend()) {
		// Return the error in the Browser's console
		//echo $mail->ErrorInfo;
		return NULL ;
	}
	
	$buffer = $mail->getSentMIMEMessage();
	
	media_contextOpen( $_sdomain_id ) ;
	$tmp_media_id = media_bin_processBuffer( $buffer ) ;
	media_contextClose() ;
	if( $tmp_media_id ) {
		$arr_ins = array() ;
		$arr_ins['field_EMAIL_MBOX'] = $row_ticketaction['spec_email_from'] ;
		$arr_ins['field_EMAIL_DATE'] = $row_ticketaction['spec_email_date'] ;
		$arr_ins['field_EMAIL_ADR_TO'] = $row_ticketaction['spec_email_to'] ;
		$arr_ins['field_EMAIL_ADR_CC'] = $row_ticketaction['spec_email_cc'] ;
		$arr_ins['field_LINK_TICKETACTION_ID'] = $ticketaction_filerecord_id ;
		$email_filerecord_id = paracrm_lib_data_insertRecord_file( 'EMAIL_OUTBOX', 0, $arr_ins );
		
		media_contextOpen( $_sdomain_id ) ;
		media_bin_move($tmp_media_id,media_bin_toolFile_getId('EMAIL_OUTBOX',$email_filerecord_id)) ;
		media_contextClose() ;
		
		return $email_filerecord_id ;
	}
	
	return NULL ;
}

function specDbsEzeer_lib_email_openFromEmail() {
	$json_cfg = specDbsEzeer_cfg_getConfig() ;
	$map_peopleGroupId_group = array() ;
	foreach( $json_cfg['data']['cfg_people_group'] as $row ) {
		$map_peopleGroupId_group[$row['group_id']] = $row ;
	}
	$map_peopleUserId_user = array() ;
	foreach( $json_cfg['data']['cfg_people_user'] as $row ) {
		$map_peopleUserId_user[$row['user_id']] = $row ;
	}
	
	global $_opDB ;
	
	$query = "UPDATE view_file_EMAIL_INBOX
				SET field_LINK_TICKET_ID='0'
				WHERE field_LINK_TICKET_ID NOT IN (select filerecord_id FROM view_file_TICKET)" ;
	$_opDB->query($query) ;
	
	$arr_email_filerecordIds = array() ;
	$query = "SELECT filerecord_id FROM view_file_EMAIL_INBOX WHERE field_LINK_TICKET_ID='0'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$arr_email_filerecordIds[] = $arr[0] ;
	}
	
	foreach( $arr_email_filerecordIds as $email_filerecord_id ) {
		$prop_people = array() ;
		$prop_people_owner = NULL ;
		$query = "SELECT field_EMAIL_MBOX FROM view_file_EMAIL_INBOX WHERE filerecord_id='{$email_filerecord_id}'" ;
		$email_mbox = $_opDB->query_uniqueValue($query) ;
		
		$people_group_id = $people_user_id = NULL ;
		$query = "SELECT field_MAP_TO_GROUP FROM view_bible_EMAIL_entry WHERE entry_key='$email_mbox'" ;
		if( $tstr = $_opDB->query_uniqueValue($query) ) {
			$ttmp = explode(':',$tstr,2) ;
			$people_group_id = $ttmp[0] ;
			$people_user_id = $ttmp[1] ;
		}
		if( $people_user_id && $map_peopleUserId_user[$people_user_id] ) {
			$prop_people_owner = array(
				'people_type' => 'user',
				'people_id' => $people_user_id,
				'people_txt' => $map_peopleUserId_user[$people_user_id]['user_name']
			);
			$prop_people[] = $prop_people_owner ;
		} elseif( $people_group_id && $map_peopleGroupId_group[$people_group_id] ) {
			$prop_people_owner = array(
				'people_type' => 'group',
				'people_id' => $people_group_id,
				'people_txt' => $map_peopleGroupId_group[$people_group_id]['group_txt']
			);
			$prop_people[] = $prop_people_owner ;
		}
		
		$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
		$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
		media_contextOpen( $_sdomain_id ) ;
		$eml_stream = media_bin_getBinary( media_bin_toolFile_getId('EMAIL_INBOX',$email_filerecord_id) ) ;
		media_contextClose() ;
		
		if( !$eml_stream ) {
			continue ;
		}
		
		$obj_mimeParser = PhpMimeMailParser::getInstance() ;
		$obj_mimeParser->setText($eml_stream) ;
		
		$attachments = array() ;
		foreach( $obj_mimeParser->getAttachments($include_inline=false) as $attach_idx => $objAttach ) {
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			media_contextOpen( $_sdomain_id ) ;
			$binary = stream_get_contents($objAttach->getStream()) ;
			$attachments[] = array(
				'media_filename' => $objAttach->getFilename(),
				'media_id' => media_bin_processBuffer($binary)
			);
			media_contextClose() ;
		}
		
		$from_adr = NULL ;
		foreach( $obj_mimeParser->getAddresses('from') as $adr ) {
			$from_adr = $adr['address'] ;
			break ;
		}
		$to_adrs = array() ;
		foreach( $obj_mimeParser->getAddresses('to') as $adr ) {
			$to_adrs[] = $adr['address'] ;
		}
		$cc_adrs = array() ;
		foreach( $obj_mimeParser->getAddresses('cc') as $adr ) {
			$cc_adrs[] = $adr['address'] ;
		}
		if( $from_adr ) {
			$prop_people[] = array(
				'people_type' => 'email',
				'people_id' => $from_adr,
				'people_txt' => $from_adr
			);
		}
		
		if( $date_obj = DateTime::createFromFormat( 'D, d M Y H:i:s O', trim(preg_replace("/\([^)]+\)/","",$obj_mimeParser->getHeader('date')))) ) {
			$date_ts = $date_obj->getTimestamp() ;
			$date_now = date('Y-m-d H:i:s',$date_ts) ;
		}
		
		$emailfrom_data = array(
			'subject' => $obj_mimeParser->getHeader('subject'),
			'date' => $date_now,
			'from' => $from_adr,
			'to' => implode(',',$to_adrs),
			'cc' => implode(',',$cc_adrs)
		);
		
		// subject processsing
		$subject = $emailfrom_data['subject'] ;
		$subject_clean = specDbsEzeer_lib_email_toolSubject_clean($subject) ;
		
		
		// body ?
		$body_html = $obj_mimeParser->getMessageBody('htmlEmbedded') ;
		if( !$body_html ) {
			$body_html = '<pre>'.$obj_mimeParser->getMessageBody('text').'</pre>' ;
		}
		
		
		// ticket ?
		$ticket_filerecord_id = specDbsEzeer_lib_email_toolSubject_probeTicket($subject) ;
		if( $ticket_filerecord_id ) {
			$json = specDbsEzeer_ticket_getRecord(array(
				'ticket_filerecord_id' => $ticket_filerecord_id
			));
			$row_ticket = $json['data'] ;
			
			// create ticket
			$form_data = array(
				'body_html' => $body_html,
				'prop_people' => $row_ticket['prop_people'],
				'prop_people_owner' => $row_ticket['prop_people_owner'],
				'date_now' => $date_now,
				'prop_links' => $row_ticket['prop_links'],
				'prop_title' => $row_ticket['prop_title'],
				'emailfrom_data' => $emailfrom_data,
				'attachments' => $attachments
			);
			$json = specDbsEzeer_ticket_postAction( array(
				'ticket_filerecord_id' => $ticket_filerecord_id,
				'form_data' => json_encode($form_data)
			));
		} else {
			// create ticket
			$form_data = array(
				'body_html' => $body_html,
				'prop_people' => $prop_people,
				'prop_people_owner' => $prop_people_owner,
				'date_now' => $date_now,
				'prop_links' => array(),
				'prop_title' => $subject_clean,
				'emailfrom_data' => $emailfrom_data,
				'attachments' => $attachments
			);
			$json = specDbsEzeer_ticket_postAction( array(
				'form_data' => json_encode($form_data)
			));
			//print_r($json) ;
		}
		
		$ticket_filerecord_id = $json['ticket_filerecord_id'] ;
		$ticketaction_filerecord_id = $json['ticketaction_filerecord_id'] ;
		
		paracrm_lib_data_updateRecord_file( 'EMAIL_INBOX', array(
			'field_LINK_TICKET_ID' => $ticket_filerecord_id
		),$email_filerecord_id);
		
		
		$do_proxyForward = false ;
		$query = "SELECT field_PROXY_IS_ON, field_PROXY_FORWARD_TO, field_PROXY_SCHEDULE, field_PROXY_FORWARD_INT FROM view_bible_EMAIL_entry WHERE entry_key='$email_mbox'" ;
		$result = $_opDB->query($query);
		$arr = $_opDB->fetch_row($result);
		$cfg_proxyIsOn = !!$arr[0] ;
		$cfg_proxyForwardTo = $arr[1] ;
		$cfg_proxySchedule = json_decode($arr[2],true) ;
		
		$cfg_proxyForwardInt = array_map('trim',explode(',',$arr[3]));
		
		if( $cfg_proxyIsOn ) {
			$date_weekDay = (int)date('w');
			if( $date_weekDay==0 ) {
				$date_weekDay = 7 ;
			}
			$date_htime = date('H:i:s') ;
			
			foreach( $cfg_proxySchedule as $sched ) {
				if( in_array($date_weekDay,$sched['week_days']) && ($date_htime >= $sched['time_start']) && ($date_htime <= $sched['time_end']) ) {
					$do_proxyForward=true ;
					break ;
				}
			}
		}
		if( $do_proxyForward ) {
			$json = specDbsEzeer_ticket_getRecord( array('ticket_filerecord_id'=>$ticket_filerecord_id) ) ;
			$row_ticket = $json['data'];
			$has_ownerUser = false;
			if( $row_ticket['prop_people_owner'] && ($row_ticket['prop_people_owner']['people_type']=='user') ) {
				$has_ownerUser = true;
			}
			$has_lowPriority = false;
			if( $row_ticket['prop_priority'] && ($row_ticket['prop_priority']!='P1') ) {
				$has_lowPriority = true;
			}
			if( $has_ownerUser && $has_lowPriority ) {
				$do_proxyForward = false;
			}
		}
		if( $do_proxyForward ) {
			$adrEmail_forward = $cfg_proxyForwardTo ;
			//adrs email externes ?
			// adr email forward ?
			$external_to = $external_cc = array() ;
			
			$json = specDbsEzeer_ticket_getRecord( array('ticket_filerecord_id'=>$ticket_filerecord_id) ) ;
			foreach( $json['data']['actions'] as $row_ticketaction ) {
				if( $row_ticketaction['spec_email_is_on'] && $row_ticketaction['spec_email_is_inbox'] ) {
					if( $row_ticketaction['spec_email_from'] != $adrEmail_forward ) {
						if( !in_array($row_ticketaction['spec_email_from'],$external_to) ) {
							$external_to[] = $row_ticketaction['spec_email_from'];
						}
						foreach( array_merge(explode(',',$row_ticketaction['spec_email_to']),explode(',',$row_ticketaction['spec_email_cc'])) as $emailadr ) {
							$emailadr = strtolower($emailadr);
							if( !$emailadr ) {
								continue ;
							}
							if( ($emailadr != strtolower($email_mbox)) && !in_array($emailadr,$external_cc) ) {
								$external_cc[] = $emailadr;
							}
						}
					}
				}
			}
			
			$forward_data = $form_data ;
			$forward_data['date_now'] = date('Y-m-d H:i:s');
			unset($forward_data['emailfrom_data']) ;
			if( ($emailfrom_data['from'] == $adrEmail_forward) || in_array($emailfrom_data['from'],$cfg_proxyForwardInt) ) {
				// OUT to external
				$forward_data['outemail_is_on'] = true ;
				$forward_data['outemail_from'] = $email_mbox ;
				$forward_data['outemail_to'] = $external_to ;
				$forward_data['outemail_cc'] = $external_cc ;
			} else {
				// OUT to forward
				$forward_data['outemail_is_on'] = true ;
				$forward_data['outemail_from'] = $email_mbox ;
				$forward_data['outemail_to'] = array($adrEmail_forward) ;
				$forward_data['outemail_cc'] = array() ;
			}
			$json = specDbsEzeer_ticket_postAction( array(
				'ticket_filerecord_id' => $ticket_filerecord_id,
				'form_data' => json_encode($forward_data)
			));

		}
		foreach( $attachments as $attach ) {
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			media_contextOpen( $_sdomain_id ) ;
			media_bin_delete($attach['media_id']);
			media_contextClose() ;
		}
	}
}


function specDbsEzeer_lib_email_toolSubject_clean($subject) {
	$subject = preg_replace("/([\[\(] *)?\b(RE|FW|FWD|TR?) *([-:;)\]][ :;\])-]*|$)|\]+ *$/im","",$subject) ;
	$subject = preg_replace("/\[EZ\#(.+?)\]/","",$subject) ;
	
	return trim($subject) ;
}
function specDbsEzeer_lib_email_toolSubject_addTag( $subject, $ticket_filerecord_id=null ) {
	$subject = preg_replace("/\[EZ\#(.+?)\]/","",$subject) ;
	
	$ctrlchar = md5((string)$ticket_filerecord_id)[0] ;
	if( is_numeric($ctrlchar) ) {
		$ctrlchar = chr(ord($ctrlchar)+55);
	}
	
	$tag = "[EZ#{$ticket_filerecord_id}{$ctrlchar}]" ;
	
	return $tag.' '.trim($subject) ;
}

function specDbsEzeer_lib_email_toolSubject_probeTicket($subject) {
	global $_opDB ;
	
	$ticket_filerecord_id = NULL ;
	while( true ) {
		if( $ticket_filerecord_id = specDbsEzeer_lib_email_toolSubject_probeTicketByTag($subject) ) {
			break ;
		}
		if( $ticket_filerecord_id = specDbsEzeer_lib_email_toolSubject_probeTicketByWords($subject) ) {
			break ;
		}
		break ;
	}
	if( !$ticket_filerecord_id ) {
		return NULL ;
	}
	
	// ticket fusionné ?
	$query = "SELECT count(*) FROM view_file_TICKET_ACTION WHERE filerecord_parent_id='{$ticket_filerecord_id}'" ;
	if( $_opDB->query_uniqueValue($query) == 0 ) {
		$query = "SELECT max(filerecord_parent_id) FROM view_file_TICKET_ACTION WHERE field_BASE_TICKET_ID='{$ticket_filerecord_id}'" ;
		if( $ttmp = $_opDB->query_uniqueValue($query) ) {
			$ticket_filerecord_id = $ttmp ;
		}
	}
	
	// ticket open ?
	$query = "SELECT count(*) FROM view_file_TICKET WHERE filerecord_id='{$ticket_filerecord_id}' AND field_CLOSED_IS_ON='0'" ;
	if( $_opDB->query_uniqueValue($query) == 0 ) {
		$ticket_filerecord_id = NULL ;
	}
	
	return $ticket_filerecord_id ;
}
function specDbsEzeer_lib_email_toolSubject_probeTicketByTag( $subject ) {
//preg_match('@^(?:http://)?([^/]+)@i',"http://www.php.net/index.html", $matches);
	preg_match("/\[EZ\#(.+?)\]/",$subject,$match) ;
	if( !$match ) {
		return NULL ;
	}
	$ttmp = $match[1] ;
	$ticket_filerecord_id = substr($ttmp,0,strlen($ttmp)-1) ;
	
	$input_ctrlchar = substr($ttmp,-1) ;
	$check_ctrlchar = md5((string)$ticket_filerecord_id)[0] ;
	
	$ctrlchar_isValid = false ;
	while( true ) {
		if( $input_ctrlchar == $check_ctrlchar ) {
			$ctrlchar_isValid = true;
			break ;
		}
		if( is_numeric($check_ctrlchar) ) {
			$check_ctrlchar = chr(ord($check_ctrlchar)+55);
			continue ;
		}
		break ;
	}
	if( $ctrlchar_isValid ) {
		return $ticket_filerecord_id ;
	}
	return NULL ;
}
function specDbsEzeer_lib_email_toolSubject_probeTicketByWords($subject) {
	global $_opDB ;
	
	// subject search
	$subject ;
	
	$words = array() ;
	foreach( explode(' ',$subject) as $sword ) {
		if( preg_match_all( "/[0-9]/", $sword ) >= 6 ) {
			$words[] = $sword ;
		}
	}
	
	$ticket_filerecord_id = NULL ;
	usort($words, function($a, $b) {return strlen($a) - strlen($b);});
	foreach( $words as $word ) {
		$query = "SELECT filerecord_parent_id AS ticket_filerecord_id
				, filerecord_id AS ticketaction_filerecord_id
				, JSON_VALUE(field_EMAILFROM_JSON,'$.subject')
				FROM  view_file_TICKET_ACTION
				WHERE JSON_VALUE(field_EMAILFROM_JSON,'$.subject') LIKE '%{$word}%'
				ORDER BY ticketaction_filerecord_id DESC
				LIMIT 1" ;
		$result = $_opDB->query($query) ;
		$arr = $_opDB->fetch_assoc($result) ;
		if( $arr ) {
			$ticket_filerecord_id = $arr['ticket_filerecord_id'] ;
			break ;
		}
	}
	
	return $ticket_filerecord_id ;
}


?>
