<?php

function specDbsEzeer_lib_txtsearch_buildIndex( $ticketaction_filerecord_id, $build_all=false, $debug=false ) {
	global $_opDB ;
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	if( !$ticketaction_filerecord_id && $build_all ) {
		$query = "SELECT filerecord_id
				FROM view_file_TICKET_ACTION
				ORDER BY filerecord_id ASC" ;
		$result = $_opDB->query($query) ;
		$arr_ticketactionFilerecordIds = array() ;
		while( ($arr=$_opDB->fetch_row($result)) != FALSE ) {
			$filerecord_id = $arr[0] ;
			
			$arr_ticketactionFilerecordIds[] = $filerecord_id ;
		}
	} elseif( !$build_all && $ticketaction_filerecord_id > 0 ) {
		$arr_ticketactionFilerecordIds = array($ticketaction_filerecord_id) ;
	} else {
		return ;
	}

	$map_word_taIds = array() ;

	media_contextOpen( $_sdomain_id ) ;
	$cnt = 0 ;
	foreach( $arr_ticketactionFilerecordIds as $ticketaction_filerecord_id ) {
		$query = "SELECT filerecord_id, field_BODY_HTML, field_BODY_TXT
					, IF(JSON_VALID(field_EMAILFROM_JSON),1,0) AS EMAIL_IS_INBOX
					, IF(JSON_VALID(field_EMAILTO_JSON),1,0) AS EMAIL_IS_OUTBOX
				FROM view_file_TICKET_ACTION WHERE filerecord_id='{$ticketaction_filerecord_id}'" ;
		$result = $_opDB->query($query) ;
		$arr = $_opDB->fetch_row($result) ;
		
		$is_html = !!$arr[1];
		$body_txt = !$is_html ? $arr[2] : '';
		
		$is_inbox = !!$arr[3];
		$is_outbox = !!$arr[4];
		
		if( !$is_html && !trim($body_txt) ) {
			continue ;
		}
		if( $is_outbox ) {
			continue ;
		}
		$binary_html = NULL ;
		if( $is_html ) {
			$binary_html = media_bin_getBinary(media_bin_toolFile_getId('TICKET_ACTION',$ticketaction_filerecord_id)) ;
			if( !$binary_html ) {
				//echo "$ticketaction_filerecord_id ???\n\n" ;
				continue ;
			}
			if( $is_inbox ) {
				$binary_html = specDbsEzeer_lib_domdoc_email_stripCitationIf($binary_html) ;
			}
			$body_txt = strip_tags($binary_html) ;
		}
		
		if( !trim($body_txt) ) {
			continue ;
		}
		
		$string = $body_txt ;
		$string = iconv('UTF-8','ASCII//TRANSLIT//IGNORE',$string);
		$string = trim(preg_replace('/\s+/', ' ', $string));
		$string = strtolower($string) ;
		$words = array_unique(explode(' ',$string));
		
		if( $debug ) {
			echo $ticketaction_filerecord_id."\n" ;
			echo "    html=".strlen($binary_html)."\n" ;
			echo "     txt=".strlen($body_txt)."\n" ;
			echo "\n" ;
		}
		
		$cnt++ ;
		foreach( $words as $word ) {
			if( !isset($map_word_taIds[$word]) ) {
				$map_word_taIds[$word] = array() ;
			}
			$map_word_taIds[$word][] = $ticketaction_filerecord_id ;
		}
	}
	media_contextClose() ;
	
	$file_code = 'ZCACHE_TXTSEARCH' ;
	if( $build_all ) {
		$t = new DatabaseMgr_Sdomain( DatabaseMgr_Base::dbCurrent_getDomainId() );
		$t->sdomainDefine_truncateFile( DatabaseMgr_Sdomain::dbCurrent_getSdomainId(), $file_code, false ) ;
	}
	foreach( $map_word_taIds as $word => $taIds ) {
		$mysql_word = $_opDB->escape_string($word) ;
		
		$query = "SELECT filerecord_id FROM view_file_{$file_code} WHERE field_TXT_STR='{$mysql_word}'" ;
		$cache_filerecordId = $_opDB->query_uniqueValue($query);
		$db_taIds = array() ;
		if( $cache_filerecordId ) {
			$query = "SELECT field_JSON_TKTACTION_IDS FROM view_file_{$file_code} WHERE filerecord_id='{$cache_filerecordId}'" ;
			$db_taIds = json_decode($_opDB->query_uniqueValue($query),true) ;
			if( !is_array($db_taIds) ) {
				$db_taIds = array() ;
			}
		}
		$db_taIds = array_unique(array_merge($db_taIds,$taIds)) ;
		$arr_update = array(
			'field_IGNORE_ON' => count($db_taIds) > 20,
			'field_COUNT_IDS' => count($db_taIds),
			'field_JSON_TKTACTION_IDS' => json_encode($db_taIds),
		);
		if( $cache_filerecordId ) {
			paracrm_lib_data_updateRecord_file( $file_code, $arr_update, $cache_filerecordId );
		} else {
			$arr_ins = $arr_update + array('field_TXT_STR'=>$word) ;
			paracrm_lib_data_insertRecord_file( $file_code, 0, $arr_ins );
		}
	}
}

?>
