<?php

define( 'DBS_EZEER_SEARCHMAX', 20000 ) ;

function specDbsEzeer_ticket_getListNotifications($post_data) {
	global $_opDB ;
	
	$login_userId = specDbsEzeer_util_getLogUser(true) ;
	if( !$login_userId ) {
		return array('success'=>true, 'data'=>array()) ;
	}
	
	$query = "SELECT n.filerecord_id AS notification_filerecord_id
			, t.filerecord_id AS ticket_filerecord_id
			, t.field_PROP_TITLE AS ticket_title
			, n.*
				FROM view_file_NOTIFICATION n
				JOIN view_file_TICKET t ON t.filerecord_id = n.field_TICKET_ID
				WHERE n.field_TARGET_USER='{$login_userId}' AND t.field_CLOSED_IS_ON='0'" ;
	$result = $_opDB->query($query) ;
	$TAB = array() ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$TAB[] = array(
			'notification_filerecord_id' => $arr['notification_filerecord_id'],
			'ticket_filerecord_id' => $arr['ticket_filerecord_id'],
			'ticket_title' => $arr['ticket_title'],
			'notification_date' => $arr['field_NOTIFICATION_DATE'],
			'notification_txt' => $arr['field_NOTIFICATION_TXT']
		);
	}
	return array('success'=>true, 'data'=>$TAB) ;
}

function specDbsEzeer_ticket_getList($post_data) {
	global $_opDB ;
	
	$json_cfg = specDbsEzeer_cfg_getConfig() ;
	$map_userId_groupIds = array() ;
	foreach( $json_cfg['data']['cfg_people_user'] as $row ) {
		$map_userId_groupIds[$row['user_id']] = $row['group_ids'] ;
	}
	$map_groupId_arrUserIds = array() ;
	foreach( $json_cfg['data']['cfg_people_group'] as $row ) {
		$map_groupId_arrUserIds[$row['group_id']] = $row['user_ids'] ;
	}
	
	$date_now = date('Y-m-d') ;
	
	
	if( $post_data['filter_ticketFilerecordId'] ) {
		$p_filter_ticketFilerecordId = $post_data['filter_ticketFilerecordId'] ;
	}
	if( $post_data['postfilter_data'] ) {
		$_postFilter_data = json_decode($post_data['postfilter_data'],true) ;
	}
	
	if( $_postFilter_data['filter_ticketFilerecordId'] ) {
		$p_filter_ticketFilerecordId = $_postFilter_data['filter_ticketFilerecordId'] ;
		$search_linked = true ;
	}
	
	$scope_viewTicket = "SELECT * FROM view_file_TICKET t WHERE 1" ;
	while( true ) {
		if( $p_filter_ticketFilerecordId ) {
			$arr_ids = array($p_filter_ticketFilerecordId) ;
			if( $search_linked ) {
				$subquery = "SELECT filerecord_parent_id FROM view_file_TICKET_ACTION WHERE field_BASE_TICKET_ID='{$p_filter_ticketFilerecordId}'" ;
				$res = $_opDB->query($subquery) ;
				while( ($arr = $_opDB->fetch_row($res)) != FALSE ) {
					$arr_ids[] = $arr[0];
				}
			}
			$list_ids = $_opDB->makeSQLlist($arr_ids) ;
			$scope_viewTicket.= " AND ( filerecord_id IN {$list_ids} )" ;
			break ;
		}
		if( $_postFilter_data['search_dates'] ) {
			$tdates = $_postFilter_data['search_dates'] ;
			$scope_viewTicket.= " AND DATE(field_DATE_CREATE)<='{$tdates['date_end']}'" ;
			$scope_viewTicket.= " AND (field_CLOSED_IS_ON='0' OR DATE(field_CLOSED_DATE)>='{$tdates['date_start']}')" ;
			$has_search = TRUE ;
			break ;
		}
		if( $search_txt = $_opDB->escape_string($_postFilter_data['search_txt']) ) {
			$scope_viewTicket.= " AND ( 0" ;
			if( $search_txt[0] != '#' ) {
				$scope_viewTicket.= " OR field_PROP_TITLE LIKE '%{$search_txt}%'" ;
			}
			
			$isMaybeById = NULL ;
			if( $search_txt[0] == '#' ) {
				$search_txt = substr($search_txt,1) ;
			}
			if( is_numeric($search_txt) || is_numeric(substr($search_txt,0,strlen($search_txt)-1)) ) {
				$isMaybeById = $search_txt;
			}
			$searchIds = array() ;
			if( $isMaybeById ) {
				if( is_numeric($isMaybeById) ) {
					$searchIds[] = $isMaybeById ;
				}
				
				$strip_id = substr($isMaybeById,0,strlen($isMaybeById)-1) ;
				$strip_ctrlchar = substr($isMaybeById,-1) ;
				$check_ctrlchar = md5((string)$strip_id)[0] ;
				$ctrlchar_isValid = false ;
				while( true ) {
					if( $strip_ctrlchar == $check_ctrlchar ) {
						$ctrlchar_isValid = true;
						break ;
					}
					if( is_numeric($check_ctrlchar) ) {
						$check_ctrlchar = chr(ord($check_ctrlchar)+55);
						continue ;
					}
					break ;
				}
				if( $ctrlchar_isValid ) {
					$searchIds[] = $strip_id ;
				}
				
				if( $searchIds ) {
					if( count($searchIds)==1 ) {
						$baseFilerecordId = $searchIds[0] ;
						$subquery = "SELECT filerecord_parent_id FROM view_file_TICKET_ACTION WHERE field_BASE_TICKET_ID='{$baseFilerecordId}'" ;
						$res = $_opDB->query($subquery) ;
						while( ($arr = $_opDB->fetch_row($res)) != FALSE ) {
							$tid = $arr[0];
							if( !in_array($tid,$searchIds) ) {
								$searchIds[] = $tid;
							}
						}
					}
					$list_ids = $_opDB->makeSQLlist($searchIds) ;
					$scope_viewTicket.= " OR ( filerecord_id IN {$list_ids} )" ;
				}
			}
			$scope_viewTicket.= " )" ;
			
			$has_search = TRUE ;
			break ;
		}
		$scope_viewTicket.= " AND field_CLOSED_IS_ON='0'" ;
		break;
	}
	
	if( $has_search ) {
		$query_cnt = "SELECT count(*) FROM ($scope_viewTicket) t WHERE filerecord_id IN (SELECT distinct filerecord_parent_id FROM view_file_TICKET_ACTION)" ; 
		if( ($cnt = $_opDB->query_uniqueValue($query_cnt)) > DBS_EZEER_SEARCHMAX ) {
			return array('success'=>false, 'error'=>'Max reached', 'count'=>$cnt) ;
		}
	}
	
	
	$query = "SELECT t.*, IF(n.ticket_filerecord_id IS NULL,'0','1') AS notification_is_on" ;
	$query.= " FROM ({$scope_viewTicket}) t" ;
	$query.= " JOIN (SELECT filerecord_parent_id AS ticket_filerecord_id FROM view_file_TICKET_ACTION ta GROUP BY filerecord_parent_id) ta" ;
		$query.= " ON ta.ticket_filerecord_id=t.filerecord_id" ;
	$query.= " LEFT OUTER JOIN (SELECT field_TICKET_ID as ticket_filerecord_id FROM view_file_NOTIFICATION GROUP BY ticket_filerecord_id) n" ;
		$query.= " ON n.ticket_filerecord_id = t.filerecord_id" ;
	$query.= " WHERE 1" ;
	$result = $_opDB->query($query) ;
	$TAB_tickets = array() ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticket_filerecord_id = $arr['filerecord_id'] ;
		$row = array(
			'ticket_filerecord_id' => $ticket_filerecord_id,
			'prop_title' => $arr['field_PROP_TITLE'],
			'prop_category' => $arr['field_PROP_CATEGORY'],
			'prop_category_main' => $arr['field_PROP_CATEGORY'],
			'prop_category_lists' => json_decode($arr['field_PROP_CATEGORY_LISTS'],true),
			'prop_origin' => $arr['field_PROP_ORIGIN'],
			'prop_priority' => $arr['field_PROP_PRIORITY'],
			'prop_links' => array(),
			
			'prop_people' => array(),
			'prop_people_owner' => null,
			
			'date_create' => $arr['field_DATE_CREATE'],
			'date_update' => $arr['field_DATE_UPDATE'],
			'date_due' => $arr['field_DATE_DUE'],
			
			'closed_is_on' => !!$arr['field_CLOSED_IS_ON'],
			'closed_date' => $arr['field_CLOSED_DATE'],
			'closed_code' => $arr['field_CLOSED_CODE'],
			'closed_feedback' => $arr['field_CLOSED_FEEDBACK'],
			
			'notification_is_on' => !!$arr['notification_is_on'],
			
			'status_is_new' => $arr['field_STATUS_IS_NEW'],
			
			'_dummy' => false
		);
		if( count($ttmp = explode('+',$row['prop_category'],2)) > 1 ) {
			$row['prop_category_main'] = $ttmp[0] ;
		}
		$TAB_tickets[$ticket_filerecord_id] = $row ;
	}
	
	
	$query = "SELECT assign.ticket_filerecord_id
					,assign.ticketassign_filerecord_id
					,ppl.field_PEOPLE_TYPE as assign_people_type
					,ppl.field_PEOPLE_ID as assign_people_id
					,ppl.field_OWNER_IS_ON as assign_is_owner
					,ta.field_DATE_ASSIGN as date_review
					,ta.field_ASSIGN_IS_TMP as assign_is_tmp
				FROM ({$scope_viewTicket}) t
				JOIN (
					SELECT filerecord_parent_id as ticket_filerecord_id
							, MAX(filerecord_id) as ticketassign_filerecord_id
					FROM view_file_TICKET_ASSIGN
					WHERE field_ASSIGN_IS_ON='1'
					GROUP BY filerecord_parent_id
				) assign ON assign.ticket_filerecord_id=t.filerecord_id
				JOIN view_file_TICKET_ASSIGN ta ON ta.filerecord_id = assign.ticketassign_filerecord_id
				JOIN view_file_TICKET_PROP_PEOPLE ppl ON ppl.filerecord_id=ta.field_PROPPEOPLE_ID" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticket_filerecord_id = $arr['ticket_filerecord_id'] ;
		if( !($row_ticket = $TAB_tickets[$ticket_filerecord_id]) ) {
			continue ;
		}
		
		$row = array(
			'ticketassign_filerecord_id' => $arr['ticketassign_filerecord_id'],
			'assign_people_type' => $arr['assign_people_type'],
			'assign_people_id' => $arr['assign_people_id'],
			'date_review' => !$row_ticket['closed_is_on'] ? $arr['date_review'] : null,
			'date_review_is_late' => !$row_ticket['closed_is_on'] ? ($arr['date_review']<$date_now) : false,
			'assign_is_owner' => !!$arr['assign_is_owner'],
			'assign_is_ext' => !$arr['assign_is_owner'],
			'assign_is_ext_tmp' => ( !$arr['assign_is_owner'] && !!$arr['assign_is_tmp'] )
		) ;
		$TAB_tickets[$ticket_filerecord_id]+= $row ;
	}
	
	
	
	$query = "SELECT tpp.* FROM ({$scope_viewTicket}) t
		JOIN view_file_TICKET_PROP_PEOPLE tpp ON tpp.filerecord_parent_id=t.filerecord_id" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticket_filerecord_id = $arr['filerecord_parent_id'] ;
		$row_ticket = $TAB_tickets[$ticket_filerecord_id] ;
		if( !$row_ticket ) {
			continue ;
		}
		
		$row_people = array(
			'proppeople_filerecord_id' => $arr['filerecord_id'],
			
			'people_type' => $arr['field_PEOPLE_TYPE'],
			'people_id' => $arr['field_PEOPLE_ID'],
			'people_txt' => $arr['field_PEOPLE_TXT'],
			'owner_is_on' => !!$arr['field_OWNER_IS_ON']
		);
		if( $row_ticket['assign_people_type'].'|'.$row_ticket['assign_people_id'] == $row_people['people_type'].'|'.$row_people['people_id'] ) {
			$row_people['assign_is_on'] = TRUE ;
		}
		
		$TAB_tickets[$ticket_filerecord_id]['prop_people'][] = $row_people ;
		if( $row_people['owner_is_on'] ) {
			$TAB_tickets[$ticket_filerecord_id]['prop_people_owner'] = $row_people ;
		}
	}
	
	$query = "SELECT tpl.* FROM ({$scope_viewTicket}) t
		JOIN view_file_TICKET_PROP_LINK tpl ON tpl.filerecord_parent_id=t.filerecord_id" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticket_filerecord_id = $arr['filerecord_parent_id'] ;
		if( !$TAB_tickets[$ticket_filerecord_id] ) {
			continue ;
		}
		$TAB_tickets[$ticket_filerecord_id]['prop_links'][] = array(
			'proplink_filerecord_id' => $arr['filerecord_id'],
			
			'link_cfgcode' => $arr['field_LINK_CFGCODE'],
			'link_id' => $arr['field_LINK_ID'],
			'link_txt' => $arr['field_LINK_TXT']
		);
	}
	
	if( TRUE ) {
		$query = "SELECT t.filerecord_id AS ticket_filerecord_id
						, ta_min.field_EMAILFROM_JSON AS min_emailfromjson
						, ta_max.field_ACTION_USER AS max_actionuser
						, ta_max.field_EMAILFROM_JSON AS max_emailfromjson
						FROM ({$scope_viewTicket}) t
						JOIN (
							SELECT filerecord_parent_id as ticket_filerecord_id
							, min(filerecord_id) as minaction_filerecord_id 
							FROM view_file_TICKET_ACTION 
							GROUP BY filerecord_parent_id
						) tmin ON tmin.ticket_filerecord_id=t.filerecord_id
						JOIN (
							SELECT filerecord_parent_id as ticket_filerecord_id
							, max(filerecord_id) as maxaction_filerecord_id 
							FROM view_file_TICKET_ACTION 
							GROUP BY filerecord_parent_id
						) tmax ON tmax.ticket_filerecord_id=t.filerecord_id
						JOIN view_file_TICKET_ACTION ta_min ON ta_min.filerecord_id=tmin.minaction_filerecord_id
						JOIN view_file_TICKET_ACTION ta_max ON ta_max.filerecord_id=tmax.maxaction_filerecord_id" ;
		$result = $_opDB->query($query) ;
		while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
			$ticket_filerecord_id = $arr['ticket_filerecord_id'] ;
			if( !isset($TAB_tickets[$ticket_filerecord_id]) ) {
					continue ;
			}
			
			// min
			if( $arr['min_emailfromjson'] ) {
				$tarr = json_decode($arr['min_emailfromjson'],true) ;
				$TAB_tickets[$ticket_filerecord_id]['spec_email_from'] = $tarr['from'] ;
			}
			// max 
			if( $arr['max_actionuser'] ) {
				$TAB_tickets[$ticket_filerecord_id] += array(
					'lastaction_people_type'=>'user',
					'lastaction_people_id'=>$arr['max_actionuser'],
				);
			} elseif( $tarr = json_decode($arr['max_emailfromjson'],true) ) {
				$TAB_tickets[$ticket_filerecord_id] += array(
					'lastaction_people_type'=>'email',
					'lastaction_people_id'=>$tarr['from'],
				);
			} else {
				
			}
		}
	}
	
	if( $post_data['postfilter_data'] ) {
		$TAB_tickets_filtered = array() ;
		foreach( $TAB_tickets as $row_ticket ) {
			if( $_postFilter_data['people'] ) {
				$ttmp = explode('|',$_postFilter_data['people']) ;
				$filter_people_type = $ttmp[0] ;
				$filter_people_id = $ttmp[1] ;
				$filter_nouser = ($ttmp[2]=='nouser') ;
				
				$pass = FALSE ;
				switch( $filter_people_type ) {
					case 'group' :
						// ticket dans le groupe ?
						$hasAnyUser = FALSE ;
						foreach( $row_ticket['prop_people'] as $row_ticketPeople ) {
							if( ($row_ticketPeople['people_type'] == 'group') && ($row_ticketPeople['people_id'] == $filter_people_id) ) {
								$pass = TRUE ;
							}
							if( ($row_ticketPeople['people_type'] == 'user')
								&& isset($map_userId_groupIds[$row_ticketPeople['people_id']])
								&& in_array($filter_people_id,$map_userId_groupIds[$row_ticketPeople['people_id']]) ) {
								$hasAnyUser = TRUE ;
							}
						}
						if( $filter_nouser && $hasAnyUser ) {
							$pass = FALSE ;
						}
						break ;
						
					case 'user' :
						// ticket user ?
						foreach( $row_ticket['prop_people'] as $row_ticketPeople ) {
							if( ($row_ticketPeople['people_type'] == 'user') && ($row_ticketPeople['people_id'] == $filter_people_id) ) {
								$pass = TRUE ;
								break ;
							}
						}
						break ;
				}
				if( !$pass ) {
					continue ;
				}
			}
			
			if( $_postFilter_data['priority'] ) {
				if( $row_ticket['prop_priority'] <= $_postFilter_data['priority'] ) {
					// pass
				} else {
					continue ;
				}
			}
			
			if( $_postFilter_data['category'] ) {
				if( $row_ticket['prop_category_main'] != $_postFilter_data['category'] ) {
					continue ;
				}
				if( $_postFilter_data['category_lists'] ) {
					$subCategories_filtered = false ;
					foreach( $_postFilter_data['category_lists'] as $list_id => $list_value ) {
						if( $list_value=='*' ) {
							if( !$row_ticket['prop_category_lists'][$list_id] ) {
								$subCategories_filtered = true ;
							}
						} else {
							if( $row_ticket['prop_category_lists'][$list_id] != $list_value ) {
								$subCategories_filtered = true ;
							}
						}
					}
					if( $subCategories_filtered ) {
						continue ;
					}
				}
			}
			
			$TAB_tickets_filtered[] = $row_ticket ;
		}
		$TAB_tickets = $TAB_tickets_filtered ;
	}
	
	// Logged-in user : filtrage des tickets hors-scope
	// => groupes accessibles $login_userId
	// Itération sur tickets
	// => pas de groupe => pass
	// => foreach groups => user IN group ? => pass
	if( $login_userId = specDbsEzeer_util_getLogUser(true) ) {
		$allowed_group_ids = $map_userId_groupIds[$login_userId] ;
		foreach( $TAB_tickets as &$row_ticket ) {
			// props :
			// - login_is_exclude{group/user}
			$hasNoGroup = TRUE ;
			$userPassed = FALSE ;
			foreach( $row_ticket['prop_people'] as $row ) {
				if( $row['people_type']=='group' ) {
					$hasNoGroup = FALSE ;
					if( in_array($row['people_id'],$allowed_group_ids) ) {
						$userPassed = TRUE ;
					}
				}
				if( ($row['people_type']=='user') && ($row['people_id']==$login_userId) ) {
					$userPassed = TRUE ;
				}
			}
			if( !$hasNoGroup && !$userPassed ) {
				$row_ticket['login_is_exclude'] = TRUE ;
			}
		}
		unset($row_ticket) ;
		
		$new_TAB = array() ;
		foreach( $TAB_tickets as $ticket_filerecord_id => $row_ticket ) {
			if( $row_ticket['login_is_exclude'] ) {
				continue ;
			}
			$new_TAB[$ticket_filerecord_id] = $row_ticket ;
		}
		$TAB_tickets = $new_TAB ;
	}
	
	// Logged-in user : ajout des propriétés IS_OWNER / IS_ASSIGNED
	if( $login_userId = specDbsEzeer_util_getLogUser(true) ) {
		$login_groupId = $map_userId_groupId[$login_userId] ;
		foreach( $TAB_tickets as &$row_ticket ) {
			$is_owner = $is_assign = false ;
			
			switch( $row_ticket['prop_people_owner']['people_type'] ) {
				case 'group' :
					if( $login_groupId == $row_ticket['prop_people_owner']['people_id'] ) {
						$is_owner = TRUE ;
					}
					break ;
				case 'user' :
					if( $login_userId == $row_ticket['prop_people_owner']['people_id'] ) {
						$is_owner = TRUE ;
					}
					break ;
			}
			
			switch( $row_ticket['assign_people_type'] ) {
				case 'group' :
					if( $login_groupId == $row_ticket['assign_people_id'] ) {
						$is_assign = TRUE ;
					}
					break ;
				case 'user' :
					if( $login_userId == $row_ticket['assign_people_id'] ) {
						$is_assign = TRUE ;
					}
					break ;
			}
			
			$is_owner_ext = ($is_owner && !$is_assign) ;
			
			$row_ticket['login_is_owner'] = $is_owner ;
			$row_ticket['login_is_owner_ext'] = $is_owner_ext ;
			$row_ticket['login_is_assign'] = $is_assign ;
		}
		unset($row_ticket) ;
	}
	
	return array('success'=>true, 'data'=>array_values($TAB_tickets)) ;
}

function specDbsEzeer_ticket_getExplorerCounters( $post_data ) {
	global $_opDB ;
	
	$json_cfg = specDbsEzeer_cfg_getConfig() ;
	$map_userId_groupIds = array() ;
	foreach( $json_cfg['data']['cfg_people_user'] as $row ) {
		$map_userId_groupIds[$row['user_id']] = $row['group_ids'] ;
	}
	
	$allowed_group_ids = null ;
	if( $login_userId = specDbsEzeer_util_getLogUser(true) ) {
		$allowed_group_ids = $map_userId_groupIds[$login_userId] ;
	}
	
	$filter_group_ids = null ;
	if( $post_data['postfilter_data'] ) {
		$_postFilter_data = json_decode($post_data['postfilter_data'],true) ;
		if( $_postFilter_data['people'] ) {
			$ttmp = explode('|',$_postFilter_data['people']) ;
			$filter_people_type = $ttmp[0] ;
			$filter_people_id = $ttmp[1] ;
			$filter_nouser = ($ttmp[2]=='nouser') ;
			
			$pass = FALSE ;
			switch( $filter_people_type ) {
				case 'group' :
					$filter_group_ids = array($filter_people_id);
					break ;
					
				case 'user' :
					$filter_group_ids = $map_userId_groupIds[$filter_people_id];
					break ;
			}
		}
	}
	
	$filter_groups = null ;
	if( is_array($allowed_group_ids) || is_array($filter_group_ids) ) {
		$filters = array() ;
		if( is_array($allowed_group_ids) ) {
			$filters[] = $allowed_group_ids;
		}
		if( is_array($filter_group_ids) ) {
			$filters[] = $filter_group_ids;
		}
		if( count($filters) > 1 ) {
			$filter_groups = array_intersect(...$filters) ;
		} else {
			$filter_groups = reset($filters);
		}
	}
	
	$whereClause_groups = '' ;
	if( is_array($filter_groups) ) {
		$whereClause_groups = "AND pg.field_PEOPLE_ID IN ".$_opDB->makeSQLlist($filter_groups);
	}
	$query = "SELECT count(ticket_filerecord_id) AS urgent_int
			, SUM(IF(is_unassigned,'1','0')) AS urgent_int_unassigned
			FROM (
				SELECT t.filerecord_id AS ticket_filerecord_id
					, IF(po.filerecord_id IS NULL,'1','0') AS is_unassigned
				FROM view_file_TICKET t
				LEFT OUTER JOIN view_file_TICKET_PROP_PEOPLE pg
					ON pg.filerecord_parent_id=t.filerecord_id AND pg.field_PEOPLE_TYPE='group'
				LEFT OUTER JOIN view_file_TICKET_PROP_PEOPLE po
					ON po.filerecord_parent_id=t.filerecord_id
					AND po.field_PEOPLE_TYPE='user' AND po.field_OWNER_IS_ON='1'
				WHERE field_PROP_PRIORITY='P1' AND field_CLOSED_IS_ON='0'
				{$whereClause_groups}
				AND t.filerecord_id IN (select filerecord_parent_id FROM view_file_TICKET_ACTION)
				GROUP BY t.filerecord_id
			) src";
	$result = $_opDB->query($query);
	$arr = $_opDB->fetch_assoc($result) ;
	
	$data = array(
		'urgent_int' => $arr['urgent_int'] > 0 ? $arr['urgent_int'] : null,
		'urgent_int_unassigned' => $arr['urgent_int_unassigned'] > 0 ? $arr['urgent_int_unassigned'] : null,
	);
	
	return array('success'=>true,'data'=>$data,'debug'=>$filter_groups);
}

function specDbsEzeer_ticket_searchDeep( $post_data ) {
	global $_opDB ;
	
	// TODO : test sur 80468037
	
	$p_searchTxt = $_opDB->escape_string($post_data['search_txt']);
	
	$scope_viewTicket = "SELECT * FROM view_file_TICKET WHERE 1" ;
	$scope_viewTicket.= " AND filerecord_id IN (SELECT distinct filerecord_parent_id FROM view_file_TICKET_ACTION)" ;
	
	$map_ticketId_data = array() ;
	$query = "SELECT filerecord_id, field_PROP_TITLE, field_DATE_UPDATE FROM ($scope_viewTicket) t WHERE t.field_PROP_TITLE LIKE '%{$p_searchTxt}%'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$ticket_filerecord_id = $arr[0] ;
		if( !$map_ticketId_data[$ticket_filerecord_id] ) {
			$map_ticketId_data[$ticket_filerecord_id] = array(
				'ticket_filerecord_id' => $ticket_filerecord_id,
				'action_date' => $arr[2],
				'action_type' => 'title',
				'match_txt' => $arr[1],
			);
		}
	}
	
	$query = "SELECT filerecord_parent_id, JSON_VALUE( field_EMAILFROM_JSON, '$.date' ), JSON_VALUE( field_EMAILFROM_JSON, '$.subject' )
				FROM view_file_TICKET_ACTION
				WHERE field_EMAILFROM_JSON<>''
				AND JSON_VALUE( field_EMAILFROM_JSON, '$.subject' ) LIKE '%{$p_searchTxt}%'
				ORDER BY JSON_VALUE( field_EMAILFROM_JSON, '$.date' ) DESC" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$ticket_filerecord_id = $arr[0] ;
		if( !$map_ticketId_data[$ticket_filerecord_id] ) {
			$map_ticketId_data[$ticket_filerecord_id] = array(
				'ticket_filerecord_id' => $ticket_filerecord_id,
				'action_date' => $arr[1],
				'action_type' => 'email_from',
				'match_txt' => $arr[2],
			);
		}
	}
	
	$zcache_txtsearch = FALSE ;
	$query = "SHOW TABLES LIKE 'view_file_ZCACHE_TXTSEARCH'" ;
	if( $_opDB->query_uniqueValue($query) ) {
		$zcache_txtsearch = TRUE ;
	}
	if( $zcache_txtsearch && strlen($p_searchTxt) > 6 ) {
		$arr_taIds = array() ;
		$query = "SELECT field_TXT_STR, field_JSON_TKTACTION_IDS FROM view_file_ZCACHE_TXTSEARCH
				WHERE field_TXT_STR LIKE '%{$p_searchTxt}%' AND field_IGNORE_ON='0'" ;
		$result = $_opDB->query($query) ;
		while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
			$match = $arr[0] ;
			$tarr = json_decode($arr[1],true) ;
			if( is_array($tarr) ) {
				$arr_taIds = array_merge($arr_taIds,$tarr) ;
			}
		}
		foreach( $arr_taIds as $ticketaction_filerecord_id ) {
			$query = "SELECT t.filerecord_id, ta.field_ACTION_DATE, t.field_PROP_TITLE
					FROM view_file_TICKET_ACTION ta
					JOIN view_file_TICKET t ON t.filerecord_id=ta.filerecord_parent_id
					WHERE ta.filerecord_id='{$ticketaction_filerecord_id}'" ;
			$result = $_opDB->query($query) ;
			while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
				$ticket_filerecord_id = $arr[0];
				if( !$map_ticketId_data[$ticket_filerecord_id] ) {
					$map_ticketId_data[$ticket_filerecord_id] = array(
						'ticket_filerecord_id' => $ticket_filerecord_id,
						'action_date' => $arr[1],
						'action_type' => 'body',
						'match_txt' => '('.$match.')'.' '.$arr[2],
					);
				}
			}
		}
	}
	
	$tab_result = array_values($map_ticketId_data) ;
	$fn_sortLigs = function($r1,$r2) {
		return strcmp($tab_result['action_date'],$tab_result['action_date']) ;
	};
	usort($tab_result,$fn_sortLigs);
	
	return array('success'=>true, 'data'=>$tab_result) ;
}

function specDbsEzeer_ticket_getRecord( $post_data ) {
	global $_opDB ;
	usleep(100*1000) ;
	
	if( $post_data['do_flag'] && ($login_userId = specDbsEzeer_util_getLogUser(true)) ) {
		$query = "SELECT filerecord_id FROM view_file_NOTIFICATION WHERE field_TICKET_ID='{$post_data['ticket_filerecord_id']}' AND field_TARGET_USER='{$login_userId}'" ;
		$notification_filerecord_id = $_opDB->query_uniqueValue($query) ;
		if( $notification_filerecord_id ) {
			paracrm_lib_data_deleteRecord_file( 'NOTIFICATION', $notification_filerecord_id );
		}
	}
	
	$json = specDbsEzeer_ticket_getList(array('filter_ticketFilerecordId'=>$post_data['ticket_filerecord_id'])) ;
	if( !$json['success'] || (count($json['data'])!=1) ) {
		if( $post_data['do_flag'] ) {
			// #FILIPE deep search
			$query = "select filerecord_parent_id FROM view_file_TICKET_ACTION WHERE field_BASE_TICKET_ID='{$post_data['ticket_filerecord_id']}'" ;
			$next_ticket_filerecord_id = $_opDB->query_uniqueValue($query) ;
			if( $next_ticket_filerecord_id && ($next_ticket_filerecord_id != $post_data['ticket_filerecord_id']) ) {
				$post_data['ticket_filerecord_id'] = $next_ticket_filerecord_id ;
				return specDbsEzeer_ticket_getRecord($post_data) ;
			}
		}
		return array('success'=>false) ;
	}
	$row_ticket = reset($json['data']) ;
	if( $row_ticket['ticket_filerecord_id'] != $post_data['ticket_filerecord_id'] ) {
		return array('success'=>false) ;
	}
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	media_contextOpen( $_sdomain_id ) ;
	
	$TAB_actions = array() ;
	
	$query = "SELECT * FROM view_file_TICKET_ACTION" ;
	$query.= " WHERE filerecord_parent_id='{$post_data['ticket_filerecord_id']}'" ;
	if( $post_data['preview_mode'] ) {
		$query.= " ORDER BY filerecord_id DESC LIMIT 1" ;
	}
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticketaction_filerecord_id = $arr['filerecord_id'] ;
		
		$changeprops = array() ;
		if( $tarr = json_decode($arr['field_CHANGEPROPS_JSON'],true) ) {
			foreach( $tarr as $trow ) {
				$changeprops[] = array(
					'propchange_sign' => $trow['sign'],
					'propchange_type' => $trow['type'],
					'propchange_id' => $trow['id'],
					'propchange_txt' => $trow['txt']
				);
			}
		}
		
		$row_ticketaction = array(
			'ticketaction_filerecord_id' => $ticketaction_filerecord_id,
			'ticket_base_filerecord_id' => $arr['field_BASE_TICKET_ID'],
			'ticket_filerecord_id' => $arr['filerecord_parent_id'],
			
			'action_user' => $arr['field_ACTION_USER'],
			'action_date' => $arr['field_ACTION_DATE'],
			
			'body_txt' => $arr['field_BODY_TXT'],
			'body_html' => null,
			
			'changeprops' => $changeprops,
			'attachments' => array(),
			
			'_dummy' => false
		);
		if( $tarr = json_decode($arr['field_EMAILFROM_JSON'],true) ) {
			$row_ticketaction += array(
				'spec_email_is_on' => true,
				'spec_email_is_inbox' => true,
				'spec_email_subject' => $tarr['subject'],
				'spec_email_date' => $tarr['date'],
				'spec_email_from' => $tarr['from'],
				'spec_email_to' => $tarr['to'],
				'spec_email_cc' => $tarr['cc']
			);
		} elseif( $tarr = json_decode($arr['field_EMAILTO_JSON'],true) ) {
			$row_ticketaction += array(
				'spec_email_is_on' => true,
				'spec_email_is_outbox' => true,
				'spec_email_subject' => $tarr['subject'],
				'spec_email_date' => $tarr['date'],
				'spec_email_from' => $tarr['from'],
				'spec_email_to' => $tarr['to'],
				'spec_email_cc' => $tarr['cc']
			);
		}
		if( $arr['field_BODY_HTML'] ) {
			$binary_html = media_bin_getBinary(media_bin_toolFile_getId('TICKET_ACTION',$ticketaction_filerecord_id)) ;
			$row_ticketaction['body_html'] = $binary_html ;
			if( $row_ticketaction['spec_email_is_on'] && $row_ticketaction['spec_email_is_inbox'] && !$post_data['keep_citation'] ) {
				if( $new_binary_html = specDbsEzeer_lib_domdoc_email_stripCitationIf($binary_html) ) {
					$row_ticketaction['body_html'] = $new_binary_html ;
					$row_ticketaction['body_html_hasNext'] = true ;
				}
			}
		}
		if( $tarr = json_decode($arr['field_PHONECALL_JSON'],true) ) {
			$row_ticketaction['phonecall_is_on'] = true ;
			$row_ticketaction['phonecall_obj'] = $tarr ;
		}
		
		$row_ticketaction['extlink_is_sync'] = !!$arr['field_EXTLINK_IS_SYNC'] ;
		$row_ticketaction['extlink_sync_obj'] = json_decode($arr['field_EXTLINK_SYNC_JSON'],true);
		
		$TAB_actions[$ticketaction_filerecord_id] = $row_ticketaction ;
	}
	
	$query = "SELECT ta.filerecord_id as ticketaction_filerecord_id, a.*" ;
	$query.= " FROM view_file_ATTACH a" ;
	$query.= " JOIN view_file_TICKET_ACTION ta ON ta.filerecord_id=a.field_TICKETACTION_ID" ;
	$query.= " WHERE ta.filerecord_parent_id='{$post_data['ticket_filerecord_id']}'" ;
	if( $post_data['preview_mode'] ) {
		$query.= " LIMIT 0" ;
	}
	$result = $_opDB->query($query) ;
	$TAB_attachments = array() ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticketaction_filerecord_id = $arr['ticketaction_filerecord_id'] ;
		
		if( !$TAB_actions[$ticketaction_filerecord_id] ) {
			continue ;
		}
		
		$TAB_actions[$ticketaction_filerecord_id]['attachments'][] = array(
			'attach_filerecord_id' => $arr['filerecord_id'],
			
			'attach_filename' => $arr['field_ATTACH_FILENAME'],
			'attach_date' => $arr['field_ATTACH_DATE'],
			'status_is_cancel' => !!$arr['field_STATUS_IS_CANCEL'],
			
			'_dummy' => false
		);
	}
	
	$row_ticket['actions'] = array_values($TAB_actions) ;
	// Modif 3/01, new_reset
	if( !$row_ticket['status_is_new'] && count($row_ticket['actions'])>=1 ) {
		$resetable = TRUE ;
		foreach( $row_ticket['actions'] as $row_ticketaction ) {
			if( !$row_ticketaction['spec_email_is_on'] || !$row_ticketaction['spec_email_is_inbox'] ) {
				$resetable = FALSE ;
			}
		}
		if( $resetable ) {
			$row_ticket['status_is_new_reset'] = true ;
		}
	}
	
	media_contextClose() ;
	
	return array('success'=>true, 'data'=>$row_ticket) ;
}
function specDbsEzeer_ticket_getActionHtml($post_data) {
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	media_contextOpen( $_sdomain_id ) ;
	$ticketaction_filerecord_id = $post_data['ticketaction_filerecord_id'] ;
	$binary_html = media_bin_getBinary(media_bin_toolFile_getId('TICKET_ACTION',$ticketaction_filerecord_id)) ;
	media_contextClose() ;
	
	return array('success'=>true, 'html'=>$binary_html) ;
}

function specDbsEzeer_ticket_postAction($post_data) {
	//return array('success'=>false, 'error'=>'debug', 'debug'=>$post_data, 'debug2'=>json_decode($post_data['form_data'],true)) ;
	
	$json_cfg = specDbsEzeer_cfg_getConfig() ;
		$map_priorityTxt = array() ;
		foreach( $json_cfg['data']['cfg_priority'] as $prio ) {
			$map_priorityTxt[$prio['priority_code']] = $prio['priority_txt'] ;
		}
		$map_categoryTxt = array() ;
		foreach( $json_cfg['data']['cfg_category'] as $prio ) {
			$map_categoryTxt[$prio['category_code']] = $prio['category_txt'] ;
		}
	$cfg_user = $json_cfg['data']['cfg_people_user'] ;
	// ....
	
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	$p_formData = json_decode($post_data['form_data'],true) ;
	
	if( $p_formData['outemail_is_on'] ) {
		if( !$p_formData['outemail_from'] ) {
			$login_userId = specDbsEzeer_util_getLogUser(true) ;
			$email_from_adr = specDbsEzeer_lib_email_to_getFromAdr($login_userId) ;
			if( !$email_from_adr ) {
				return array('success'=>false, 'error'=>'No email address configured') ;
			}
		}
		
		if( !$p_formData['outemail_to'] ) {
			return array('success'=>false, 'error'=>'No email recipient, at least one address') ;
		}
		
		if( $p_formData['attachments'] ) {
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			
			media_contextOpen( $_sdomain_id ) ;
			
			$attachSize = 0;
			foreach( $p_formData['attachments'] as $attach ) {
				$bin = media_bin_getBinary($attach['media_id']) ;
				$attachSize += strlen($bin) ;
			}
			
			media_contextClose() ;
			
			if( $attachSize > specDbsEzeer_lib_email_getMaxAttachSize() ) {
				return array('success'=>false, 'error'=>'Attachment size exceed max limit (10 MB)') ;
			}
		}
		
		$lookupEmailList = function($list_id) {
			$arr_emailAdrs = array();
			$json = specDbsEzeer_cfg_getAdrbookEmail(array());
			foreach( $json['data'] as $emailadr_record ) {
				if( $emailadr_record['link_lists'] && in_array($list_id,$emailadr_record['link_lists']) ) {
					$arr_emailAdrs[] = $emailadr_record['email_adr'];
				}
			}
			return $arr_emailAdrs;
		};
		foreach( array('outemail_to','outemail_cc') as $mkey ) {
			$rewrite = array() ;
			$objs = $p_formData[$mkey] ;
			foreach( $p_formData[$mkey] as $obj ) {
				if( is_string($obj) ) {
					$rewrite[] = $obj ;
					continue;
				}
				switch( $obj['type'] ) {
					case 'list' :
						$rewrite = array_merge($rewrite,$lookupEmailList($obj['list_id'])) ;
						break ;
					case 'email' :
						$rewrite[] = $obj['email_adr'];
						break ;
				}
			}
			$p_formData[$mkey] = $rewrite;
		}
	}
	
	if( $p_ticketFilerecordId ) {
		$json = specDbsEzeer_ticket_getRecord(array(
			'ticket_filerecord_id' => $p_ticketFilerecordId
		)) ;
		if( $json['success'] ) {
			$row_ticket = $json['data'] ;
		}
	}
	
	$form_mapPropPeopleKeys = array() ;
	if( $p_formData['prop_people_owner'] ) {
		array_unshift($p_formData['prop_people'],$p_formData['prop_people_owner']) ;
	}
	foreach( $p_formData['prop_people'] as $people_row ) {
		$mkey = $people_row['people_type'].'|'.$people_row['people_id'] ;
		$form_mapPropPeopleKeys[$mkey] = 0 ;
	}
	$form_mapPropLinkKeys = array() ;
	foreach( $p_formData['prop_links'] as $link_row ) {
		$mkey = $link_row['link_cfgcode'].'|'.$link_row['link_id'] ;
		$form_mapPropLinkKeys[$mkey] = 0 ;
	}
	// assignation ?
	if( ($p_formData['next_?'] == 'people') && $p_formData['next_people'] ) {
		$people_row = $p_formData['next_people'] ;
		$mkey = $people_row['people_type'].'|'.$people_row['people_id'] ;
		if( !isset($form_mapPropPeopleKeys[$mkey]) ) {
			$form_mapPropPeopleKeys[$mkey] = 0 ;
			$p_formData['prop_people'][] = $people_row ;
		}
	}
	if( ($p_formData['next_?'] == 'return') ) {
		$people_mkeyDelete = NULL ;
		foreach( $row_ticket['prop_people'] as $row ) {
			if( !$row['owner_is_on'] && $row['assign_is_on'] ) {
				$people_mkeyDelete = $row['people_type'].'|'.$row['people_id'] ;
				break ;
			}
		}
		unset( $form_mapPropPeopleKeys[$people_mkeyDelete] ) ;
		foreach( $p_formData['prop_people'] as $idx => $people_row ) {
			if( $people_row['people_type'].'|'.$people_row['people_id'] == $people_mkeyDelete ) {
				array_splice($p_formData['prop_people'],$idx,1) ;
			}
		}
	}
	
	$date_now = date('Y-m-d H:i:s') ;
	if( $p_formData['date_now'] ) {
		$date_now = date('Y-m-d H:i:s',strtotime($p_formData['date_now'])) ;
	}
	if( !$row_ticket ) {
		$arr_ins = array() ;
		$arr_ins['field_DATE_CREATE'] = $date_now ;
		$ticket_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET', 0, $arr_ins );
		$exist_mapPropPeopleKeys = array() ;
		$exist_mapPropLinkKeys = array() ;
	} else {
		$ticket_filerecord_id = $row_ticket['ticket_filerecord_id'] ;
		
		$exist_mapPropPeopleKeys = array() ;
		foreach( $row_ticket['prop_people'] as $row ) {
			$mkey = $row['people_type'].'|'.$row['people_id'] ;
			if( isset($exist_mapPropPeopleKeys[$mkey]) ) {
				paracrm_lib_data_deleteRecord_file( 'TICKET_PROP_PEOPLE', $row['proppeople_filerecord_id'] );
				continue ;
			}
			$exist_mapPropPeopleKeys[$mkey] = $row['proppeople_filerecord_id'] ;
		}
		
		$exist_mapPropLinkKeys = array() ;
		foreach( $row_ticket['prop_links'] as $row ) {
			$mkey = $row['link_cfgcode'].'|'.$row['link_id'] ;
			if( isset($exist_mapPropLinkKeys[$mkey]) ) {
				paracrm_lib_data_deleteRecord_file( 'TICKET_PROP_LINK', $row['proplink_filerecord_id'] );
				continue ;
			}
			$exist_mapPropLinkKeys[$mkey] = $row['proplink_filerecord_id'] ;
		}
		
		// compute propchange
		$arr_changeProps = array() ;
		$p_formData['prop_title'] = trim($p_formData['prop_title']) ;
		if( $p_formData['prop_title'] != $row_ticket['prop_title'] ) {
			$arr_changeProps[] = array(
				'sign' => -1,
				'type' => 'title',
				'txt' => $row_ticket['prop_title']
			);
			$arr_changeProps[] = array(
				'sign' => 1,
				'type' => 'title',
				'txt' => $p_formData['prop_title']
			);
		}
		$p_formData['prop_category_main'] = $p_formData['prop_category'] ;
		if( count($ttmp = explode('+',$p_formData['prop_category'],2)) > 1 ) {
			$p_formData['prop_category_main'] = $ttmp[0] ;
		}
		if( $p_formData['prop_category_main'] != $row_ticket['prop_category_main'] ) {
			$arr_changeProps[] = array(
				'sign' => -1,
				'type' => 'category',
				'id' => $row_ticket['prop_category_main'],
				'txt' => $map_categoryTxt[$row_ticket['prop_category_main']]
			);
			$arr_changeProps[] = array(
				'sign' => 1,
				'type' => 'category',
				'id' => $p_formData['prop_category_main'],
				'txt' => $map_categoryTxt[$p_formData['prop_category_main']]
			);
		}
		if( $p_formData['prop_priority'] != $row_ticket['prop_priority'] ) {
			$arr_changeProps[] = array(
				'sign' => -1,
				'type' => 'priority',
				'id' => $row_ticket['prop_priority'],
				'txt' => $map_priorityTxt[$row_ticket['prop_priority']]
			);
			$arr_changeProps[] = array(
				'sign' => 1,
				'type' => 'priority',
				'id' => $p_formData['prop_priority'],
				'txt' => $map_priorityTxt[$p_formData['prop_priority']]
			);
		}
		
		foreach( $exist_mapPropPeopleKeys as $mkey => $dummy ) {
			if( !isset($form_mapPropPeopleKeys[$mkey]) ) {
				$txt = '' ;
				foreach( $row_ticket['prop_people'] as $row ) {
					if( $row['people_type'].'|'.$row['people_id'] == $mkey ) {
						$txt = $row['people_txt'] ;
					}
				}
				$arr_changeProps[] = array(
					'sign' => -1,
					'type' => 'people',
					'id' => $mkey,
					'txt' => $txt
				) ;
			}
		}
		foreach( $form_mapPropPeopleKeys as $mkey => $dummy ) {
			if( !isset($exist_mapPropPeopleKeys[$mkey]) ) {
				$txt = '' ;
				foreach( $p_formData['prop_people'] as $row ) {
					if( $row['people_type'].'|'.$row['people_id'] == $mkey ) {
						$txt = $row['people_txt'] ;
					}
				}
				$arr_changeProps[] = array(
					'sign' => 1,
					'type' => 'people',
					'id' => $mkey,
					'txt' => $txt
				) ;
			}
		}
		
		foreach( $exist_mapPropLinkKeys as $mkey => $dummy ) {
			if( !isset($form_mapPropLinkKeys[$mkey]) ) {
				$txt = '' ;
				foreach( $row_ticket['prop_links'] as $row ) {
					if( $row['link_cfgcode'].'|'.$row['link_id'] == $mkey ) {
						$txt = $row['link_txt'] ;
					}
				}
				$arr_changeProps[] = array(
					'sign' => -1,
					'type' => 'link',
					'id' => $mkey,
					'txt' => $txt
				) ;
			}
		}
		foreach( $form_mapPropLinkKeys as $mkey => $dummy ) {
			if( !isset($exist_mapPropLinkKeys[$mkey]) ) {
				$txt = '' ;
				foreach( $p_formData['prop_links'] as $row ) {
					if( $row['link_cfgcode'].'|'.$row['link_id'] == $mkey ) {
						$txt = $row['link_txt'] ;
					}
				}
				$arr_changeProps[] = array(
					'sign' => 1,
					'type' => 'link',
					'id' => $mkey,
					'txt' => $txt
				) ;
			}
		}
	}
	
	$arr_update = array() ;
	$arr_update['field_PROP_TITLE'] = $p_formData['prop_title'] ;
	$arr_update['field_PROP_CATEGORY'] = $p_formData['prop_category'] ;
	$arr_update['field_PROP_CATEGORY_LISTS'] = isset($p_formData['prop_category_lists']) ? json_encode($p_formData['prop_category_lists']) : null ;
	$arr_update['field_PROP_ORIGIN'] = $p_formData['prop_origin'] ;
	$arr_update['field_PROP_PRIORITY'] = $p_formData['prop_priority'] ;
	$arr_update['field_PROP_PEOPLE'] = true ;
	$arr_update['field_PROP_LINKS'] = true ;
	$arr_update['field_DATE_UPDATE'] = $date_now ;
	if( $p_formData['date_due'] ) {
		$arr_update['field_DATE_DUE'] = date('Y-m-d',strtotime($p_formData['date_due'])) ;
	}
	paracrm_lib_data_updateRecord_file( 'TICKET', $arr_update, $ticket_filerecord_id );
	foreach( $exist_mapPropPeopleKeys as $mkey => $proppeople_filerecord_id ) {
		if( !isset($form_mapPropPeopleKeys[$mkey]) ) {
			paracrm_lib_data_deleteRecord_file( 'TICKET_PROP_PEOPLE', $proppeople_filerecord_id );
			unset($exist_mapPropPeopleKeys[$mkey]) ;
		}
	}
	foreach( $p_formData['prop_people'] as $people_row ) {
		$mkey = $people_row['people_type'].'|'.$people_row['people_id'] ;
		if( !isset($exist_mapPropPeopleKeys[$mkey]) ) {
			$arr_ins = array() ;
			$arr_ins['field_PEOPLE_TYPE'] = $people_row['people_type'] ;
			$arr_ins['field_PEOPLE_ID'] = $people_row['people_id'] ;
			$arr_ins['field_PEOPLE_TXT'] = $people_row['people_txt'] ;
			$exist_mapPropPeopleKeys[$mkey] = paracrm_lib_data_insertRecord_file( 'TICKET_PROP_PEOPLE', $ticket_filerecord_id, $arr_ins );
		}
		if( $row_ticket ) {
			if( $row_ticket['assign_people_type'].'|'.$row_ticket['assign_people_id'] == $mkey ) {
				if( $people_row['assign_is_off'] ) {
					unset($row_ticket['assign_people_type']);
					unset($row_ticket['assign_people_id']);
				}
			}
		}
	}
	foreach( $exist_mapPropLinkKeys as $mkey => $proplink_filerecord_id ) {
		if( !isset($form_mapPropLinkKeys[$mkey]) ) {
			paracrm_lib_data_deleteRecord_file( 'TICKET_PROP_LINK', $proplink_filerecord_id );
			unset($exist_mapPropLinkKeys[$mkey]) ;
		}
	}
	foreach( $p_formData['prop_links'] as $link_row ) {
		$mkey = $link_row['link_cfgcode'].'|'.$link_row['link_id'] ;
		if( !isset($exist_mapPropLinkKeys[$mkey]) ) {
			$arr_ins = array() ;
			$arr_ins['field_LINK_CFGCODE'] = $link_row['link_cfgcode'] ;
			$arr_ins['field_LINK_ID'] = $link_row['link_id'] ;
			$arr_ins['field_LINK_TXT'] = $link_row['link_txt'] ;
			$exist_mapPropLinkKeys[$mkey] = paracrm_lib_data_insertRecord_file( 'TICKET_PROP_LINK', $ticket_filerecord_id, $arr_ins );
		}
	}
	
	if( $p_formData['prop_people_owner'] ) {
		$peopleowner_row = $p_formData['prop_people_owner'] ;
		$mkey = $peopleowner_row['people_type'].'|'.$peopleowner_row['people_id'] ;
		if( !$row_ticket || ($exist_mapPropPeopleKeys[$mkey] != $row_ticket['prop_people_owner']['proppeople_filerecord_id']) ) {
			if( $row_ticket && $row_ticket['prop_people_owner']['proppeople_filerecord_id'] ) {
				paracrm_lib_data_updateRecord_file( 'TICKET_PROP_PEOPLE', array(
					'field_OWNER_IS_ON' => 0
				),$row_ticket['prop_people_owner']['proppeople_filerecord_id']);
			}
			paracrm_lib_data_updateRecord_file( 'TICKET_PROP_PEOPLE', array(
				'field_OWNER_IS_ON' => 1
			),$exist_mapPropPeopleKeys[$mkey]);
			if( $row_ticket ) {
				if( !isset($row_ticket['prop_people_owner']) ) {
					$row_ticket['prop_people_owner'] = array() ;
				}
				$row_ticket['prop_people_owner']['proppeople_filerecord_id'] = $exist_mapPropPeopleKeys[$mkey] ;
			}
		}
	}
	
	if( $p_formData['outemail_is_on'] ) {
		$login_userId = specDbsEzeer_util_getLogUser(true) ;
		$p_formData['body_html'] = specDbsEzeer_lib_email_to_formatBody(
			$ticket_filerecord_id,
			$p_formData['body_html'],
			$login_userId,
			$p_formData['outemail_ticketActionFilerecordIds']
		) ;
	}
	
	$doWriteAction = FALSE ;
	if( $p_formData['body_html']
		|| $arr_changeProps
		|| $p_formData['emailfrom_data']
		|| $p_formData['attachments']
		|| ($p_formData['_mode']=='phone') ) {
		$doWriteAction = TRUE ;
	}
	
	if( $ticket_filerecord_id && $doWriteAction ) {
		// write action.
		$arr_ins = array() ;
		$arr_ins['field_BASE_TICKET_ID'] = $ticket_filerecord_id ;
		$arr_ins['field_ACTION_DATE'] = $date_now ;
		$arr_ins['field_ACTION_USER'] = specDbsEzeer_util_getLogUser() ;
		if( $p_formData['body_html'] ) {
			//$arr_ins['field_BODY_TXT'] = strip_tags($p_formData['body_html']) ;
			$arr_ins['field_BODY_HTML'] = true ;
		}
		$arr_ins['field_EMAILFROM_JSON'] = is_array($p_formData['emailfrom_data']) ? json_encode($p_formData['emailfrom_data']) : null ;
		if( $p_formData['outemail_is_on'] ) {
			if( !$p_formData['outemail_from'] ) {
				$login_userId = specDbsEzeer_util_getLogUser(true) ;
				$p_formData['outemail_from'] = specDbsEzeer_lib_email_to_getFromAdr($login_userId) ;
			}
			$arr_ins['field_EMAILTO_JSON'] = json_encode(array(
				'subject' => specDbsEzeer_lib_email_toolSubject_addTag($p_formData['prop_title'],$ticket_filerecord_id),
				'date' => $date_now,
				'from' => $p_formData['outemail_from'],
				'to' => implode(',',$p_formData['outemail_to']),
				'cc' => implode(',',$p_formData['outemail_cc'])
			));
		}
		$arr_ins['field_CHANGEPROPS_JSON'] = $arr_changeProps ? json_encode($arr_changeProps) : null ;
		$arr_ins['field_PHONECALL_JSON'] = ($p_formData['_mode']=='phone') ? json_encode($p_formData['phonecall_obj']) : null ;
		$arr_ins['field_EXTLINK_IS_SYNC'] = ($p_formData['_mode']=='paracrm') ? 1 : 0 ;
		$extlinkSyncObj = NULL ;
		if( $p_formData['_mode']=='paracrm' ) {
			$extlinkSyncObj = array();
			if( isset($p_formData['extlink_ticketActionFilerecordIds']) ) {
				$extlinkSyncObj['child_ticketActionFilerecordIds'] = $p_formData['extlink_ticketActionFilerecordIds'] ;
			}
		}
		$arr_ins['field_EXTLINK_SYNC_JSON'] = json_encode($extlinkSyncObj) ;
		$ticketaction_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ACTION', $ticket_filerecord_id, $arr_ins );
		
		if( $p_formData['body_html'] ) {
			$binary_html = specDbsEzeer_lib_domdoc_htmlize($p_formData['body_html']) ;
			
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			
			media_contextOpen( $_sdomain_id ) ;
			$tmp_media_id = media_bin_processBuffer($binary_html) ;
			media_bin_move($tmp_media_id,media_bin_toolFile_getId('TICKET_ACTION',$ticketaction_filerecord_id)) ;
			media_contextClose() ;
		}
		
		if( $arr_ins['field_EMAILFROM_JSON'] && !$row_ticket ) {
			paracrm_lib_data_updateRecord_file( 'TICKET', array(
				'field_STATUS_IS_NEW' => 1
			),$ticket_filerecord_id);
		}
	}
	
	if( $p_formData['attachments'] && $ticketaction_filerecord_id ) {
		$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
		$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
		media_contextOpen( $_sdomain_id ) ;
		foreach( $p_formData['attachments'] as $attach ) {
			$arr_ins = array() ;
			$arr_ins['field_ATTACH_FILENAME'] = $attach['media_filename'] ;
			$arr_ins['field_ATTACH_DATE'] = $date_now ;
			$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id ;
			$attach_filerecord_id = paracrm_lib_data_insertRecord_file( 'ATTACH', 0, $arr_ins );
		
			if( $p_formData['emailfrom_data'] ) {
				// HACK ? will be deleted in lib_email
				media_bin_copy($attach['media_id'],media_bin_toolFile_getId('ATTACH',$attach_filerecord_id)) ;
			} else {
				media_bin_move($attach['media_id'],media_bin_toolFile_getId('ATTACH',$attach_filerecord_id)) ;
			}
		}
		media_contextClose() ;
	}
	
	// Assignation courante =>fermeture
	if( $row_ticket ) {
		paracrm_lib_data_updateRecord_file( 'TICKET_ASSIGN', array(
			'field_ASSIGN_IS_ON' => 0,
			'field_DATE_REPLY' => $date_now
		),$row_ticket['ticketassign_filerecord_id']);
	}
	// Next action / assignation
	if( ($p_formData['next_?'] == 'people') && $p_formData['next_people'] ) {
		$assign_people_mkey = $p_formData['next_people']['people_type'].'|'.$p_formData['next_people']['people_id'] ;
		$assign_proppeople_id = $exist_mapPropPeopleKeys[$assign_people_mkey] ;
	} elseif( $row_ticket ) {
		$assign_people_mkey = $row_ticket['assign_people_type'].'|'.$row_ticket['assign_people_id'] ;
		$assign_proppeople_id = $exist_mapPropPeopleKeys[$assign_people_mkey] ;
	}
	if( !$assign_proppeople_id && $row_ticket['prop_people_owner'] ) {
		$assign_proppeople_id = $row_ticket['prop_people_owner']['proppeople_filerecord_id'] ;
	}
	if( !$assign_proppeople_id ) {
		// first people ?
		$assign_proppeople_id = reset($exist_mapPropPeopleKeys) ;
	}
	$date_assign = $date_now ;
	if( in_array($p_formData['next_?'],array('date','people')) && $p_formData['next_date'] ) {
		$date_assign = date('Y-m-d',strtotime($p_formData['next_date'])) ;
	} elseif( $row_ticket && $row_ticket['date_review'] ) {
		$date_assign = $row_ticket['date_review'] ;
	}
	$ticketassign_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ASSIGN', $ticket_filerecord_id, array(
		'field_PROPPEOPLE_ID' => $assign_proppeople_id,
		'field_ASSIGN_IS_ON' => 1,
		'field_DATE_ASSIGN' => $date_assign
	));
	
	
	if( ($p_formData['next_?'] == 'close') && $p_formData['next_close'] ) {
		paracrm_lib_data_deleteRecord_file( 'TICKET_ASSIGN', $ticketassign_filerecord_id );
		
		$query = "UPDATE view_file_TICKET_ASSIGN SET field_ASSIGN_IS_ON='0' WHERE filerecord_parent_id='{$ticket_filerecord_id}'" ; 
		$GLOBALS['_opDB']->query($query) ;
		
		$arr_update = array(
			'field_CLOSED_IS_ON' => 1,
			'field_CLOSED_DATE' => $date_now,
			'field_CLOSED_CODE' => $p_formData['next_close'],
			'field_CLOSED_FEEDBACK' => $p_formData['next_feedback'],
		);
	} else {
		$arr_update = array(
			'field_CLOSED_IS_ON' => 0,
			'field_CLOSED_DATE' => '0000-00-00',
			'field_CLOSED_CODE' => '',
			'field_CLOSED_FEEDBACK' => '',
		);
	}
	paracrm_lib_data_updateRecord_file( 'TICKET', $arr_update, $ticket_filerecord_id );
	
	
	/*
	Push Notifications
	*/
	specDbsEzeer_ticket_lib_pushNotification($ticket_filerecord_id,$p_formData['next_?']) ;
	
	
	if( $p_formData['outemail_is_on'] ) {
		$emailoutbox_filerecord_id = specDbsEzeer_lib_email_to_buildEmailOutbox( $ticket_filerecord_id, $ticketaction_filerecord_id ) ;
	}
	
	if( ($p_formData['next_?'] == 'link') && $p_formData['next_link'] ) {
		specDbsEzeer_ticket_postUpdateNew( array(
			'ticket_filerecord_id' => $ticket_filerecord_id,
			'form_data' => json_encode(array(
				'ticketnew_action' => 'link',
				'link_ticketFilerecordId' => $p_formData['next_link']
			))
		)) ;
		$forward_ticketFilerecordId = $p_formData['next_link'] ;
	}
	
	if( $row_ticket ) {
		$arrPing_ticketFilerecordId = array($ticket_filerecord_id) ;
		foreach( $row_ticket['actions'] as $row_ticketaction ) {
			if( $row_ticketaction['ticket_base_filerecord_id'] ) {
				if( !in_array($row_ticketaction['ticket_base_filerecord_id'],$arrPing_ticketFilerecordId) ) {
					$arrPing_ticketFilerecordId[] = $row_ticketaction['ticket_base_filerecord_id'];
				}
			}
		}
		foreach( $arrPing_ticketFilerecordId as $ping_ticket_filerecord_id ) {
			specDbsEzeer_util_pingTracy($ping_ticket_filerecord_id);
		}
	}
	
	if( true ) {
		// NOTE : condition ?
		specDbsEzeer_lib_txtsearch_buildIndex($ticketaction_filerecord_id) ;
	}
	
	return array(
		'success'=>true,
		'ticket_filerecord_id'=>$ticket_filerecord_id,
		'ticketaction_filerecord_id'=>$ticketaction_filerecord_id,
		'forward_ticketFilerecordId'=>$forward_ticketFilerecordId,
		'debug_form' => $p_formData,
		'debug_reload' => $row_ticket
	) ;
}

function specDbsEzeer_ticket_postUpdateNew($post_data) {
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	$p_formData = json_decode($post_data['form_data'],true);
	
	if( $p_ticketFilerecordId && !$p_formData['arrTicketFilerecordIds'] ) {
		$p_formData['arrTicketFilerecordIds'] = array($p_ticketFilerecordId) ;
	}
	
	foreach( $p_formData['arrTicketFilerecordIds'] as $ticket_filerecord_id ) {
		switch( $p_formData['ticketnew_action'] ) {
			case 'close' :
				$query = "UPDATE view_file_TICKET_ASSIGN SET field_ASSIGN_IS_ON='0' WHERE filerecord_parent_id='{$ticket_filerecord_id}'" ; 
				$GLOBALS['_opDB']->query($query) ;
				
				$query = "SELECT field_STATUS_IS_NEW FROM view_file_TICKET WHERE filerecord_id='{$ticket_filerecord_id}'" ;
				$status_is_new=$GLOBALS['_opDB']->query_uniqueValue($query) ;
				
				$arr_update = array(
					'field_STATUS_IS_NEW' => 0,
					'field_CLOSED_IS_ON' => 1,
					'field_CLOSED_DATE' => date('Y-m-d H:i:s')
				);
				if( $status_is_new && $p_formData['close_category_is_on'] ) {
					$arr_update['field_PROP_CATEGORY'] = $p_formData['close_category_code'] ;
					$arr_update['field_PROP_CATEGORY_LISTS'] = json_encode($p_formData['close_category_lists']) ;
					$arr_update['field_PROP_ORIGIN'] = $p_formData['close_origin_code'] ;
				}
				if( $p_formData['close_category_is_on'] ) {
					$arr_update['field_PROP_CATEGORY_LISTS'] = json_encode($p_formData['close_category_lists']) ;
					$arr_update['field_CLOSED_CODE'] = $p_formData['close_code_final'] ;
					if( $p_formData['close_category_code_final'] && !$arr_update['field_CLOSED_CODE'] ) {
						//HACK
						$arr_update['field_CLOSED_CODE'] = $p_formData['close_category_code_final'] ;
					}
				}
				paracrm_lib_data_updateRecord_file( 'TICKET', $arr_update, $ticket_filerecord_id );
				if( $p_ticketFilerecordId ) {
					return array('success'=>true) ;
				}
				break ;
				
				
			case 'new' :
				paracrm_lib_data_updateRecord_file( 'TICKET', array(
					'field_STATUS_IS_NEW' => 0
				), $ticket_filerecord_id );
				break ;
			case 'new_reset' :
				paracrm_lib_data_updateRecord_file( 'TICKET', array(
					'field_STATUS_IS_NEW' => 1
				), $ticket_filerecord_id );
				break ;
				
				
			case 'link' :
				$query = "UPDATE view_file_TICKET_ASSIGN SET field_ASSIGN_IS_ON='0' WHERE filerecord_parent_id='{$ticket_filerecord_id}'" ; 
				$GLOBALS['_opDB']->query($query) ;
				
				paracrm_lib_data_updateRecord_file( 'TICKET', array(
					'field_STATUS_IS_NEW' => 0,
					'field_CLOSED_IS_ON' => 1,
					'field_CLOSED_CODE' => $p_formData['next_close']
				), $ticket_filerecord_id );
				
				global $_opDB ;
				$query = "UPDATE view_file_TICKET_ACTION ta
								JOIN view_file_TICKET t ON t.filerecord_id=ta.filerecord_parent_id
								SET ta.filerecord_parent_id='{$p_formData['link_ticketFilerecordId']}'
								WHERE t.filerecord_id='{$ticket_filerecord_id}'" ;
				$_opDB->query($query) ;
				if( $p_ticketFilerecordId ) {
					return array('success'=>true, 'ticket_filerecord_id'=>$p_formData['link_ticketFilerecordId']) ;
				}
				break ;
				
				
			case 'preactions' :
				$json = specDbsEzeer_ticket_getRecord(array(
					'ticket_filerecord_id' => $ticket_filerecord_id
				));
				$row_ticket = $json['data'] ;
				if( !$row_ticket['status_is_new'] ) {
					continue 2 ;
				}
				if( isset($p_formData['prop_people_owner']) ) {
					$proppeople_filerecord_id = $row_ticket['prop_people_owner']['proppeople_filerecord_id'] ;
					if( $proppeople_filerecord_id 
						&& $row_ticket['prop_people_owner']['people_type'] == 'group'
						&& $p_formData['prop_people_owner']['people_type'] == 'user' ) {
					
						$arr_update = array(
							'field_OWNER_IS_ON' => 0
						);
						paracrm_lib_data_updateRecord_file( 'TICKET_PROP_PEOPLE',$arr_update, $proppeople_filerecord_id );
						$proppeople_filerecord_id = NULL ;
					}
					$arr_update = array(
						'field_PEOPLE_TYPE' => $p_formData['prop_people_owner']['people_type'],
						'field_PEOPLE_ID' => $p_formData['prop_people_owner']['people_id'],
						'field_PEOPLE_TXT' => $p_formData['prop_people_owner']['people_txt'],
						'field_OWNER_IS_ON' => 1
					) ;
					if( !$proppeople_filerecord_id ) {
						$proppeople_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_PROP_PEOPLE',$ticket_filerecord_id, $arr_update );
					} else {
						paracrm_lib_data_updateRecord_file( 'TICKET_PROP_PEOPLE',$arr_update, $proppeople_filerecord_id );
					}
					$query = "UPDATE view_file_TICKET_ASSIGN SET field_PROPPEOPLE_ID='{$proppeople_filerecord_id}' WHERE filerecord_parent_id='{$ticket_filerecord_id}'" ;
					$GLOBALS['_opDB']->query($query) ;
				}
				if( isset($p_formData['prop_category_code']) ) {
					$arr_update = array() ;
					$arr_update['field_PROP_CATEGORY'] = $p_formData['prop_category_code'] ;
					if( isset($p_formData['prop_category_lists']) ) {
						$arr_update['field_PROP_CATEGORY_LISTS'] = json_encode($p_formData['prop_category_lists']);
					}
					paracrm_lib_data_updateRecord_file( 'TICKET',$arr_update, $ticket_filerecord_id );
				}
				if( isset($p_formData['prop_origin_code']) ) {
					$arr_update = array() ;
					$arr_update['field_PROP_ORIGIN'] = $p_formData['prop_origin_code'] ;
					paracrm_lib_data_updateRecord_file( 'TICKET',$arr_update, $ticket_filerecord_id );
				}
				break ;
				
				
			default :
				return array('success'=>false) ;
		}
	}
	if( $p_ticketFilerecordId ) {
		return array('success'=>true, 'ticket_filerecord_id'=>$p_ticketFilerecordId) ;
	}
	return array('success'=>true) ;
}

function specDbsEzeer_ticket_ejectExtern( $post_data ) {
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	$p_ticketBaseFilerecordId = $post_data['ticket_base_filerecord_id'] ;
	
	global $_opDB ;
	
	$query = "UPDATE view_file_TICKET_ACTION SET filerecord_parent_id=field_BASE_TICKET_ID
				WHERE filerecord_parent_id='{$p_ticketFilerecordId}' AND field_BASE_TICKET_ID='{$p_ticketBaseFilerecordId}'" ;
	$_opDB->query($query) ;
	
	$query = "UPDATE view_file_TICKET SET field_CLOSED_IS_ON='0'
				WHERE filerecord_id='{$p_ticketBaseFilerecordId}'" ;
	$_opDB->query($query) ;
	
	return array('success'=>true) ;
}

function specDbsEzeer_ticket_reopen( $post_data ) {
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	
	global $_opDB ;
	
	$query = "UPDATE view_file_TICKET SET field_CLOSED_IS_ON='0',field_CLOSED_DATE='',field_CLOSED_CODE='',field_CLOSED_FEEDBACK=''
				WHERE filerecord_id='{$p_ticketFilerecordId}'" ;
	$_opDB->query($query) ;
	
	return array('success'=>true) ;
}

function specDbsEzeer_ticket_getExempleHtml($post_data) {
	$app_root = $GLOBALS['app_root'] ;
	return array('success'=>true,
		'data' => array(
			'html1' => file_get_contents($app_root.'/images/test/html1.html')
		)
	) ;
}
function specDbsEzeer_ticket_getPreviewHtml( $post_data ) {
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	$p_formData = json_decode($post_data['form_data'],true) ;
	
	$login_userId = specDbsEzeer_util_getLogUser(true) ;
	
	return array(
		'success' => true,
		'html' => specDbsEzeer_lib_email_to_formatBody(
			$p_ticketFilerecordId,
			$p_formData['body_html'],
			$login_userId,
			$p_formData['outemail_ticketActionFilerecordIds']
		)
	);
}



function specDbsEzeer_ticket_lib_pushNotification( $ticket_filerecord_id, $form_next=NULL ) {
	$json_cfg = specDbsEzeer_cfg_getConfig() ;
	$cfg_user = $json_cfg['data']['cfg_people_user'] ;
	/*
	Push Notifications
	- Owner + Assignee
	- excl. specDbsEzeer_util_getLogUser
	*/
	$json = specDbsEzeer_ticket_getRecord(array(
		'ticket_filerecord_id' => $ticket_filerecord_id
	)) ;
	$row_ticket = $json['data'] ;
	if( !$json['success'] || !$row_ticket ) {
		return array('success'=>false) ;
	}
	$login_userId = specDbsEzeer_util_getLogUser(true) ;
	$arr_userIds = array() ;
	if( $row_ticket['prop_people_owner']['people_type'] == 'user' ) {
		$arr_userIds[$row_ticket['prop_people_owner']['people_id']] = true ;
	}
	if( $row_ticket['assign_people_type'] == 'user' ) {
		$arr_userIds[$row_ticket['assign_people_id']] = true ;
	}
	switch( $form_next ) {
		case 'people' :
			$txt = 'Assigned' ;
			break ;
		default :
			$txt = 'Update' ;
			break ;
	}
	$arrIns_notification = array(
		'field_TICKET_ID' => $ticket_filerecord_id,
		'field_NOTIFICATION_DATE' => date('Y-m-d H:i:s'),
		'field_NOTIFICATION_TXT' => $txt
	);
	foreach( $arr_userIds as $user_id => $torf ) {
		if( $login_userId && ($user_id==$login_userId) ) {
			continue ;
		}
		foreach( $cfg_user as $user_row ) {
			if( ($user_row['user_id']==$user_id) && $user_row['virtual_is_on'] ) {
				continue 2 ;
			}
		}
		$arr_ins = $arrIns_notification + array('field_TARGET_USER'=>$user_id) ;
		paracrm_lib_data_insertRecord_file( 'NOTIFICATION', 0, $arr_ins ) ;
	}
}

?>
