<?php
define('SPECDBSTRACY_AOG_UPGRADECODE','327-PRIORITY-TO_AOG') ;
define('SPECDBSTRACY_AOG_WARNINGCODES',array(SPECDBSTRACY_AOG_UPGRADECODE,'t_DN_UPGRADE','215-SNA-CRI_TO_AOG','216-SNA-NLT_TO_CRI')) ;

function specDbsTracy_aogpanel_lib_clearSteps( $order_filerecord_id ) {
	if( !$GLOBALS['__OPTIMA_TEST'] ) {
		return ;
	}
	$json = specDbsTracy_order_getRecords(array(
		'filter_orderFilerecordId_arr'=> json_encode(array($order_filerecord_id)),
		'skip_details' => 1,
	));
	if( $json['success'] && count($json['data'])==1 ) {
		$row_order = reset($json['data']) ;
	}
	if( !$row_order ) {
		return ;
	}
	// HACK
	$stepsToReset = array('70_PICKUP','90_POD','99_LTA') ;
	foreach( $row_order['steps'] as $row_order_step ) {
		if( in_array($row_order_step['step_code'],$stepsToReset) && $row_order_step['status_is_ok'] ) {
			$arr_ins = array(
				'field_STATUS_IS_OK' => 0,
			);
			$filerecord_id = paracrm_lib_data_updateRecord_file( 'CDE_STEP', $arr_ins, $row_order_step['orderstep_filerecord_id'] );
		}
	}
}
function specDbsTracy_aogpanel_lib_writeUpgrade( $order_filerecord_id ) {
	$json = specDbsTracy_order_getRecords(array(
		'filter_orderFilerecordId_arr'=> json_encode(array($order_filerecord_id)),
		'skip_details' => 1,
	));
	if( $json['success'] && count($json['data'])==1 ) {
		$row_order = reset($json['data']) ;
	}
	if( !$row_order ) {
		return ;
	}
	
	$arr_update = array() ;
	$arr_update['field_AOG_IS_ON'] = 1 ;
	if( !$row_order['atr_incoterm_txt'] ) {
		$arr_update['field_ATR_INCOTERM_TXT'] = 'MIMO' ;
	}
	paracrm_lib_data_updateRecord_file( 'CDE', $arr_update, $row_order['order_filerecord_id'] );
	
	foreach( $row_order['tickets'] as $row_orderTicket ) {
		if( !$row_orderTicket['closed_is_on'] && in_array($row_orderTicket['incident_code'],SPECDBSTRACY_AOG_WARNINGCODES) ) {
			return ;
		}
	}
	if( true ) {
		$arr_links = array(
			array('link_type'=>'order', 'link_filerecord_id'=>$row_order['order_filerecord_id']),
		);
		specDbsTracy_ticket_lib_setWarning($arr_links,SPECDBSTRACY_AOG_UPGRADECODE);
	}
	
	return;
}
function specDbsTracy_aogpanel_lib_enrollOrder( $order_filerecord_id, $writeUpgrade = FALSE ) {
	
	$json = specDbsTracy_order_getRecords(array(
		'filter_orderFilerecordId_arr'=> json_encode(array($order_filerecord_id)),
		'skip_details' => 1,
	));
	if( $json['success'] && count($json['data'])==1 ) {
		$row_order = reset($json['data']) ;
	}
	if( !$row_order ) {
		return ;
	}
	
	$arr_update = array() ;
	$arr_update['field_AOG_IS_ON'] = 1 ;
	if( !$row_order['atr_incoterm_txt'] ) {
		$arr_update['field_ATR_INCOTERM_TXT'] = 'MIMO' ;
	}
	paracrm_lib_data_updateRecord_file( 'CDE', $arr_update, $row_order['order_filerecord_id'] );
	
	if( $writeUpgrade ) {
		specDbsTracy_aogpanel_lib_writeUpgrade($order_filerecord_id);
	}
	
	if( !$row_order['calc_hat_filerecord_id'] ) {
		$json = specDbsTracy_hat_setHeader( array(
			'_is_new' => true,
			'data' => json_encode(array(
				'id_soc' => $row_order['id_soc'],
				'id_hat' => $row_order['id_dn'],
				'date_create' => date('Y-m-d H:i:s'),
				'parcels' => array(),
			)),
		));
		$hat_filerecord_id = $json['id'] ;
		
		specDbsTracy_hat_orderAdd( array(
			'hat_filerecord_id' => $hat_filerecord_id,
			'order_filerecord_id' => $row_order['order_filerecord_id'],
		));
		
		$row_order['calc_hat_filerecord_id'] = $hat_filerecord_id ;
	}
	if( $row_order['calc_hat_filerecord_id'] ) {
		$json = specDbsTracy_hat_getRecords( array('filter_hatFilerecordId_arr'=>json_encode(array($row_order['calc_hat_filerecord_id']))) ) ;
		$row_hat = reset($json['data']) ;
		if( $row_hat['hat_filerecord_id'] == $row_order['calc_hat_filerecord_id'] ) {
			if( !$row_hat['parcels'] ) {
				$json = specDbsTracy_hat_setHeader( array(
					'hat_filerecord_id' => $row_hat['hat_filerecord_id'],
					'data' => json_encode( array(
						'id_soc' => $row_hat['id_soc'],
						'id_hat' => $row_hat['id_hat'],
						'date_create' => $row_hat['date_create'],
						'parcels' => array(
							array('vol_count'=>1, 'vol_kg'=>0, 'vol_dims'=>array(10,10,10))
						),
					)),
				));
			}
		}
	}
	if( !$row_order['calc_link_trspt_filerecord_id'] ) {
		$post_data = array() ;
		$post_data['_is_new'] = 1 ;
		$form_data = array() ;
		$form_data['id_soc'] = $row_order['id_soc'] ;
		$form_data['flow_code'] = 'AIR' ;
		$form_data['atr_type'] = 'STD' ;
		$form_data['date_create'] = date('Y-m-d H:i:s') ;
		$form_data['atr_priority'] = $row_order['atr_priority'] ;
		$form_data['atr_incoterm'] = $row_order['atr_incoterm'] ;
		$form_data['atr_consignee'] = $row_order['atr_consignee'] ;
		$form_data['mvt_carrier'] = 'AOGDESK' ;
		$form_data['customs_mode'] ='OFF' ;
		$post_data['data'] = json_encode($form_data) ;
		$post_data['data_orderFilerecordIds'] = json_encode(array($row_order['order_filerecord_id'])) ;
		$json = specDbsTracy_trspt_setHeader($post_data, $force=true) ;
		if( $json['success'] ) {
			$row_order['calc_link_trspt_filerecord_id'] = $json['id'] ;
		}
	}
	if( $row_order['calc_link_trspt_filerecord_id'] ) {
		paracrm_lib_data_updateRecord_file( 'TRSPT', array('field_READY_IS_ADR'=>1), $row_order['calc_link_trspt_filerecord_id'] );
	}
}

function specDbsTracy_aogpanel_getList($post_data) {
	global $_opDB ;
	
	if( $post_data['filter_socCode'] ) {
		$filter_socCode = $post_data['filter_socCode'] ;
	}
	// filter ?
	/*
	if( isset($post_data['filter_searchTxt']) ) {
		$filter_orderFilerecordId_list = $_opDB->makeSQLlist(
			specDbsTracy_hat_search2order($post_data['filter_socCode'],$post_data['filter_searchTxt'])
		) ;
	} elseif( isset($post_data['filter_orderFilerecordId_arr']) ) {
		$filter_orderFilerecordId_list = $_opDB->makeSQLlist( json_decode($post_data['filter_orderFilerecordId_arr'],true) ) ;
	}
	*/
	if( isset($post_data['filter_orderFilerecordId_arr']) ) {
		$filter_noFilterCurrent = TRUE ;
		$filter_orderFilerecordId_arr = json_decode($post_data['filter_orderFilerecordId_arr'],true) ;
	}
	
	if( $post_data['filter_dates'] ) {
		$ttmp = json_decode($post_data['filter_dates'],true) ;
		$filter_noFilterCurrent = TRUE ;
		$filter_dates = TRUE ;
		$filter_dateStart = $ttmp['date_start'] ;
		$filter_dateEnd = $ttmp['date_end'] ;
	}
	if( $filter_dates && $filter_dateStart && $filter_dateEnd ) {
		$query = "SELECT distinct filerecord_parent_id AS cde_filerecord_id
					FROM `view_file_CDE_STEP` 
					WHERE field_STATUS_IS_OK='1'
					AND DATE(field_DATE_ACTUAL) BETWEEN '{$filter_dateStart}' AND '{$filter_dateEnd}'" ;
		$result = $_opDB->query($query) ;
		$filter_orderFilerecordId_arr = array() ;
		while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
			$filter_orderFilerecordId_arr[] = $arr[0] ;
		}
	}
	
	if( isset($post_data['filter_searchTxt']) ) {
		$searchTxt = $post_data['filter_searchTxt'] ;
		$query = "SELECT filerecord_id FROM view_file_CDE WHERE field_ID_DN='{$searchTxt}' OR field_REF_INVOICE='{$searchTxt}'" ;
		$result = $_opDB->query($query) ;
		$filter_orderFilerecordId_arr = array() ;
		while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
			$filter_orderFilerecordId_arr[] = $arr[0] ;
		}
		$filter_noFilterCurrent = TRUE ;
	}
	
	
	$json = specDbsTracy_order_getRecords(array(
		'filter_socCode' => $filter_socCode,
		'filter_orderFilerecordId_arr'=> isset($filter_orderFilerecordId_arr) ? json_encode($filter_orderFilerecordId_arr) : null,
		'skip_details' => 1,
	));
	if( !$json['success'] ) {
		return array('success'=>false) ;
	}
	//return $json ;
	
	$TAB_order = array() ;
	foreach( $json['data'] as $row_order ) {
		$is_AOG = FALSE ;
		
		if( $row_order['aog_is_on'] ) {
			$is_AOG = TRUE ;
		}
		if( specDbsTracy_trspt_tool_isDateValid($row_order['date_aog']) ) {
			$is_AOG = TRUE ;
			$row_order['create_AOG_date'] = $row_order['date_aog'] ;
		}
		if( $is_AOG && specDbsTracy_trspt_tool_isDateValid($row_order['date_aog_end']) ) {
			$row_order['create_END_date'] = $row_order['date_aog_end'] ;
		}
		
		$has_warningAog = FALSE ;
		foreach( $row_order['tickets'] as $row_orderTicket ) {
			if( !$row_orderTicket['closed_is_on'] && in_array($row_orderTicket['incident_code'],SPECDBSTRACY_AOG_WARNINGCODES) ) {
				$has_warningAog = TRUE ;
			}
		}
		if( $row_order['atr_priority'] == 1 ) {
			$row_order['aog_is_status'] = true ;
			$is_AOG = TRUE ;
		} elseif( $has_warningAog ) {
			$row_order['aog_is_status'] = true ;
			$is_AOG = TRUE ;
		} else {
			$row_order['aog_is_status'] = false ;
		}
		if( !$is_AOG && ( !isset($post_data['filter_searchTxt']) && !isset($post_data['filter_orderFilerecordId_arr']) ) ) {
			continue ;
		}
		
		$order_filerecord_id = $row_order['order_filerecord_id'] ;
		if( isset($filter_orderFilerecordId_arr) ) {
			if( !in_array($order_filerecord_id,$filter_orderFilerecordId_arr) ) {
				continue ;
			}
		}
		
		$row_order['IOD_is_on'] = false ;
		$row_order['AWB_is_on'] = false ;
		foreach( $row_order['steps'] as $row_order_step ) {
			if( ($row_order_step['step_code'] == '10_RLS') && $row_order_step['status_is_ok'] ) {
				$row_order['create_RLS_date'] = $row_order_step['date_actual'] ;
			}
			if( ($row_order_step['step_code'] == '60_TRSPTREADY') && $row_order_step['status_is_ok'] ) {
				$row_order['IOD_is_visible'] = true ;
				$row_order['AWB_is_visible'] = true ;
				$row_order['READY_date'] = $row_order_step['date_actual'] ;
			}
			if( ($row_order_step['step_code'] == '70_PICKUP') && $row_order_step['status_is_ok'] ) {
				$row_order['pickup_status'] = true ;
			}
			if( ($row_order_step['step_code'] == '90_POD') && $row_order_step['status_is_ok'] ) {
				$row_order['IOD_is_on'] = true ;
				$row_order['IOD_date'] = $row_order_step['date_actual'] ;
			}
			if( ($row_order_step['step_code'] == '99_LTA') && $row_order_step['status_is_ok'] ) {
				$row_order['AWB_is_on'] = true ;
				$row_order['AWB_date'] = $row_order_step['date_actual'] ;
			}
		}
		$row_order['trspt_is_on'] = !!($row_order['calc_link_trspt_filerecord_id']) ;
		
		if( $row_order['IOD_is_on'] ) {
			$row_order['pod_status'] = false ;
		}
		
		// filterDates
		if( !$filter_noFilterCurrent && $row_order['IOD_is_on'] && $row_order['AWB_is_on'] ) {
			if( date('Y-m-d H:i:s',strtotime('-1 hour')) > max($row_order['IOD_date'],$row_order['AWB_date']) ) {
				continue ;
			}
		}
		
		$TAB_order[$order_filerecord_id] = $row_order ;
	}
	
	
	$query = "SELECT distinct(c.filerecord_id)
				FROM view_file_CDE c
				JOIN view_file_CDE_ATTACH ca ON ca.filerecord_parent_id=c.filerecord_id 
				WHERE c.field_ARCHIVE_IS_ON='0' AND ca.field_ATTACHMENT_CATG='POD'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$order_filerecord_id = $arr[0] ;
		if( $TAB_order[$order_filerecord_id] ) {
			$TAB_order[$order_filerecord_id]['pod_status'] = true ;
		}
	}
	
	$query = "SELECT c.filerecord_id, t.field_READY_ADR_ID, t.field_FLIGHT_AWB
				FROM view_file_CDE c
				JOIN view_file_TRSPT_CDE tc ON tc.field_FILE_CDE_ID=c.filerecord_id AND tc.field_LINK_IS_CANCEL='0'
				JOIN view_file_TRSPT t ON t.filerecord_id=tc.filerecord_parent_id
				WHERE c.field_ARCHIVE_IS_ON='0'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$order_filerecord_id = $arr[0] ;
		if( $TAB_order[$order_filerecord_id] ) {
			$TAB_order[$order_filerecord_id]['READY_adr'] = $arr[1] ;
			$TAB_order[$order_filerecord_id]['AWB_txt'] = $arr[2] ;
			if( !!$arr[2] ) {
				$TAB_order[$order_filerecord_id]['AWB_is_on'] = true ;
			}
		}
	}
	
	
	return array('success'=>true, 'data'=>array_values($TAB_order)) ;
}

function specDbsTracy_aogpanel_saveOrder( $post_data ) {
	$p_orderFilerecordId = $post_data['order_filerecord_id'] ;
	$p_formValues = json_decode($post_data['data'],true) ;
	
	if( !$p_orderFilerecordId ) {
		$sql_idDn = $GLOBALS['_opDB']->escape_string($p_formValues['id_dn']) ;
		$query = "SELECT filerecord_id FROM view_file_CDE WHERE field_ID_DN='{$sql_idDn}'" ;
		if( $GLOBALS['_opDB']->query_uniqueValue($query) > 0 ) {
			return array('success'=>false, 'error'=>'Existing DN') ;
		}
		
		$json = specDbsTracy_order_setHeader( array(
			'_is_new' => true,
			'data' => json_encode(array(
				'flow_code' => 'AIR',
				'id_soc' => $p_formValues['id_soc'],
				'id_dn' => $p_formValues['id_dn'],
				'atr_priority' => 1,
				'atr_type' => 'STD',
				'atr_incoterm' => $p_formValues['atr_incoterm'],
				'atr_consignee' => $p_formValues['atr_consignee'],
			)),
			'validateStepCode' => '10_RLS',
		)) ;
		if( $json['success'] ) {
			$p_orderFilerecordId = $json['id'];
		}
	}
	
	$json = specDbsTracy_order_getRecords(array(
		'filter_orderFilerecordId_arr'=> json_encode(array($p_orderFilerecordId)),
		'skip_details' => 1,
	));
	if( $json['success'] && count($json['data'])==1 ) {
		$row_order = reset($json['data']) ;
	}
	if( !$row_order ) {
		return array('success'=>false) ;
	}
	
	$json = specDbsTracy_aogpanel_getList(array(
		'filter_orderFilerecordId_arr'=> json_encode(array($p_orderFilerecordId)),
	));
	if( $json['success'] && count($json['data'])==1 ) {
		$row_aog = reset($json['data']) ;
	}
	if( !$row_aog ) {
		return array('success'=>false) ;
	}
	
	if( specDbsTracy_trspt_tool_isDateValid($p_formValues['create_AOG_date'])
		&& !$row_aog['create_AOG_date'] ) {
		$set_dateAOG = TRUE ;
		if( !($row_order['atr_priority']==1) ) {
			$set_dateAOG_writeUpgrade = TRUE ;
		}
	}
	if( !$row_aog['create_AOG_date'] && !$set_dateAOG ) {
		return array('success'=>true) ;
	}
	
	if( specDbsTracy_trspt_tool_isDateValid($p_formValues['create_END_date'])
		&& !$row_aog['create_END_date'] ) {
		$set_dateEND = TRUE ;
	}
	
	if( $set_dateAOG ) {
		$arr_update = array() ;
		$arr_update['field_AOG_IS_ON'] = 1 ;
		$arr_update['field_DATE_AOG'] = $p_formValues['create_AOG_date'] ;
		paracrm_lib_data_updateRecord_file( 'CDE', $arr_update, $row_order['order_filerecord_id'] );
		
		// HACK
		specDbsTracy_aogpanel_lib_clearSteps($row_order['order_filerecord_id']) ;
		
		if( $set_dateAOG_writeUpgrade ) {
			foreach( $row_order['events'] as $row_event ) {
				if( $row_event['event_code'] == SPECDBSTRACY_AOG_UPGRADECODE ) {
					$set_dateAOG_writeUpgrade = FALSE ;
					break ;
				}
			}
		}
		
		specDbsTracy_aogpanel_lib_writeUpgrade($row_order['order_filerecord_id']);
	}
	if( !$set_dateAOG && $set_dateEND ) {
		$arr_update = array() ;
		$arr_update['field_DATE_AOG_END'] = $p_formValues['create_END_date'] ;
		paracrm_lib_data_updateRecord_file( 'CDE', $arr_update, $row_order['order_filerecord_id'] );
	}
	if( $p_formValues['atr_incoterm_txt'] ) {
		$arr_update = array() ;
		$arr_update['field_ATR_INCOTERM_TXT'] = $p_formValues['atr_incoterm_txt'] ;
		paracrm_lib_data_updateRecord_file( 'CDE', $arr_update, $row_order['order_filerecord_id'] );
	}
	
	if( $p_formValues['IOD_is_on'] && !$row_aog['IOD_is_on'] ) {
		$set_IOD = TRUE ;
	}
	if( $p_formValues['AWB_is_on'] ) {
		$set_AWB = TRUE ;
	}
	
	if( $set_IOD ) {
		specDbsTracy_aogpanel_lib_enrollOrder( $p_orderFilerecordId ) ;
		foreach( $row_order['steps'] as $row_order_step ) {
			if( ($row_order_step['step_code'] == '70_PICKUP') && !$row_order_step['status_is_ok'] ) {
				$filerecord_id = $row_order_step['orderstep_filerecord_id'] ;
				
				$arr_ins = array(
					'field_DATE_ACTUAL' => $p_formValues['IOD_date'],
					'field_STATUS_IS_OK' => 1,
							  );
				$filerecord_id = paracrm_lib_data_updateRecord_file( 'CDE_STEP', $arr_ins, $row_order_step['orderstep_filerecord_id'] );
			}
			if( ($row_order_step['step_code'] == '90_POD') && !$row_order_step['status_is_ok'] ) {
				$filerecord_id = $row_order_step['orderstep_filerecord_id'] ;
				
				$arr_ins = array(
					'field_DATE_ACTUAL' => $p_formValues['IOD_date'],
					'field_STATUS_IS_OK' => 1,
							  );
				$filerecord_id = paracrm_lib_data_updateRecord_file( 'CDE_STEP', $arr_ins, $row_order_step['orderstep_filerecord_id'] );
			}
		}
		
		// HACK !
		// 5/02/2024 => trigger OK_CARRIER_POD
		paracrm_queries_direct( array(
			'q_type' => 'qsql',
			'q_id' => 'OK_CARRIER_POD'
		),true,true) ;
	}
	if( $set_AWB ) {
		specDbsTracy_aogpanel_lib_enrollOrder( $p_orderFilerecordId ) ;
		foreach( $row_order['steps'] as $row_order_step ) {
			if( ($row_order_step['step_code'] == '99_LTA') && !$row_order_step['status_is_ok'] ) {
				$filerecord_id = $row_order_step['orderstep_filerecord_id'] ;
				
				$arr_ins = array(
					'field_DATE_ACTUAL' => date('Y-m-d H:i:s'),
					'field_STATUS_IS_OK' => 1,
							  );
				paracrm_lib_data_updateRecord_file( 'CDE_STEP', $arr_ins, $row_order_step['orderstep_filerecord_id'] );
			}
			if( $row_order['calc_link_trspt_filerecord_id'] ) {
				$arr_ins = array(
					'field_FLIGHT_AWB' => $p_formValues['AWB_txt'],
					'field_FLIGHT_DATE' => date('Y-m-d H:i:s'),
							  );
				paracrm_lib_data_updateRecord_file( 'TRSPT', $arr_ins, $row_order['calc_link_trspt_filerecord_id'] );
			}
		}
	}
	
	
	return array('success'=>true, 'debug'=>$p_orderFilerecordId, 'debug2'=>$p_formValues) ;
}

?>
