<?php

$GLOBALS['__specDbsTracy_media_maxPdfPages'] = 4 ;

function specDbsTracy_attachments_uploadfile($post_data) {
	media_contextOpen( $_POST['_sdomainId'] ) ;
	foreach( $_FILES as $mkey => $dummy ) {
		$media_id = media_auto_processUploaded( $_FILES[$mkey]['tmp_name'], $_FILES[$mkey]['name'], $all_files=true ) ;
		break ;
	}
	media_contextClose() ;
	if( !$media_id ) {
		return array('success'=>false) ;
	}
	
	return array('success'=>true, 'data'=>array('tmp_id'=>$media_id)) ;
}
function specDbsTracy_attachments_setAttachment($post_data) {
	$p_parentFileCode = $post_data['parent_file_code'] ;
	$p_parentFilerecordId = $post_data['parent_filerecord_id'] ;
	$form_data = json_decode($post_data['data'],true) ;
		usleep(500000) ;
		
	$newrecord = array() ;
	//$newrecord['media_title'] = $_FILES['photo-filename']['name'] ;
	$newrecord['media_date'] = date('Y-m-d H:i:s') ;
	$newrecord['media_mimetype'] = 'image/jpeg' ;
	$newrecord['field_ATTACHMENT_DATE'] = $form_data['attachment_date'] ;
	$newrecord['field_ATTACHMENT_TXT'] = $form_data['attachment_txt'] ;
	$newrecord['field_ATTACHMENT_CATG'] = $form_data['attachment_catg'] ;
	$newrecord['field_ATTACHMENT_DISCARD'] = $form_data['attachment_discard'] ;
	if( $form_data['filerecord_id'] > 0 ) {
		$img_mediaId = $form_data['media_id'] ;
		$img_filerecordId = $form_data['filerecord_id'] ;
		switch( $p_parentFileCode ) {
			case 'order' :
				paracrm_lib_data_updateRecord_file( 'CDE_ATTACH', $newrecord, $img_filerecordId ) ;
				break ;
			default :
				paracrm_lib_data_updateRecord_file( 'ATTACH_INBOX', $newrecord, $img_filerecordId ) ;
				break ;
		}
		
	} elseif( $form_data['tmp_id'] ) {
		switch( $p_parentFileCode ) {
			case 'order' :
				$filecode = 'CDE_ATTACH' ;
				$img_filerecordId = paracrm_lib_data_insertRecord_file( 'CDE_ATTACH', $p_parentFilerecordId, $newrecord ) ;
				$img_mediaId = media_toolFile_getId($filecode,$img_filerecordId) ;
				break ;
			default :
				$filecode = 'ATTACH_INBOX' ;
				$img_filerecordId = paracrm_lib_data_insertRecord_file( 'ATTACH_INBOX', 0, $newrecord ) ;
				$img_mediaId = media_toolFile_getId($filecode,$img_filerecordId) ;
				break ;
		}
		
		media_contextOpen( $_POST['_sdomainId'] ) ;
		media_auto_move( $form_data['tmp_id'] , $img_mediaId ) ;
		media_contextClose() ;
	} else {
		return array('success'=>false) ;
	}
	
	return array('success'=>true, 'data'=>array('filerecord_id'=>$img_filerecordId,'media_id'=>$img_mediaId)) ;
}
function specDbsTracy_attachments_load($post_data) {
	$p_parentFileCode = $post_data['parent_file_code'] ;
	$p_parentFilerecordId = $post_data['parent_filerecord_id'] ;
	$attach_filerecordId = $post_data['filerecord_id'] ;
	
	switch( $p_parentFileCode ) {
		case 'order' :
			$filecode = 'CDE_ATTACH' ;
			$data = paracrm_lib_data_getRecord_file('CDE_ATTACH',$attach_filerecordId) ;
			$media_id = media_toolFile_getId($filecode,$attach_filerecordId) ;
			break ;
		default :
			$filecode = 'ATTACH_INBOX' ;
			$data = paracrm_lib_data_getRecord_file('ATTACH_INBOX',$attach_filerecordId) ;
			$media_id = media_toolFile_getId($filecode,$attach_filerecordId) ;
			break ;
	}

	if( !$data ) {
		return array('success'=>false) ;
	}
	return array(
		'success' => true,
		'data' => array(
			'media_id' => $media_id,
			'filerecord_id' => $data['filerecord_id'],
			'attachment_date' => substr($data['field_ATTACHMENT_DATE'],0,10),
			'attachment_txt' => $data['field_ATTACHMENT_TXT'],
			'attachment_catg' => $data['field_ATTACHMENT_CATG'],
			'attachment_discard' => $data['field_ATTACHMENT_DISCARD'],
		)
	);
}
function specDbsTracy_attachments_delete($post_data) {
	$p_parentFileCode = $post_data['parent_file_code'] ;
	$p_parentFilerecordId = $post_data['parent_filerecord_id'] ;
	$attach_filerecordId = $post_data['filerecord_id'] ;
	
	if( is_numeric($attach_filerecordId) ) {
		switch( $p_parentFileCode ) {
			case 'order' :
				$filecode = 'CDE_ATTACH' ;
				$media_id = media_toolFile_getId($filecode,$attach_filerecordId) ;
				break ;
			default :
				$filecode = 'ATTACH_INBOX' ;
				$media_id = media_toolFile_getId($filecode,$attach_filerecordId) ;
				break ;
		}
	} else {
		$media_id = $attach_filerecordId ;
	}
	
	media_contextOpen( $_POST['_sdomainId'] ) ;
	media_auto_delete( $media_id ) ;
	media_contextClose() ;
	
	if( is_numeric($attach_filerecordId) ) {
		switch( $p_parentFileCode ) {
			case 'order' :
				paracrm_lib_data_deleteRecord_file('CDE_ATTACH',$attach_filerecordId) ;
				break ;
			default :
				paracrm_lib_data_deleteRecord_file('ATTACH_INBOX',$attach_filerecordId) ;
				break ;
		}
	}

	return array('success'=>true) ;
}


function specDbsTracy_attachments_attach($post_data) {
	$p_parentFileCode = $post_data['parent_file_code'] ;
	$p_parentFilerecordId = $post_data['parent_filerecord_id'] ;
	$attach_filerecordId = $post_data['filerecord_id'] ;
	
	switch( $p_parentFileCode ) {
		case 'order' :
			$data = paracrm_lib_data_getRecord_file('ATTACH_INBOX',$attach_filerecordId) ;
			if( !$data ) {
				return array('success'=>false) ;
			}
			
			$arr_ins = array() ;
			$arr_ins['field_ATTACHMENT_DATE'] = $data['field_ATTACHMENT_DATE'] ;
			$arr_ins['field_ATTACHMENT_TXT'] = $data['field_ATTACHMENT_TXT'] ;
			$arr_ins['field_ATTACHMENT_CATG'] = $data['field_ATTACHMENT_CATG'] ;
			$arr_ins['field_ATTACHMENT_DISCARD'] = $data['field_ATTACHMENT_DISCARD'] ;
			$img_filerecordId = paracrm_lib_data_insertRecord_file( 'CDE_ATTACH', $p_parentFilerecordId, $arr_ins ) ;
			
			media_contextOpen( $_POST['_sdomainId'] ) ;
			media_auto_move( media_toolFile_getId('ATTACH_INBOX',$attach_filerecordId) , media_toolFile_getId('CDE_ATTACH',$img_filerecordId) ) ;
			media_contextClose() ;

			paracrm_lib_data_deleteRecord_file('ATTACH_INBOX',$attach_filerecordId) ;
			break ;
		default :
			return array('success'=>false) ;
	}

	return array('success'=>true) ;
}
function specDbsTracy_attachments_detach($post_data) {
	$p_parentFileCode = $post_data['parent_file_code'] ;
	$p_parentFilerecordId = $post_data['parent_filerecord_id'] ;
	$attach_filerecordId = $post_data['filerecord_id'] ;
	
	switch( $p_parentFileCode ) {
		case 'order' :
			$data = paracrm_lib_data_getRecord_file('CDE_ATTACH',$attach_filerecordId) ;
			if( !$data ) {
				return array('success'=>false) ;
			}
			
			$arr_ins = array() ;
			$arr_ins['field_ATTACHMENT_DATE'] = $data['field_ATTACHMENT_DATE'] ;
			$arr_ins['field_ATTACHMENT_TXT'] = $data['field_ATTACHMENT_TXT'] ;
			$arr_ins['field_ATTACHMENT_CATG'] = $data['field_ATTACHMENT_CATG'] ;
			$arr_ins['field_ATTACHMENT_DISCARD'] = $data['field_ATTACHMENT_DISCARD'] ;
			$img_filerecordId = paracrm_lib_data_insertRecord_file( 'ATTACH_INBOX', 0, $arr_ins ) ;
			
			media_contextOpen( $_POST['_sdomainId'] ) ;
			media_auto_move( media_toolFile_getId('CDE_ATTACH',$attach_filerecordId) , media_toolFile_getId('ATTACH_INBOX',$img_filerecordId) ) ;
			media_contextClose() ;

			paracrm_lib_data_deleteRecord_file('CDE_ATTACH',$attach_filerecordId) ;
			break ;
		default :
			return array('success'=>false) ;
	}

	return array('success'=>true) ;
}





function specDbsTracy_attachments_getInbox($post_data) {
	$forward_post = array() ;
	$forward_post['start'] ;
	$forward_post['limit'] ;
	$forward_post['file_code'] = 'ATTACH_INBOX' ;
	$ttmp = paracrm_data_getFileGrid_data( $forward_post, $auth_bypass=TRUE ) ;
	$paracrm_TAB = $ttmp['data'] ;
	$TAB = array() ;
	foreach( $paracrm_TAB as $paracrm_row ) {
		$TAB[] = array(
			'attachment_media_id'=> media_toolFile_getId('ATTACH_INBOX',$paracrm_row['ATTACH_INBOX_id']),
			'attachment_filerecord_id'=> $paracrm_row['ATTACH_INBOX_id'],
			'parent_file' => '',
			'attachment_date' => date('Y-m-d',strtotime($paracrm_row['ATTACH_INBOX_field_ATTACHMENT_DATE'])),
			'attachment_txt' => $paracrm_row['ATTACH_INBOX_field_ATTACHMENT_TXT'],
			'attachment_catg' => $paracrm_row['ATTACH_INBOX_field_ATTACHMENT_CATG'],
			'attachment_discard' => $paracrm_row['ATTACH_INBOX_field_ATTACHMENT_DISCARD'],
		) ;
	}
	return array('success'=>true, 'data'=>$TAB) ;
}


function specDbsTracy_attachments_buildZipArchive($post_data) {
	$p_orderFilerecordId = $post_data['order_filerecord_id'] ;
	$p_mediaIds = json_decode($post_data['media_ids'],true);
	
	$json = specDbsTracy_order_getRecords(array(
		'filter_orderFilerecordId_arr' => json_encode(array($p_orderFilerecordId)),
	));
	if( $json['success'] && count($json['data'])==1 ) {
		$order_row = reset($json['data']);
	}
	if( !$order_row ) {
		return array('success'=>false) ;
	}
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	$map_filename_bin = array() ;
	foreach( $order_row['attachments'] as $attachment_row ) {
		$media_id = $attachment_row['attachment_media_id'];
		if( !in_array($media_id,$p_mediaIds) ) {
			continue ;
		}
		
		media_contextOpen( $_sdomain_id ) ;
		switch( media_auto_getType($media_id) ) {
			case 'pdf' :
				$bin = media_pdf_getBinary($media_id);
				$extension = 'pdf';
				break ;
			case 'img' :
				$bin = media_img_getBinary($media_id) ;
				$extension = 'jpg';
				break ;
			default :
				continue 2 ;
		}
		media_contextClose() ;
		
		
		$c=0 ;
		while(TRUE) {
			$c++;
			if( $c > 9 ) {
				continue 2 ;
			}
			
			$filename = array();
			if( $attachment_row['attachment_catg'] ) {
				$filename[]= $attachment_row['attachment_catg'] ;
			}
			$filename[]= preg_replace("/[^a-zA-Z0-9]/", "",$attachment_row['attachment_txt']) ;
			if( $c > 1 ) {
				$filename[] = (string)$c;
			}
			if( $attachment_row['attachment_discard'] ) {
				$filename[] = 'obsolete' ;
			}
			$filename[] = $extension ;
			$filename = implode('.',$filename);
			
			if( !isset($map_filename_bin[$filename]) ) {
				break ;
			}
		}
		
		$map_filename_bin[$filename] = $bin ;
	}
	
	$title = $order_row['id_soc'].'_'.preg_replace("/[^a-zA-Z0-9]/", "",$order_row['id_dn']).'.zip' ;
	$filename_zip = 'DN_'.$title.'_'.time().'.zip' ;
	$filepath_zip = tempnam(sys_get_temp_dir(),'op5').'.zip' ;
	$obj_zip = new ZipArchive() ;
	$obj_zip->open( $filepath_zip , ZIPARCHIVE::CREATE ) ;
	foreach( $map_filename_bin as $filename => $bin ) {
		$obj_zip->addFromString( $filename , $bin ) ;
	}
	$obj_zip->close() ;
	
	$bin = file_get_contents($filepath_zip) ;
	unlink($filepath_zip) ;
	
	return array('success'=>true, 'bin_filename'=>$filename_zip, 'bin_base64'=>base64_encode($bin)) ;
}







function specDbsTracy_attachments_mediaGetPreview($post_data) {
	$p_mediaId = $post_data['media_id'] ;
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	media_contextOpen( $_sdomain_id ) ;
	switch( media_auto_getType($p_mediaId) ) {
		case 'pdf' :
			$TAB = array() ;
			$page_idx = 0 ;
			foreach( media_pdf_getPreviewsBinary($p_mediaId) as $jpg_binary ) {
				$page_idx++ ;
				$TAB[] = array(
					'page_idx' => $page_idx,
					'thumb_base64' => base64_encode($jpg_binary)
				);
			}
			break ;
			
		case 'img' :
			$jpg_binary = media_img_getBinary($p_mediaId,true) ;
			$TAB = array( array('page_idx'=>0, 'thumb_base64'=>base64_encode($jpg_binary)) );
			break ;
			
		default :
			return array('success'=>false);
	}
	media_contextClose();
	
	return array('success'=>true, 'data'=>$TAB) ;
}
function specDbsTracy_attachments_mediaGetPage($post_data) {
	$p_mediaId = $post_data['media_id'] ;
	$p_pageIdx = $post_data['page_idx'] ;
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	media_contextOpen( $_sdomain_id ) ;
	switch( media_auto_getType($p_mediaId) ) {
		case 'pdf' :
			$jpeg_binary = media_pdf_getPageBinary( $p_mediaId , $p_pageIdx );
			break ;
		case 'img' :
			$jpeg_binary = media_img_getBinary($p_mediaId) ;
			break ;
		default :
			return array('success'=>false);
	}
	media_contextClose() ;
	
	return array('success'=>true, 'data'=>base64_encode($jpeg_binary)) ;
}
function specDbsTracy_attachments_mediaGetBinary( $post_data ) {
	$p_mediaId = $post_data['media_id'] ;
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	media_contextOpen( $_sdomain_id ) ;
	switch( media_auto_getType($p_mediaId) ) {
		case 'pdf' :
			$bin = media_pdf_getBinary($p_mediaId);
			$extension = 'pdf';
			break ;
		case 'img' :
			$bin = media_img_getBinary($p_mediaId) ;
			$extension = 'jpg';
			break ;
		default :
			return array('success'=>false);
	}
	media_contextClose() ;
	
	$filename = array() ;
	if( strpos($p_mediaId,'CDE_ATTACH'.'_')===0 ) {
		$cdeattach_filerecord_id = (int)substr($p_mediaId,strlen('CDE_ATTACH'.'_')) ;
		$arr_media = paracrm_lib_data_getRecord_file('CDE_ATTACH',$cdeattach_filerecord_id) ;
		$cde_filerecord_id = $arr_media['filerecord_parent_id'] ;
		$arr_cde = paracrm_lib_data_getRecord_file('CDE',$cde_filerecord_id) ;
		$filename[]= preg_replace("/[^a-zA-Z0-9]/", "",$arr_cde['field_ID_DN']) ;
		if( $arr_media['field_ATTACHMENT_CATG'] ) {
			$filename[]= preg_replace("/[^a-zA-Z0-9]/", "",$arr_media['field_ATTACHMENT_CATG']) ;
		} else {
			$filename[]= preg_replace("/[^a-zA-Z0-9]/", "",$arr_media['field_ATTACHMENT_TXT']) ;
		}
	}
	if( strpos($p_mediaId,'ATTACH_INBOX'.'_')===0 ) {
		$attach_filerecord_id = (int)substr($p_mediaId,strlen('ATTACH_INBOX'.'_')) ;
		$arr_media = paracrm_lib_data_getRecord_file('ATTACH_INBOX',$attach_filerecord_id) ;
		$filename[]= preg_replace("/[^a-zA-Z0-9]/", "",$arr_media['field_ATTACHMENT_TXT']) ;
	}
	if( !$filename ) {
		$filename[]= $p_mediaId;
	}
	$filename[]= $extension;
	
	$filename = implode('.',$filename) ;
	return array('success'=>true, 'bin_filename'=>$filename, 'bin_base64'=>base64_encode($bin)) ;
}




?>
