<?php
define('SPECDBSTRACY_GUN_T60_CODE','specDbsTracy_gun_t60') ;

function specDbsTracy_gun_t60_lib_populateTrspt( &$obj_brt ) {
	// CFG: liste des carriers
	$ttmp = specDbsTracy_cfg_getConfig() ;
	$json_cfg = $ttmp['data'] ;
	$map_carrierId_row = array() ;
	foreach( $json_cfg['cfg_list'] as $list ) {
		if( $list['bible_code'] == 'LIST_CARRIER' ) {
			foreach( $list['records'] as $carrier_row ) {
				$map_carrierId_row[$carrier_row['id']] = $carrier_row['row'] ;
			}
		}
	}
	
	$forward_post = array() ;
	foreach( $obj_brt as $mkey => $mvalue ) {
		if( strpos($mkey,'filter_')===0 ) {
			$forward_post[$mkey] = $mvalue ;
		}
	}
	$post_data = array(
		'query_step_next' => '60_TRSPTREADY'
	);
	$json = specDbsTracy_gun_getTrsptRecords($post_data) ;
	foreach( $json['data'] as $trspt_row ) {
		if( $trspt_row['ready_is_adr'] ) {
			//NOTE 13/12/23, force is_adr
			$obj_brt['arr_trsptFilerecordIds'][] = $trspt_row['trspt_filerecord_id'] ;
			continue ;
		}
		$cfg_carrier = $map_carrierId_row[$trspt_row['mvt_carrier']] ;
		if( !$cfg_carrier['field_IS_INTEGRATEUR'] && !$cfg_carrier['field_IS_ADR'] ) {
			continue ; // Exclusion si hors circuit intégrateur OU adressable (AOG panel)
		}
		if( count($trspt_row['hats']) > 1 ) {
			continue ; // HACK : pas de hat multiple (facture)
		}
		$obj_brt['arr_trsptFilerecordIds'][] = $trspt_row['trspt_filerecord_id'] ;
	}
}










function specDbsTracy_gun_t60_transactionGetActiveId($post_data) {
	// TMP: only one active session, using PHP SESSION, (no database)
	$transaction_id = null ;
	if( isset($_SESSION['transactions']) ) {
		foreach( $_SESSION['transactions'] as $iter_transaction_id => $dummy ) {
			if( $_SESSION['transactions'][$iter_transaction_id]['transaction_code'] == SPECDBSTRACY_GUN_T60_CODE ) {
				$transaction_id = $iter_transaction_id ;
			}
		}
	}
	usleep(100*1000) ;
	return array('success'=>true, 'transaction_id'=>$transaction_id) ;
}
function specDbsTracy_gun_t60_lib_stepValidate( $obj_brt, $trspt_filerecord_id ) {
	$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode($obj_brt['arr_trsptFilerecordIds']))) ;
	foreach( $json['data'] as $trspt_row ) {
		if( $trspt_filerecord_id != $trspt_row['trspt_filerecord_id'] ) {
			continue ;
		}
	
		// next step = 60_TRSPTREADY
		if( $trspt_row['calc_step_next'] != '60_TRSPTREADY' ) {
			continue ;
		}
		
		// scan complet ?
		$complete = TRUE ;
		$arr_hatparcelFilerecordIds = array() ;
		foreach( $trspt_row['hats'] as $iter_hat_row ) {
			foreach( $iter_hat_row['parcels'] as $iter_hatparcel_row ) {
				$arr_hatparcelFilerecordIds[] = $iter_hatparcel_row['hatparcel_filerecord_id'] ;
			}
		}
		foreach( $arr_hatparcelFilerecordIds as $hatparcel_filerecord_id ) {
			if( !in_array($hatparcel_filerecord_id,$obj_brt['arr_hatparcelFilerecordIds']) ) {
				$complete = FALSE ;
			}
		}
		if( !$complete ) {
			continue ;
		}
		
		$params = array(
			'trspt_filerecord_id' => $trspt_filerecord_id,
			'step_code' => '60_TRSPTREADY'
		) ;
		$ttmp = specDbsTracy_trspt_stepValidate( $params ) ;
	}
}
function specDbsTracy_gun_t60_postAction($post_data, $_recycle=false) {
	global $_opDB ;
	
	// CFG: liste des socs
	$ttmp = specDbsTracy_cfg_getConfig() ;
	$json_cfg = $ttmp['data'] ;
	$arr_socCodes = array() ;
	$arr_carrierIntegrateur = array() ;
	$arr_carrierAdr = array() ;
	foreach( $json_cfg['cfg_soc'] as $soc_row ) {
		$arr_socCodes[] = $soc_row['soc_code'] ;
	}
	foreach( $json_cfg['cfg_list'] as $list ) {
		if( $list['bible_code'] == 'LIST_CARRIER' ) {
			foreach( $list['records'] as $carrier_row ) {
				if( $carrier_row['row']['field_IS_INTEGRATEUR'] ) {
					$arr_carrierIntegrateur[] = $carrier_row['id'] ;
				}
				if( $carrier_row['row']['field_IS_ADR'] ) {
					$arr_carrierAdr[] = $carrier_row['id'] ;
				}
			}
		}
	}
	
	// create, Flash, confirm/abort
	$p_transactionId = $post_data['_transaction_id'] ;
	$p_subaction = $post_data['_subaction'] ;
	$p_data = json_decode($post_data['data'],true) ;
	
	switch( $p_subaction ) {
		case 'close' :
			if( isset($_SESSION['transactions'][$p_transactionId]) 
				&& ($_SESSION['transactions'][$p_transactionId]['transaction_code'] == SPECDBSTRACY_GUN_T60_CODE) ) {
				
				unset($_SESSION['transactions'][$p_transactionId]) ;
			}
			return array('success'=>true) ;
		
		
		case 'open_force' :
			$json = specDbsTracy_gun_t60_transactionGetActiveId(array()) ;
			if( $json['success'] && $json['transaction_id'] ) {
				unset($_SESSION['transactions'][$json['transaction_id']]) ;
			}
		case 'open' :
			while( TRUE ) {
				$json = specDbsTracy_gun_t60_transactionGetActiveId(array()) ;
				if( $json['success'] && $json['transaction_id'] ) {
					return array('success'=>true, 'transaction_id'=>$json['transaction_id']) ;
				}
				break ;
			}
			
			$obj_brt = array(
				'date_create' => date('Y-m-d H:i:s'),
				'arr_trsptFilerecordIds' => array(),
				'arr_hatparcelFilerecordIds' => array()
			) ;
			
			// DONE 17/09/21 : populate
			specDbsTracy_gun_t60_lib_populateTrspt($obj_brt) ;
			
			$transaction_id = $_SESSION['next_transaction_id']++ ;
		
			$_SESSION['transactions'][$transaction_id] = array() ;
			$_SESSION['transactions'][$transaction_id]['transaction_code'] = SPECDBSTRACY_GUN_T60_CODE ;
			$_SESSION['transactions'][$transaction_id]['obj_brt'] = $obj_brt ;
			
			return array('success'=>true, 'transaction_id'=>$transaction_id) ;
		
		
		case 'scan_aog' :
			$p_scanval = strtoupper(trim($post_data['scanval'])) ;
			
			$p_scanval_local = $p_scanval;
			if( $do_sanitize=true ) {
				$p_scanval_new = $p_scanval_local ;
				$p_scanval_new = preg_replace("/[^0-9\s]/", "", $p_scanval_new) ;
				$p_scanval_new = (string)(int)$p_scanval_new ;
				$p_scanval_local = $p_scanval_new ;
			}
			$query = "SELECT filerecord_id FROM view_file_CDE WHERE field_ID_DN='{$p_scanval_local}' AND field_ARCHIVE_IS_ON='0'" ;
			$order_filerecord_id = $_opDB->query_uniqueValue($query) ;
			if( !$order_filerecord_id ) {
				return array(
					'success'=>true,
					'data' => array(
						'header'=>array('result_type' => 'fail'),
						'reason' => 'Scanned item not recognized'
					)
				);
			}
			
			$json = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($order_filerecord_id)))) ;
			$order_row = reset($json['data']) ;
			
			if( $order_row['aog_is_on'] && $order_row['calc_link_trspt_filerecord_id'] ) {
				$forward_post = $post_data ;
				$forward_post['_subaction'] = 'scan' ;
				$forward_post['scanval'] = $p_scanval ;
				return specDbsTracy_gun_t60_postAction( $forward_post ) ;
			}
			
			$has_bogusSteps = FALSE ;
			foreach( $order_row['steps'] as $row_order_step ) {
				if( ($row_order_step['step_code'] == '70_PICKUP') && $row_order_step['status_is_ok'] ) {
					$has_bogusSteps = TRUE ;
				}
			}
			if( $has_bogusSteps ) {
				return array(
					'success'=>true,
					'data' => array(
						'header'=>array('result_type' => 'fail'),
						'reason' => 'Already picked. Contact AOG Desk',
					)
				);
			}
			
			$fields = array() ;
			$fields[] = array(
				'label' => 'Order #',
				'text' => $order_row['id_dn'],
			);
			$fields[] = array(
				'label' => 'Consignee',
				'text' => $order_row['atr_consignee']
			);
			$fields[] = array(
				'label' => 'Priority',
				'text' => $order_row['atr_priority']
			);
			$fields[] = array(
				'label' => 'Incoterm',
				'text' => $order_row['atr_incoterm']
			);
			return array(
				'success'=>true,
				'data' => array(
					'fields' => $fields,
					'primary_key' => array('name'=>'order_filerecord_id','value'=>$order_filerecord_id),
					'header'=>array(
						'result_type' => 'aog_enroll',
						'aog_txt_title' => $order_row['aog_is_on'] ? 'No transport file' : 'AOG Upgrade',
						'aog_txt_caption' => $order_row['aog_is_on'] ? 'Blank transport file will be created' : 'Need AOG confirmation',
					),
					//'reason' => 'AOG ID : '.$order_filerecord_id,
					'aog_enroll' => true,
				)
			);
		
		case 'scan' :
			$p_scanval = strtoupper(trim($post_data['scanval'])) ;
			for( $i=0 ; $i<2 ; $i++ ) {
				$do_sanitize = !!$i ;
				if( $do_sanitize ) {
					$p_scanval_new = $p_scanval ;
					$p_scanval_new = preg_replace("/[^0-9\s]/", "", $p_scanval_new) ;
					$p_scanval_new = (string)(int)$p_scanval_new ;
					if( $p_scanval_new==$p_scanval ) {
						break ;
					}
					$p_scanval = $p_scanval_new ;
				}
				$forward_post = $post_data ;
				$forward_post['_subaction'] = 'scan_pass' ;
				$forward_post['scanval'] = $p_scanval ;
				$res = specDbsTracy_gun_t60_postAction( $forward_post ) ;
				if( $res['success'] && $res['data']['header']['result_type']=='fail' ) {
					continue ;
				}
				break ;
			}
			return $res ;
			
		case 'scan_pass' :
			$obj_brt = $_SESSION['transactions'][$p_transactionId]['obj_brt'] ;
			if( !$obj_brt ) {
				return array(
					'success'=>true,
					'data' => array(
						'header'=>array('result_type' => 'fail'),
						'reason' => "Session error\nStart new transaction"
					)
				);
			}
			
			$p_scanval = strtoupper(trim($post_data['scanval'])) ;
			if( !$p_scanval ) {
				return array(
					'success'=>true,
					'data' => array(
						'header'=>array('result_type' => 'fail'),
						'reason' => "Scan value is empty"
					)
				);
			}
			$p_scanval = $_opDB->escape_string($p_scanval) ;
			
			$scanval_type = 'hat_parcel' ;
			$ttmp = explode('/',$p_scanval) ;
			if( (count($ttmp)==2) && in_array($ttmp[0],$arr_socCodes) ) {
				$scanval_type = 'trspt_id_doc' ;
			}
			
			while( TRUE ) {
				switch( $scanval_type ) {
					case 'hat_parcel' :
						$hatparcel_filerecord_id = NULL ;
						while( TRUE ) {
							$query = "SELECT hp.filerecord_id FROM view_file_HAT_PARCEL hp
											WHERE hp.filerecord_parent_id 
											= (SELECT h.filerecord_id FROM view_file_HAT h WHERE h.field_ID_HAT='{$p_scanval}')
											LIMIT 1" ;
							if( $hatparcel_filerecord_id = $_opDB->query_uniqueValue($query) ) {
								break ;
							}
							
							$query = "SELECT hp.filerecord_id FROM view_file_HAT_PARCEL hp
											WHERE hp.field_SPEC_BARCODE='{$p_scanval}'" ;
							if( $hatparcel_filerecord_id = $_opDB->query_uniqueValue($query) ) {
								break ;
							}
							
							$query = "SELECT hp.filerecord_id FROM view_file_HAT_PARCEL hp
											WHERE hp.field_SPEC_BARCODE='{$p_scanval}'" ;
							if( $hatparcel_filerecord_id = $_opDB->query_uniqueValue($query) ) {
								break ;
							}
							break ;
						}
						if( !$hatparcel_filerecord_id ) {
							break 2 ;
						}
						
						$query = "SELECT distinct hp.filerecord_id, tc.filerecord_parent_id 
									FROM view_file_HAT_PARCEL hp 
									JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=hp.filerecord_parent_id AND hc.field_LINK_IS_CANCEL='0' 
									JOIN view_file_TRSPT_CDE tc ON tc.field_FILE_CDE_ID=hc.field_FILE_CDE_ID AND tc.field_LINK_IS_CANCEL='0' 
									WHERE hp.filerecord_id='{$hatparcel_filerecord_id}'" ;
						$result = $_opDB->query($query) ;
						if( $_opDB->num_rows($result) != 1 ) {
							break 2 ;
						}
						$arr = $_opDB->fetch_row($result) ;
						$trspt_filerecord_id = $arr[1] ;
						
						$primary_key = array(
							'name' => 'hatparcel_filerecord_id',
							'value' => $hatparcel_filerecord_id
						);
						break ;
						
					case 'trspt_id_doc' :
						$query = "SELECT filerecord_id FROM view_file_TRSPT WHERE field_ID_DOC='{$p_scanval}'" ;
						$result = $_opDB->query($query) ;
						if( $_opDB->num_rows($result) != 1 ) {
							break 2 ;
						}
						$arr = $_opDB->fetch_row($result) ;
						$trspt_filerecord_id = $arr[0] ;
						
						$primary_key = array(
							'name' => 'trspt_filerecord_id',
							'value' => $trspt_filerecord_id
						);
						break ;
				}
				break ;
			}
			if( !$trspt_filerecord_id ) {
				// 22/12/2020 : cas du flash d'un BL => retrieve du parcel
				while( !$_recycle ) { // mode fallback
					$query = "SELECT filerecord_id FROM view_file_CDE WHERE field_ID_DN='{$p_scanval}'" ;
					$order_filerecord_id = $_opDB->query_uniqueValue($query) ;
					if( !$order_filerecord_id ) {
						break ;
					}
					$query = "SELECT h.field_ID_HAT
								FROM view_file_HAT h
								JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=h.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
								WHERE hc.field_FILE_CDE_ID='{$order_filerecord_id}'" ;
					$fallback_idHat = $_opDB->query_uniqueValue($query) ;
					if( $fallback_idHat ) {
						$forward_post = $post_data ;
						$forward_post['scanval'] = $fallback_idHat ;
						return specDbsTracy_gun_t60_postAction( $forward_post, $_recycle=true ) ;
					}
					
					
					break ;
				}
				
				
				return array(
					'success'=>true,
					'data' => array(
						'header'=>array('result_type' => 'fail'),
						'reason' => 'Scanned item not recognized'
					)
				);
			}
			$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($trspt_filerecord_id)))) ;
			$trspt_row = $json['data'][0] ;
			
			//print_r($trspt_row) ;
			$fields = array() ;
			$fields[] = array(
				'label' => 'Trspt. Doc',
				'text' => $trspt_row['id_doc']
			);
			$fields[] = array(
				'label' => 'Carrier',
				'text' => $trspt_row['mvt_carrier']
			);
			$fields[] = array(
				'label' => 'Consignee',
				'text' => $trspt_row['atr_consignee']
			);
			if( !$hatparcel_filerecord_id ) {
				$order_ids = array() ;
				foreach( $trspt_row['orders'] as $order_row ) {
					$order_ids[] = $order_row['id_dn'] ;
				}
				$fields[] = array(
					'label' => 'Order(s)',
					'text' => implode(' ',$order_ids)
				);
			}
			if( $hatparcel_filerecord_id ) {
				$hat_row = $hatparcel_row = NULL ;
				foreach( $trspt_row['hats'] as $iter_hat_row ) {
					foreach( $iter_hat_row['parcels'] as $iter_hatparcel_row ) {
						if( $iter_hatparcel_row['hatparcel_filerecord_id'] == $hatparcel_filerecord_id ) {
							$hat_row = $iter_hat_row ;
							$hatparcel_row = $iter_hatparcel_row ;
						}
					}
				}
				$fields[] = array(
					'label' => 'ShipGroup #',
					'text' => $hat_row['id_hat']
				);
				$order_ids = array() ;
				foreach( $hat_row['orders'] as $order_row ) {
					$order_ids[] = $order_row['id_dn'] ;
				}
				$fields[] = array(
					'label' => 'Order(s)',
					'text' => implode(' ',$order_ids)
				);
				if( $hatparcel_row['tms_tracking'] ) {
					$fields[] = array(
						'label' => 'Tracking',
						'text' => $hatparcel_row['tms_tracking']
					);
				}
				$fields[] = array(
					'label' => 'Weight',
					'text' => $hatparcel_row['vol_kg'].' kg'
				);
				if( $trspt_row['ready_is_adr'] ) {
					$fields[] = array(
						'label_id' => 'adr_id',
						'label' => 'Location',
						'text' => $trspt_row['ready_adr_id'],
					);
				}
			}
			
			// Conditions :
			// - step_code_next
			// - mvt_carrier
			// - filter_soc ?
			// HACK TODO : affichage du statut actuel si erreur
			$errors = array() ;
			if( $trspt_row['calc_step'] == '60_TRSPTREADY' ) {
				// no error (rescan)
			} elseif( $trspt_row['calc_step_next'] != '60_TRSPTREADY' ) {
				$errors[] = 'Not ready for step 60_TRSPTREADY' ;
			}
			
			$result_type = ($errors ? 'fail' : 'success');
			
			if( ($result_type=='success') && ( in_array($trspt_row['mvt_carrier'],$arr_carrierAdr) || $trspt_row['ready_is_adr'] ) ) {
				$has_adr = true ;
			}
			
			if( ($result_type=='success') && in_array($trspt_row['mvt_carrier'],$arr_carrierIntegrateur) ) {
				$result_type = 'tms' ;
				$primary_key = array(
					'name' => 'trspt_filerecord_id',
					'value' => $trspt_filerecord_id
				);
				
				// verif colis unique ?
				$iter_hatparcelFilerecordIds = array() ;
				foreach( $trspt_row['hats'] as $iter_hat_row ) {
					foreach( $iter_hat_row['parcels'] as $iter_hatparcel_row ) {
						$iter_hatparcelFilerecordIds[] = $iter_hatparcel_row['hatparcel_filerecord_id'] ;
					}
				}
				if( count($iter_hatparcelFilerecordIds) != 1 ) {
					$result_type = 'fail' ;
					$errors[] = 'Intégrateur - Colis multiple non supporté' ;
				}
			}
			
			if( ($result_type=='success') && ( in_array($trspt_row['mvt_carrier'],$arr_carrierAdr) || $trspt_row['ready_is_adr'] ) ) {
				$result_type = 'adr' ;
				$primary_key = array(
					'name' => 'trspt_filerecord_id',
					'value' => $trspt_filerecord_id
				);
			}
			
			if( $result_type=='success' ) {
				$arr_hatparcelFilerecordIds = array() ;
				if( $hatparcel_filerecord_id ) {
					$arr_hatparcelFilerecordIds[] = $hatparcel_filerecord_id ;
					if( in_array($hatparcel_filerecord_id,$obj_brt['arr_hatparcelFilerecordIds']) ) {
						$result_type = 'success' ;
					}
				}
				
				if( !in_array($trspt_filerecord_id,$obj_brt['arr_trsptFilerecordIds']) ) {
					$obj_brt['arr_trsptFilerecordIds'][] = $trspt_filerecord_id ;
				}
				foreach( $arr_hatparcelFilerecordIds as $hatparcel_filerecord_id ) {
					if( !in_array($hatparcel_filerecord_id,$obj_brt['arr_hatparcelFilerecordIds']) ) {
						$obj_brt['arr_hatparcelFilerecordIds'][] = $hatparcel_filerecord_id ;
					}
				}
				$_SESSION['transactions'][$p_transactionId]['obj_brt'] = $obj_brt ;
				
				
				specDbsTracy_gun_t60_lib_stepValidate($obj_brt, $trspt_filerecord_id) ;
			}
			
			// TODO HACK : Bouton impression si tms_printable
			
			if( $errors ) {
				$reason = '';
				foreach( $errors as $error ) {
					$reason.= '- '.$error."\n" ;
				}
			}
			return array(
				'success'=>true,
				'data' => array(
					'header'=>array('result_type' => $result_type),
					'primary_key' => $primary_key,
					'fields' => $fields,
					'reason' => $reason,
					'tms' => $result_type == 'tms' ? true : false,
					'adr' => ($has_adr),
				)
			);
			
		case 'tms_init' :
			$p_trsptFilerecordId = $post_data['trspt_filerecord_id'] ;
			$p_printerUri = $post_data['printer_uri'] ;
			if( !specDbsTracy_gun_t60_lib_tmsNeedLabel($p_trsptFilerecordId) ) {
				return array(
					'success' => true,
					'tms_error' => false,
					'tms_print' => false,
				);
			}
			while( true ) {
				$tms_error_str = NULL ;
				
				$tms_print = specDbsTracy_gun_t60_lib_tmsFetchLabel($p_trsptFilerecordId) ;
				if( !$tms_print ) {
					$tms_error_str = 'No label / invalid' ;
					break ;
				}
				if( (strpos($p_printerUri,'spool:')===0) ) {
					// $p_printerUri => $printer_str
					$printer_str = substr($p_printerUri,strlen('spool:')) ;
					$print_success = specDbsTracy_gun_t60_lib_tmsPrintLabel( $p_trsptFilerecordId, $printer_str ) ;
					if( !$print_success ) {
						$tms_error_str = 'Print error / Unreachable' ;
						break ;
					}
				}
				break ;
			}
			return array(
				'success' => true,
				'tms_error' => !!$tms_error_str,
				'tms_error_str' => $tms_error_str,
				'tms_print' => $tms_print,
			);
			
		case 'tms_scan' :
			$p_tmsScanval = strtoupper(trim($post_data['tms_scanval'])) ;
			$p_trsptFilerecordId = $post_data['trspt_filerecord_id'] ;
			
			$tms_result = specDbsTracy_gun_t60_lib_tmsValidateLabel($p_trsptFilerecordId,$p_tmsScanval) ;
			if( $tms_result ) {
				$obj_brt = $_SESSION['transactions'][$p_transactionId]['obj_brt'] ;
				
				$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($p_trsptFilerecordId)))) ;
				$trspt_row = $json['data'][0] ;
	
				$iter_hatparcelFilerecordIds = array() ;
				foreach( $trspt_row['hats'] as $iter_hat_row ) {
					foreach( $iter_hat_row['parcels'] as $iter_hatparcel_row ) {
						$iter_hatparcelFilerecordIds[] = $iter_hatparcel_row['hatparcel_filerecord_id'] ;
					}
				}
				if( count($iter_hatparcelFilerecordIds) == 1 ) {
					$trspt_filerecord_id = $p_trsptFilerecordId ;
					$hatparcel_filerecord_id = reset($iter_hatparcelFilerecordIds) ;
					if( !in_array($trspt_filerecord_id,$obj_brt['arr_trsptFilerecordIds']) ) {
						$obj_brt['arr_trsptFilerecordIds'][] = $trspt_filerecord_id ;
					}
					if( !in_array($hatparcel_filerecord_id,$obj_brt['arr_hatparcelFilerecordIds']) ) {
						$obj_brt['arr_hatparcelFilerecordIds'][] = $hatparcel_filerecord_id ;
					}
					specDbsTracy_gun_t60_lib_stepValidate($obj_brt, $trspt_filerecord_id) ;
				}
				
				$_SESSION['transactions'][$p_transactionId]['obj_brt'] = $obj_brt ;
			}
			
			return array(
				'success' => true,
				'tms_result' => $tms_result,
				'need_adr' => ($trspt_row && $trspt_row['ready_is_adr']),
			);
			
		case 'adr_set' :
			$p_adrScanval = strtoupper(trim($post_data['adr_scanval'])) ;
			$p_trsptFilerecordId = $post_data['trspt_filerecord_id'] ;
			
			$p_adrScanval = trim(strtoupper($p_adrScanval)) ;
			$adrIsValid = (substr($p_adrScanval,0,1)=='M') && (substr($p_adrScanval,2,1)=='-');
			if( !$adrIsValid ) {
				return array(
					'success' => true,
					'adr_result' => false,
					'adr_id' => $p_adrScanval,
					'debug' => $p_trsptFilerecordId,
				);
			}
			if( $adrIsValid ) { // TODO: validate ADR ?
				$obj_brt = $_SESSION['transactions'][$p_transactionId]['obj_brt'] ;
				
				$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($p_trsptFilerecordId)))) ;
				$trspt_row = $json['data'][0] ;
				
				paracrm_lib_data_updateRecord_file( 'TRSPT', array('field_READY_ADR_ID'=>$p_adrScanval), $p_trsptFilerecordId );
				
				$iter_hatparcelFilerecordIds = array() ;
				foreach( $trspt_row['hats'] as $iter_hat_row ) {
					foreach( $iter_hat_row['parcels'] as $iter_hatparcel_row ) {
						$iter_hatparcelFilerecordIds[] = $iter_hatparcel_row['hatparcel_filerecord_id'] ;
					}
				}
				if( count($iter_hatparcelFilerecordIds) == 1 ) {
					$trspt_filerecord_id = $p_trsptFilerecordId ;
					$hatparcel_filerecord_id = reset($iter_hatparcelFilerecordIds) ;
					if( !in_array($trspt_filerecord_id,$obj_brt['arr_trsptFilerecordIds']) ) {
						$obj_brt['arr_trsptFilerecordIds'][] = $trspt_filerecord_id ;
					}
					if( !in_array($hatparcel_filerecord_id,$obj_brt['arr_hatparcelFilerecordIds']) ) {
						$obj_brt['arr_hatparcelFilerecordIds'][] = $hatparcel_filerecord_id ;
					}
					specDbsTracy_gun_t60_lib_stepValidate($obj_brt, $trspt_filerecord_id) ;
					
					// HACK !
					// 5/02/2024 => trigger OK_CARRIER_POD
					paracrm_queries_direct( array(
						'q_type' => 'qsql',
						'q_id' => 'OK_CARRIER_POD'
					),true,true) ;
					
					foreach( $trspt_row['orders'] as $order_row ) {
						$order_filerecord_id = $order_row['order_filerecord_id'] ;
						
						// HACK !
						// 21/02/2024 => trigger AOG_EMAIL
						paracrm_queries_direct( array(
							'q_type' => 'qsql',
							'q_id' => 'AOG_EMAIL',
							'q_vars' => json_encode(array(
								'order_filerecord_id' => $order_filerecord_id,
							)),
						),true,true) ;
					}
				}
				
				$_SESSION['transactions'][$p_transactionId]['obj_brt'] = $obj_brt ;
			}
			
			return array(
				'success' => true,
				'adr_result' => true,
				'adr_id' => $p_adrScanval,
				'debug' => $p_trsptFilerecordId,
			);
			
		case 'aog_enroll' :
			$p_orderFilerecordId = $post_data['order_filerecord_id'] ;
			
			$json = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($p_orderFilerecordId)))) ;
			$order_row = reset($json['data']) ;
			
			$has_AOGwarning = FALSE ;
			if( $order_row['warning_is_on'] ) {
				$has_AOGwarning = TRUE ;
			}
			specDbsTracy_aogpanel_lib_enrollOrder($p_orderFilerecordId, !$has_AOGwarning) ;
			
			$forward_post = $post_data ;
			$forward_post['_subaction'] = 'scan_aog' ;
			$forward_post['scanval'] = $order_row['id_dn'] ;
			$res = specDbsTracy_gun_t60_postAction( $forward_post ) ;
			return $res ;
			
			break ;
			
		default :
			break ;
	}
	
}
function specDbsTracy_gun_t60_getSummary($post_data) {

	// HACK TODO : N'AFFICHER LE RESULTAT QUE DE LA DERNIERE TRANSACTION

	$p_transactionId = $post_data['_transaction_id'] ;
	if( isset($_SESSION['transactions'][$p_transactionId]) 
		&& ($_SESSION['transactions'][$p_transactionId]['transaction_code'] == SPECDBSTRACY_GUN_T60_CODE) ) {
	} else {
		return array('success'=>false) ;
	}
	
	// CFG: liste des carriers
	$ttmp = specDbsTracy_cfg_getConfig() ;
	$json_cfg = $ttmp['data'] ;
	$mapCarrier_code_txt = array() ;
	$mapConsignee_code_txt = array() ;
	foreach( $json_cfg['cfg_list'] as $list ) {
		if( $list['bible_code'] == 'LIST_CARRIER' ) {
			foreach( $list['records'] as $carrier_row ) {
				$mapCarrier_code_txt[$carrier_row['id']] = $carrier_row['text'] ;
			}
		}
		if( $list['bible_code'] == 'LIST_CONSIGNEE' ) {
			foreach( $list['records'] as $consignee_row ) {
				$mapConsignee_code_txt[$consignee_row['id']] = $consignee_row['text'] ;
			}
		}
	}
	
	$obj_brt = $_SESSION['transactions'][$p_transactionId]['obj_brt'] ;
	
	$data_header = array() ;
	$data_header['mvt_carrier_txt'] = $mapCarrier_code_txt[$obj_brt['mvt_carrier']] ;
	if( $obj_brt['filter_soc'] ) {
		$data_header['mvt_carrier_txt'].= ' '.'('.$obj_brt['filter_soc'].')' ;
	}
	$data_header['date_create_txt'] = date('d/m/y H:i',strtotime($obj_brt['date_create'])) ;
	
	$idx = 0 ;
	$data_grid = array() ;
	foreach( $obj_brt['arr_trsptFilerecordIds'] as $trspt_filerecord_id ) {
		$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($trspt_filerecord_id)))) ;
		$trspt_row = $json['data'][0] ;
		
		$has_warning = FALSE ;
		foreach( $trspt_row['orders'] as $order_row ) {
			if( $order_row['warning_is_on'] ) {
				$has_warning = TRUE ;
				$has_warning_code = $order_row['warning_code'] ;
				break ;
			}
		}
		
		foreach( $trspt_row['hats'] as $hat_row ) {
			$hat_filerecord_id = $hat_row['hat_filerecord_id'] ;
		
			$arr_hatparcelFilerecordIds = array() ;
			foreach( $hat_row['parcels'] as $hatparcel_row ) {
				$arr_hatparcelFilerecordIds[] = $hatparcel_row['hatparcel_filerecord_id'] ;
			}
			
			$data_grid[] = array(
				'_idx' => ++$idx,
				'trspt_filerecord_id' => $trspt_filerecord_id,
				'hat_filerecord_id' => $hat_filerecord_id,
				'id_doc' => $trspt_row['id_doc'],
				'id_hat' => $hat_row['id_hat'],
				'mvt_carrier' => $trspt_row['mvt_carrier'],
				'mvt_carrier_txt' => $mapCarrier_code_txt[$trspt_row['mvt_carrier']],
				'atr_consignee' => $trspt_row['atr_consignee'],
				'atr_consignee_txt' => $mapConsignee_code_txt[$trspt_row['atr_consignee']],
				'count_parcel_scan' => count(array_intersect($arr_hatparcelFilerecordIds,$obj_brt['arr_hatparcelFilerecordIds'])),
				'count_parcel_total' => count($arr_hatparcelFilerecordIds),
				'is_warning' => $has_warning,
				'is_warning_code' => $has_warning_code
			);
		}
		
		
	}
	
	
	$data = array(
		'header' => $data_header,
		'grid' => $data_grid
	);
	return array('success'=>true, 'data'=>$data, 'debug'=>$obj_brt);
}





function specDbsTracy_gun_t60_lib_tmsNeedLabel( $trspt_filerecord_id ) {
	$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($trspt_filerecord_id)))) ;
	$trspt_row = $json['data'][0] ;
	if( (strlen($trspt_row['flight_awb'])>0) && !$trspt_row['spec_tms_status'] ) {
		return FALSE ;
	}
	return TRUE ;
}
function specDbsTracy_gun_t60_lib_tmsFetchLabel( $trspt_filerecord_id ) {
	$json = specDbsTracy_trspt_createLabelTMS( array('trspt_filerecord_id'=>$trspt_filerecord_id), $force_create=FALSE ) ;
	return $json['success'] ;
}
function specDbsTracy_gun_t60_lib_tmsPrintLabel( $trspt_filerecord_id , $printer_str ) {
	$json = specDbsTracy_trspt_createLabelTMS( array('trspt_filerecord_id'=>$trspt_filerecord_id), $force_create=FALSE ) ;
	if( $json['success'] ) {
		$forward_post = array(
			'trspt_filerecord_id'=>$trspt_filerecord_id,
			'trsptevent_filerecord_id'=>$json['trsptevent_filerecord_id'],
			'printer_str' => $printer_str
		);
		$json = specDbsTracy_trspt_printTMS($forward_post) ;
		return $json['success'] ;
	}
	return FALSE ;
}
function specDbsTracy_gun_t60_lib_tmsValidateLabel( $trspt_filerecord_id, $flight_awb ) {
	$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($trspt_filerecord_id)))) ;
	$trspt_row = $json['data'][0] ;
	if( !(strlen($trspt_row['flight_awb'])>0) ) {
		return FALSE ;
	}
	if( trim(strtoupper($trspt_row['flight_awb'])) == trim(strtoupper($flight_awb)) ) {
		return TRUE ;
	}
	if( strpos(trim(strtoupper($flight_awb)),trim(strtoupper($trspt_row['flight_awb']))) !== FALSE ) {
		return TRUE ;
	}
	return FALSE ;
}


?>
