<?php

function specDbsTracy_ticket_hintquery($post_data) {
	global $_opDB ;
	
	$p_hintFilter = json_decode($post_data['hintquery_links'],true);
	switch( $post_data['hintquery_name'] ) {
		case 'PN' :
			$query = '' ;
			switch( $p_hintFilter['id_soc'] ) {
				case 'ACL' :
					$query = "SELECT distinct ARTICLE FROM op5_dbs_prod_dwr.view_table_SNA_WM_EXPE_PERF_OTD
								WHERE 1 AND LIVRAISON IN ".$_opDB->makeSQLlist($p_hintFilter['id_dn_arr'])."
								AND ARTICLE LIKE '{$post_data['hintquery_txt']}%'
								ORDER BY ARTICLE" ;
					break ;
				case 'MBD' :
					$query = "SELECT distinct ARTICLE FROM op5_dbs_prod_dwr.view_table_SLS_WM_EXPE_PERF
								WHERE 1 AND LIVRAISON IN ".$_opDB->makeSQLlist($p_hintFilter['id_dn_arr'])."
								AND ARTICLE LIKE '{$post_data['hintquery_txt']}%'
								ORDER BY ARTICLE" ;
					break ;
			}
			break ;
	}
	$data = array();
	if( $query ) {
		$result = $_opDB->query($query) ;
		while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
			$data[] = array('value'=>$arr[0]);
		}
	}
	return array('success'=>true,'data'=>$data);
}

function specDbsTracy_ticket_getList($post_data) {
	global $_opDB ;
	
	$TAB = array() ;
	
	$query = "SELECT * FROM view_file_TICKET WHERE 1" ;
	if( $post_data['filter_closed'] ) {
		$query.= " AND field_CLOSED_IS_ON='0'" ;
	}
	if( $filter_dates = json_decode($post_data['filter_dates'],true) ) {
		$query.= " AND (field_CLOSED_IS_ON='0' OR DATE(field_CLOSED_DATE)>='{$filter_dates['date_start']}')" ;
		$query.= " AND DATE(field_DATE_CREATE)<='{$filter_dates['date_end']}'" ;
	}
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$row_ticket = array() ;
		$row_ticket['ticket_filerecord_id'] = $arr['filerecord_id'];
		$row_ticket['id_soc'] = $arr['field_ID_SOC'];
		$row_ticket['incident_no'] = $arr['field_INCIDENT_NO'];
		$row_ticket['incident_code'] = $arr['field_INCIDENT_CODE'];
		$row_ticket['incident_cfg_obj'] = $arr['field_INCIDENT_CFG_JSON'] ? json_decode($arr['field_INCIDENT_CFG_JSON'],true) : array();
		$row_ticket['incident_txt'] = $arr['field_INCIDENT_TXT'];
		$row_ticket['editdata_obj'] = json_decode($arr['field_EDITDATA_JSON'],true);
		$row_ticket['inputdata_obj'] = json_decode($arr['field_INPUTDATA_JSON'],true);
		$row_ticket['date_create'] = $arr['field_DATE_CREATE'];
		$row_ticket['date_update'] = $arr['field_DATE_UPDATE'];
		$row_ticket['closed_is_on'] = !!$arr['field_CLOSED_IS_ON'];
		$row_ticket['closed_date'] = $arr['field_CLOSED_DATE'];
		$row_ticket['status_is_highlight'] = !!$arr['field_STATUS_IS_HIGHLIGHT'];
		
		$row_ticket['link_order_filerecord_ids'] = array() ;
		
		if( $post_data['filter_socCode'] && ($row_ticket['id_soc']!=$post_data['filter_socCode']) ) {
			continue ;
		}
		if( $post_data['filter_highlight'] && !$row_ticket['status_is_highlight'] ) {
			continue ;
		}
		if( $post_data['filter_closed'] && $row_ticket['closed_is_on'] ) {
			continue ;
		}
		if( $post_data['filter_spec_RAQ'] && !$row_ticket['incident_cfg_obj']['spec_is_RAQ'] ) {
			continue ;
		}
		
		$TAB[$arr['filerecord_id']] = $row_ticket ;
	}
	
	$query = "SELECT action1.filerecord_parent_id, action1.field_ACTION_USER FROM view_file_TICKET_ACTION action1
		JOIN (select min(filerecord_id) as action_filerecord_id FROM view_file_TICKET_ACTION GROUP BY filerecord_parent_id) actionmin
		ON actionmin.action_filerecord_id = action1.filerecord_id" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$ticket_filerecord_id = $arr[0] ;
		$action_user = $arr[1] ;
		if( !$TAB[$ticket_filerecord_id] ) {
			continue ;
		}
		$TAB[$ticket_filerecord_id] += array(
			'action1_user' => $action_user
		);
	}
	
	$query = "SELECT ct.field_FILE_TICKET_ID as ticket_filerecord_id, c.*, h.field_ID_HAT as id_hat
		FROM view_file_CDE_TICKET ct
		JOIN view_file_CDE c ON c.filerecord_id=ct.filerecord_parent_id
		LEFT OUTER JOIN view_file_HAT_CDE hc ON hc.field_FILE_CDE_ID=c.filerecord_id
		LEFT OUTER JOIN view_file_HAT h ON h.filerecord_id=hc.filerecord_parent_id
		WHERE 1" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$ticket_filerecord_id = $arr['ticket_filerecord_id'];
		if( !$TAB[$ticket_filerecord_id] ) {
			continue ;
		}
		if( !$TAB[$ticket_filerecord_id]['link_order_filerecord_ids'] ) {
			$TAB[$ticket_filerecord_id] += array(
				'link_order_filerecord_ids' => array(),
				'link_id_soc' => $arr['field_ID_SOC'],
				'link_id_dn' => $arr['field_ID_DN'],
				'link_atr_consignee' => $arr['field_ATR_CONSIGNEE'],
				'link_atr_priority' => $arr['field_ATR_PRIORITY'],
			);
		}
		if( $arr['id_hat'] == $arr['field_ID_DN'] ) {
			$TAB[$ticket_filerecord_id]['link_id_dn'] = $arr['field_ID_DN'];
		}
		$TAB[$ticket_filerecord_id]['link_order_filerecord_ids'][] = $arr['filerecord_id'];
	}
	
	return array('success'=>true,'data'=>array_values($TAB));
}

function specDbsTracy_ticket_getRecord( $post_data ) {
	global $_opDB ;
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	
	if( $post_data['status_reset'] ) {
		//paracrm_lib_data_updateRecord_file( 'TICKET', array('field_STATUS_IS_HIGHLIGHT'=>0), $p_ticketFilerecordId );
	}
	
	$query = "SELECT * FROM view_file_TICKET WHERE filerecord_id='{$p_ticketFilerecordId}'" ;
	$result = $_opDB->query($query) ;
	$arr = $_opDB->fetch_assoc($result);
	if( !$arr ) {
		return array('success'=>false);
	}
	
	$row_ticket = array() ;
	$row_ticket['ticket_filerecord_id'] = $arr['filerecord_id'];
	$row_ticket['id_soc'] = $arr['field_ID_SOC'];
	$row_ticket['incident_no'] = $arr['field_INCIDENT_NO'];
	$row_ticket['incident_code'] = $arr['field_INCIDENT_CODE'];
	$row_ticket['incident_cfg_obj'] = $arr['field_INCIDENT_CFG_JSON'] ? json_decode($arr['field_INCIDENT_CFG_JSON'],true) : array();
	$row_ticket['incident_txt'] = $arr['field_INCIDENT_TXT'];
	$row_ticket['inputdata_obj'] = json_decode($arr['field_INPUTDATA_JSON'],true);
	$row_ticket['date_create'] = $arr['field_DATE_CREATE'];
	$row_ticket['date_update'] = $arr['field_DATE_UPDATE'];
	$row_ticket['closed_is_on'] = !!$arr['field_CLOSED_IS_ON'];
	$row_ticket['closed_date'] = $arr['field_CLOSED_DATE'];
	$row_ticket['status_is_highlight'] = !!$arr['field_STATUS_IS_HIGHLIGHT'];
	
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	media_contextOpen( $_sdomain_id ) ;
	$row_ticket['actions'] = array() ;
	$query = "SELECT * FROM view_file_TICKET_ACTION WHERE filerecord_parent_id='{$p_ticketFilerecordId}'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$row_ticketaction = array(
			'ticketaction_filerecord_id' => $arr['filerecord_id'],
			'action_date' => $arr['field_ACTION_DATE'],
			'action_user' => $arr['field_ACTION_USER'],
			'body_txt' => $arr['field_BODY_TXT'],
			'body_html' => !!$arr['field_BODY_HTML'] ? media_bin_getBinary(media_bin_toolFile_getId('TICKET_ACTION',$arr['filerecord_id'])) : null,
			'form_is_discard' => !!$arr['field_INPUTDATA_IS_DISCARD'],
		);
		if( $tarr = json_decode($arr['field_EMAILFROM_JSON'],true) ) {
			$row_ticketaction += array(
				'spec_email_is_on' => true,
				'spec_email_is_inbox' => true,
				'spec_email_subject' => $tarr['subject'],
				'spec_email_date' => $tarr['date'],
				'spec_email_from' => $tarr['from'],
				'spec_email_to' => $tarr['to'],
				'spec_email_cc' => $tarr['cc']
			);
		} elseif( $tarr = json_decode($arr['field_EMAILTO_JSON'],true) ) {
			$row_ticketaction += array(
				'spec_email_is_on' => true,
				'spec_email_is_outbox' => true,
				'spec_email_subject' => $tarr['subject'],
				'spec_email_date' => $tarr['date'],
				'spec_email_from' => $tarr['from'],
				'spec_email_to' => $tarr['to'],
				'spec_email_cc' => $tarr['cc']
			);
		}
		$row_ticket['actions'][] = $row_ticketaction ;
	}
	media_contextClose() ;
	
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	media_contextOpen( $_sdomain_id ) ;
	$query = "SELECT * FROM view_file_TICKET_ATTACH WHERE filerecord_parent_id='{$p_ticketFilerecordId}'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$row = array(
			'ticketattach_filerecord_id' => $arr['filerecord_id'],
			'attach_filename' => $arr['field_ATTACH_FILENAME'],
			'attach_date' => $arr['field_ATTACH_DATE'],
			'ticket_is_header' => $arr['field_TICKET_IS_HEADER'],
		);
		$ticketaction_filerecord_id = $arr['field_TICKETACTION_ID'];
		
		foreach( $row_ticket['actions'] as &$row_ticketaction ) {
			if( $ticketaction_filerecord_id == $row_ticketaction['ticketaction_filerecord_id'] ) {
				if( !$row_ticketaction['attachments'] ) {
					$row_ticketaction['attachments'] = array() ;
				}
				$row_ticketaction['attachments'][] = $row ;
			}
		}
		unset($row_ticketaction) ;
	}
	media_contextClose() ;
	
	
	$row_ticket['links'] = array() ;
	$query = "SELECT * FROM view_file_CDE_TICKET WHERE field_FILE_TICKET_ID='{$p_ticketFilerecordId}'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
		$row_ticket['links'][] = array(
			'link_type' => 'order',
			'link_filerecord_id' => $arr['filerecord_parent_id'],
		);
	}
	
	return array('success'=>true, 'data'=>$row_ticket) ;
}

function specDbsTracy_ticket_saveHeader( $post_data ) {
	global $_opDB ;
	
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	$p_ticketIsNew = $post_data['ticket_is_new'] ;
	
	$p_formData = json_decode($post_data['data'],true) ;
	
	if( $p_ticketIsNew ) {
		$p_formData['id_soc'] = NULL ;
		foreach( $p_formData['links'] as $row_ticketlink ) {
			switch( $row_ticketlink['link_type'] ) {
				case 'order' :
					$ttmp = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($row_ticketlink['link_filerecord_id'])))) ;
					$row_order = $ttmp['data'][0] ;
					foreach( $row_order['tickets'] as $row_orderticket ) {
						if( $row_orderticket['closed_is_on'] ) {
							continue ;
						}
						if( $row_orderticket['incident_code'] == $p_formData['incident_code'] ) {
							return array('success'=>false, 'error'=>'Duplicate incident code');
						}
					}
					$p_formData['id_soc'] = $row_order['id_soc'];
					break ;
			}
		}
	}
	
	$row_ticket = NULL ;
	if( !$p_ticketIsNew ) {
		//echo "new" ;
		$json = specDbsTracy_ticket_getRecord(array('ticket_filerecord_id'=>$p_ticketFilerecordId)) ;
		$row_ticket = $json['data'];
		if( !$row_ticket ) {
			return array('success'=>false);
		}
		$p_formData['id_soc'] = $row_ticket['id_soc'];
	}
	
	$fn_getFormCfg = function($incidentCfgObj,$id_soc) {
		if( isset($incidentCfgObj['flow_formcfg_obj'][$id_soc]) ) {
			return $incidentCfgObj['flow_formcfg_obj'][$id_soc];
		}
		if( is_array($incidentCfgObj['flow_formcfg_obj']) ) {
			return $incidentCfgObj['flow_formcfg_obj'];
		}
		return array() ;
	};
	$fn_getPropActionTxt = function($p_formData) use ($fn_getFormCfg) {
		$link_txt = NULL ;
		foreach( $p_formData['links'] as $row_ticketlink ) {
			switch( $row_ticketlink['link_type'] ) {
				case 'order' :
					$ttmp = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($row_ticketlink['link_filerecord_id'])))) ;
					$row_order = $ttmp['data'][0] ;
					$link_txt = $row_order['id_soc'].'/'.$row_order['id_dn'] ;
					break 2 ;
				default :
					break ;
			}
		}
		$txt = array() ;
		$txt[] = "// Incident {$p_formData['incident_no']} //" ;
		$txt[] = '' ;
		$txt[] = 'Link (order) : '.$link_txt;
		$txt[] = '' ;
		$txt[] = 'Incident code : '.$p_formData['incident_code'];
		$txt[] = 'Comment : '.$p_formData['incident_txt'];
		$txt[] = '' ;
		foreach( $fn_getFormCfg($p_formData['incident_cfg_obj'],$p_formData['id_soc']) as $form_row ) {
			$txt[] = $form_row['label'].' : '.$p_formData['inputdata_obj'][$form_row['name']];
		}
		$txt = implode("\n",$txt)."\n" ;
		return $txt ;
	};
	
	if( $p_formData['editdata_obj'] ) {
		// special case, save editdata_obj only
		if( $row_ticket ) {
			paracrm_lib_data_updateRecord_file( 'TICKET', array('field_EDITDATA_JSON'=>json_encode($p_formData['editdata_obj'])), $p_ticketFilerecordId );
			return array('success'=>true) ;
		}
		return array('success'=>false) ;
	}
	
	if( $row_ticket ) {
		$is_diff = false ;
		//compute diffs
		if( $p_formData['incident_code']!=$row_ticket['incident_code'] ) {
			if( !$p_formData['incident_cfg_obj'] ) {
				return array('success'=>false) ;
			}
			$is_diff = true ;
			$row_ticket['incident_cfg_obj'] = $p_formData['incident_cfg_obj'] ;
		}
		if( !$row_ticket['incident_cfg_obj']['flow_formcfg_obj'] ) {
			$row_ticket['incident_cfg_obj']['flow_formcfg_obj'] = array() ;
		}
		if( $row_ticket['incident_txt'] != $p_formData['incident_txt'] ) {
			$is_diff = true ;
		}
		foreach( $fn_getFormCfg($row_ticket['incident_cfg_obj'],$row_ticket['id_soc']) as $form_row ) {
			if( $row_ticket['inputdata_obj'][$form_row['name']] != $p_formData['inputdata_obj'][$form_row['name']] ) {
				$is_diff = true ;
			}
		}
	} else {
		// new
		$is_diff = true ;
	}
	if( $row_ticket && !$is_diff ) {
		return array('success'=>false, 'error'=>'No changes');
	}
	
	$arr_ins = array() ;
	if( !$row_ticket ) {
		if( !$p_formData['id_soc'] ) {
			return array('success'=>false);
		}
		$arr_ins['field_ID_SOC'] = $p_formData['id_soc'];
	}
	if( $is_diff ) {
		$arr_ins['field_INCIDENT_CODE'] = $p_formData['incident_code'] ;
		if( $p_formData['incident_cfg_obj'] ) {
			$arr_ins['field_INCIDENT_CFG_JSON'] = json_encode($p_formData['incident_cfg_obj']) ;
		}
		$arr_ins['field_INCIDENT_TXT'] = $p_formData['incident_txt'] ;
		$arr_ins['field_INPUTDATA_JSON'] = json_encode($p_formData['inputdata_obj']);
		if( !$row_ticket ) {
			$arr_ins['field_DATE_CREATE'] = date('Y-m-d H:i:s');
		}
		$arr_ins['field_DATE_UPDATE'] = date('Y-m-d H:i:s');
	}
	if( !$row_ticket ) {
		$ticket_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET', 0, $arr_ins );
		$p_formData['incident_no'] = 'INC-T-'.str_pad($ticket_filerecord_id, 6, "0", STR_PAD_LEFT) ;
		paracrm_lib_data_updateRecord_file( 'TICKET', array('field_INCIDENT_NO'=>$p_formData['incident_no']), $ticket_filerecord_id );
	} else {
		$ticket_filerecord_id = $row_ticket['ticket_filerecord_id'];
		paracrm_lib_data_updateRecord_file( 'TICKET', $arr_ins, $ticket_filerecord_id );
		$p_formData['incident_no'] = $row_ticket['incident_no'];
	}
	
	
	if( !$row_ticket ) {
		// new >> store links
		foreach( $p_formData['links'] as $row_ticketlink ) {
			switch( $row_ticketlink['link_type'] ) {
				case 'order' :
					$arr_ins = array() ;
					$arr_ins['field_FILE_TICKET_ID'] = $ticket_filerecord_id;
					paracrm_lib_data_insertRecord_file( 'CDE_TICKET', $row_ticketlink['link_filerecord_id'], $arr_ins );
					break ;
			}
		}
	}
	
	
	if( $is_diff ) {
		// Hack ? restockage cfg pour génération
		if( $row_ticket && !$p_formData['links'] ) {
			$p_formData['links'] = $row_ticket['links'];
		}
		if( $row_ticket && !$p_formData['incident_cfg_obj'] ) {
			$p_formData['incident_cfg_obj'] = $row_ticket['incident_cfg_obj'];
		}
		
		// store diff action
		$arr_ins = array() ;
		$arr_ins['field_ACTION_DATE'] = date('Y-m-d H:i:s') ;
		$arr_ins['field_ACTION_USER'] = specDbsTracy_util_getLogUser() ;
		$arr_ins['field_BODY_TXT'] = $fn_getPropActionTxt($p_formData);
		$arr_ins['field_INPUTDATA_JSON'] = json_encode($p_formData['inputdata_obj']);
		$ticketaction_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ACTION', $ticket_filerecord_id, $arr_ins );
		
		$query = "UPDATE view_file_TICKET_ACTION SET field_INPUTDATA_IS_DISCARD='1'
				WHERE filerecord_parent_id='{$ticket_filerecord_id}' AND filerecord_id<>'{$ticketaction_filerecord_id}'" ;
		$_opDB->query($query);
		
		$print_tpl = null;
		if( is_array($p_formData['incident_cfg_obj']['flow_print_obj']) && isset($p_formData['incident_cfg_obj']['flow_print_obj'][$p_formData['id_soc']]) ) {
			$print_tpl = $p_formData['incident_cfg_obj']['flow_print_obj'][$p_formData['id_soc']] ;
		}
		$pdf_base64 = null ;
		switch( $print_tpl ) {
			case 'TPL_LITIGE' :
				$json = specDbsTracy_ticket_printTplLitige( array('ticket_filerecord_id'=>$ticket_filerecord_id) ) ;
				$pdf_base64 = $json['success'] ? $json['pdf_base64'] : null;
				break ;
		}
		
		if( $pdf_base64 ) {
			$query = "UPDATE view_file_TICKET_ATTACH SET field_TICKET_IS_HEADER='0' WHERE filerecord_parent_id='{$ticket_filerecord_id}'" ;
			$_opDB->query($query) ;
			
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			media_contextOpen( $_sdomain_id ) ;
			$arr_ins = array() ;
			$arr_ins['field_ATTACH_FILENAME'] = 'Fiche Litige '.$p_formData['incident_no'].'.pdf' ;
			$arr_ins['field_ATTACH_DATE'] = date('Y-m-d H:i:s');
			$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id;
			$arr_ins['field_TICKET_IS_HEADER'] = 1 ;
			$ticketattach_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ATTACH', $ticket_filerecord_id, $arr_ins );
			if( $ticketattach_filerecord_id ) {
				$binary_pdf = base64_decode($pdf_base64) ;
				$tmp_media_id = media_bin_processBuffer($binary_pdf) ;
				media_bin_move($tmp_media_id,media_bin_toolFile_getId('TICKET_ATTACH',$ticketattach_filerecord_id)) ;
			}
			media_contextClose() ;
		}
		
		if( $attach_ids = $p_formData['attach_ids'] ) {
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			
			foreach( $attach_ids as $attach_id ) {
				$json = specDbsTracy_attachments_mediaGetBinary( array('media_id'=>$attach_id) ) ;
				if( !$json['success'] ) {
					continue ;
				}
				
				$arr_ins = array() ;
				$arr_ins['field_ATTACH_FILENAME'] = $json['bin_filename'] ;
				$arr_ins['field_ATTACH_DATE'] = date('Y-m-d H:i:s');
				$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id;
				$ticketattach_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ATTACH', $ticket_filerecord_id, $arr_ins );
				
				media_contextOpen( $_sdomain_id ) ;
				$tmp_media_id = media_bin_processBuffer( base64_decode($json['bin_base64']) ) ;
				media_bin_move($tmp_media_id,media_bin_toolFile_getId('TICKET_ATTACH',$ticketattach_filerecord_id)) ;
				media_contextClose();
			}
		}
	}
	
	try {
		specDbsTracy_ticket_lib_syncEzeer($ticket_filerecord_id) ;
	} catch( Exception $e ) {
		return array('success'=>false,'error'=>$e->getMessage());
	}
	return array('success'=>true, 'ticket_filerecord_id'=>$ticket_filerecord_id);
}

function specDbsTracy_ticket_attachDownloadB64( $post_data ) {
	$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
	$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
	
	media_contextOpen( $_sdomain_id ) ;
	if( $post_data['media_id'] ) {
		$media_id = $post_data['media_id'] ;
	} elseif( $post_data['ticketattach_filerecord_id'] ) {
		$media_id = media_bin_toolFile_getId('TICKET_ATTACH',$post_data['ticketattach_filerecord_id']) ;
	}
	$bin = media_bin_getBinary($media_id) ;
	$mimetype = media_bin_getMimeType($media_id) ;
	media_contextClose() ;
	
	if( $post_data['page_idx'] > 0 ) {
		if( $mimetype!='application/pdf' ) {
			return array('success'=>false) ;
		}
		
		media_contextOpen( $_sdomain_id ) ;
		$tmpfilename = tempnam( sys_get_temp_dir(), "FOO").'.pdf' ;
		file_put_contents($tmpfilename,$bin) ;
		$tmp_media_id = media_pdf_processUploaded( $tmpfilename ) ;
		$jpg_binary = media_pdf_getPageBinary($tmp_media_id,$post_data['page_idx']) ;
		media_pdf_delete($tmp_media_id) ;
		media_contextClose() ;
		return array('success'=>true, 'bin_base64'=>base64_encode($jpg_binary)) ;
	}
	
	return array('success'=>true, 'bin_base64'=>base64_encode($bin), 'bin_mimetype'=>$mimetype) ;
}

function specDbsTracy_ticket_pushAction($post_data) {
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	
	paracrm_lib_data_updateRecord_file( 'TICKET', array('field_STATUS_IS_HIGHLIGHT'=>0), $p_ticketFilerecordId );
	
	$has_action = FALSE ;
	if( $post_data['body_txt'] ) {
		$has_action = TRUE ;
	}
	if( $_FILES[$mkey_upload] && $_FILES[$mkey_upload]['size'] > 0 ) {
		$has_action = TRUE ;
	}
	if( json_decode($post_data['attach_ids'],true) ) {
		$has_action = TRUE ;
	}
	
	$mkey_upload = 'attach_file';
	if( $has_action ) {
		$arr_ins = array() ;
		$arr_ins['field_ACTION_DATE'] = date('Y-m-d H:i:s');
		$arr_ins['field_ACTION_USER'] = specDbsTracy_util_getLogUser() ;
		$arr_ins['field_BODY_TXT'] = $post_data['body_txt'];
		$ticketaction_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ACTION', $p_ticketFilerecordId, $arr_ins );
	}
	if( $_FILES[$mkey_upload] && $_FILES[$mkey_upload]['size'] > 0 ) {
		$arr_ins = array() ;
		$arr_ins['field_ATTACH_FILENAME'] = $_FILES[$mkey_upload]['name'] ;
		$arr_ins['field_ATTACH_DATE'] = date('Y-m-d H:i:s');
		$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id;
		$ticketattach_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ATTACH', $p_ticketFilerecordId, $arr_ins );
		
		$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
		$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
		
		media_contextOpen( $_sdomain_id ) ;
		$tmp_media_id = media_bin_processUploaded( $_FILES[$mkey_upload]['tmp_name'], $_FILES[$mkey_upload]['name'] ) ;
		media_bin_move($tmp_media_id,media_bin_toolFile_getId('TICKET_ATTACH',$ticketattach_filerecord_id)) ;
		media_contextClose();
	}
	if( $attach_ids = json_decode($post_data['attach_ids'],true) ) {
		$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
		$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
		
		foreach( $attach_ids as $attach_id ) {
			$json = specDbsTracy_attachments_mediaGetBinary( array('media_id'=>$attach_id) ) ;
			if( !$json['success'] ) {
				continue ;
			}
			
			$arr_ins = array() ;
			$arr_ins['field_ATTACH_FILENAME'] = $json['bin_filename'] ;
			$arr_ins['field_ATTACH_DATE'] = date('Y-m-d H:i:s');
			$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id;
			$ticketattach_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ATTACH', $p_ticketFilerecordId, $arr_ins );
			
			media_contextOpen( $_sdomain_id ) ;
			$tmp_media_id = media_bin_processBuffer( base64_decode($json['bin_base64']) ) ;
			media_bin_move($tmp_media_id,media_bin_toolFile_getId('TICKET_ATTACH',$ticketattach_filerecord_id)) ;
			media_contextClose();
		}
	}
	
	$arr_ins = array() ;
	$arr_ins['field_DATE_UPDATE'] = date('Y-m-d H:i:s');
	if( $post_data['next_?']=='close' ) {
		$arr_ins['field_CLOSED_IS_ON'] = 1;
		$arr_ins['field_CLOSED_DATE'] = date('Y-m-d H:i:s');
	}
	paracrm_lib_data_updateRecord_file( 'TICKET', $arr_ins, $p_ticketFilerecordId );
	
	try {
		specDbsTracy_ticket_lib_syncEzeer($p_ticketFilerecordId) ;
	} catch( Exception $e ) {
		return array('success'=>false,'error'=>$e->getMessage());
	}
	return array('success'=>true);
}
















function specDbsTracy_ticket_printTplLitige( $post_data ) {
	global $_opDB ;
	
	$p_ticketFilerecordId = $post_data['ticket_filerecord_id'] ;
	
	$json = specDbsTracy_ticket_getRecord(array('ticket_filerecord_id'=>$p_ticketFilerecordId)) ;
	$row_ticket = $json['data'];
	$arrRows_order = NULL ;
	foreach( $row_ticket['links'] as $row_ticketlink ) {
		switch( $row_ticketlink['link_type'] ) {
			case 'order' :
				$ttmp = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($row_ticketlink['link_filerecord_id'])))) ;
				$arrRows_order[] = $ttmp['data'][0] ;
				break ;
			default :
				break ;
		}
	}
	if( !$arrRows_order ) {
		return array('success'=>false) ;
	}
	$row_order = reset($arrRows_order) ;
	$val_idDn = $row_order['id_dn'] ;
	$val_groupage = 'Non' ;
	if( count($arrRows_order) > 1 ) {
		foreach( $arrRows_order as $iter_order ) {
			if( $iter_order['calc_hat_txt'] == $iter_order['id_dn'] ) {
				$val_idDn = $iter_order['id_dn'] ;
				$val_groupage = 'Oui' ;
			}
		}
	}
	global $_opDB ;
	
	$dwr_db_name = 'op5_dbs_prod_dwr' ;
	$val_flux = $val_typeliv = $val_transtit = '' ;
	switch( $row_ticket['id_soc'] ) {
		case 'ACL' :
			$query = "SELECT FLUX FROM {$dwr_db_name}.view_table_SNA_WM_EXPE_PERF_OTD WHERE LIVRAISON='{$row_order['id_dn']}'" ;
			$val_flux = $_opDB->query_uniqueValue($query) ;
			$query = "SELECT TYPE_LIVRAISON FROM {$dwr_db_name}.view_table_SNA_WM_EXPE_PERF_OTD WHERE LIVRAISON='{$row_order['id_dn']}'" ;
			$val_typeliv = $_opDB->query_uniqueValue($query) ;
			$query = "SELECT TYPE_TRSPT_INIT FROM {$dwr_db_name}.view_table_SNA_WM_EXPE_PERF_OTD WHERE LIVRAISON='{$row_order['id_dn']}'" ;
			$val_transtit = $_opDB->query_uniqueValue($query) ;
			break ;
		case 'MBD' :
			$query = "SELECT FLUX FROM {$dwr_db_name}.view_table_SLS_WM_EXPE_PERF WHERE LIVRAISON='{$row_order['id_dn']}'" ;
			$val_flux = $_opDB->query_uniqueValue($query) ;
			$query = "SELECT TYPE_LIVRAISON FROM {$dwr_db_name}.view_table_SLS_WM_EXPE_PERF WHERE LIVRAISON='{$row_order['id_dn']}'" ;
			$val_typeliv = $_opDB->query_uniqueValue($query) ;
			$query = "SELECT NOM_TRANSIT FROM {$dwr_db_name}.view_table_SLS_WM_SAP_ZVL06F_MST WHERE LIVRAISON='{$row_order['id_dn']}'" ;
			$val_transtit = $_opDB->query_uniqueValue($query) ;
			break ;
		default :
			break ;
	}
	
	$query = "SELECT field_ACTION_USER FROM view_file_TICKET_ACTION WHERE filerecord_parent_id='{$p_ticketFilerecordId}' ORDER BY field_ACTION_DATE ASC LIMIT 1" ;
	$val_user = $_opDB->query_uniqueValue($query) ;
	
	$query = "SELECT treenode_key, entry_key, field_INCIDENT_DESC_SHORT FROM view_bible_CFG_INCIDENT_entry WHERE entry_key='{$row_ticket['incident_code']}'" ;
	$result = $_opDB->query($query);
	$arr = $_opDB->fetch_row($result) ;
	$val_i1 = $arr[0] ;
	$val_i2 = $arr[1] ;
	$val_i3 = $arr[2] ;
	$val_i4 = $row_ticket['incident_txt'];
	
	$query = "SELECT field_NAME FROM view_bible_LIST_CONSIGNEE_entry
				WHERE entry_key='{$row_order['atr_consignee']}'" ;
	$val_dest = $_opDB->query_uniqueValue($query) ;
	
	$query = "SELECT field_TEXT FROM view_bible_LIST_SERVICE_entry
				WHERE entry_key='{$row_order['atr_priority']}'" ;
	$val_crit = $_opDB->query_uniqueValue($query) ;
	
	
	$blocks = array();
	$blocks[] = array(
		'bgcolor' => null,
		'title' => null,
		'rows' => array(
			array('height'=>30, 'title'=>"N° de litige", 'value'=>$row_ticket['incident_no']),
			array('height'=>30, 'title'=>"Flux", 'value'=>$val_flux),
		)
	);
	$blocks[] = array(
		'bgcolor' => null,
		'title' => null,
		'rows' => array(
			array('height'=>30, 'title'=>"Date ouverture litige", 'value'=>date('d/m/Y H:i',strtotime($row_ticket['date_create']))),
			array('height'=>30, 'title'=>"Litige ouvert par", 'value'=>$val_user),
			array('height'=>30, 'title'=>"&nbsp;", 'value'=>"<font color=\"#555555\"><i>Transmis au fournisseur pour action immédiate</i></font>"),
		)
	);
	//$blocks[] = null ;
	$blocks[] = array(
		'bgcolor' => '#ddead5',
		'title' => 'Descriptif de non-conformité',
		'rows' => array(
			array('height'=>40, 'title'=>"Type de non-conformité", 'value'=>$val_i1),
			array('height'=>40, 'title'=>"Descriptif de l'anomalie", 'value'=>$val_i2.' '.$val_i3),
			array('height'=>40, 'title'=>"Commentaires", 'value'=>$val_i4),
		)
	);
	$blocks[] = array(
		'bgcolor' => '#fce4d6',
		'title' => 'Livraison',
		'rows' => array(
			array('height'=>40, 'title'=>"Destinataire", 'value'=>$val_dest),
			array('height'=>40, 'title'=>"Criticité", 'value'=>$val_crit),
			array('height'=>40, 'title'=>"Type de livraison", 'value'=>$val_typeliv),
			array('height'=>40, 'title'=>"Transitaire initial", 'value'=>$val_transtit),
			array('height'=>40, 'title'=>"N° de BL", 'value'=>$val_idDn),
			array('height'=>40, 'title'=>"Groupage", 'value'=>$val_groupage),
		)
	);
	$blocks[] = array(
		'bgcolor' => '#bbd5eb',
		'title' => 'Traçabilité',
		'rows' => array(
			array('height'=>40, 'title'=>"P/N", 'value'=>$row_ticket['inputdata_obj']['PN']),
			array('height'=>40, 'title'=>"SN", 'value'=>$row_ticket['inputdata_obj']['SN']),
		)
	);
	
	$app_root = $GLOBALS['app_root'] ;
	$resources_root=$app_root.'/resources' ;
	$templates_dir=$resources_root.'/server/templates' ;
	$_IMG['DBS_logo_full'] = file_get_contents($templates_dir.'/'.'DBS_logo_full.png') ;
	$_IMG['DBS_warning'] = file_get_contents($templates_dir.'/'.'DBS_warning.png') ;
		
		$buffer.= '<DIV></DIV>' ;
		$buffer.= "<table width='800' border='0' cellspacing='1' cellpadding='1'>" ;
		$buffer.= "<tr><td width='33%'>" ;
			$buffer.= '<div align="left">' ;
			$buffer.= "<img src=\"data:image/jpeg;base64,".base64_encode($_IMG['DBS_warning'])."\" />" ;
			$buffer.= '</div>' ;
		$buffer.= "</td><td width='33%'>" ;
			$buffer.= '<div align="center">' ;
			$buffer.= "<span class=\"huge\"><font color='red'><b>Avis de litige</b></font></span>" ;
			$buffer.= '</div>' ;
		$buffer.= "</td><td width='33%'>" ;
			$buffer.= '<div align="right">' ;
			$buffer.= "<img src=\"data:image/jpeg;base64,".base64_encode($_IMG['DBS_logo_full'])."\" />" ;
			$buffer.= '</div>' ;
		$buffer.= "</td></tr></table>" ;
		
		$buffer.= "<br/>" ;
		
		foreach( $blocks as $block ) {
			if( !$block ) {
				$buffer.= "<br/><br/>" ;
				continue ;
			}
			$bgcolor=$block['bgcolor'];
			if( $block['title'] ) {
				$buffer.= "<table width='800' border='0' cellspacing='0' cellpadding='5' bgcolor='{$bgcolor}'>" ;
					$buffer.= "<tr><td>" ;
						$buffer.= "<span class=\"mybig\"><b>{$block['title']}</b></span>" ;
					$buffer.= "</td></tr>" ;
				$buffer.= "</table>" ;
			}
			
			$border = $bgcolor ? '1' : '0' ;
			$buffer.= "<table width='800' border='$border' cellspacing='0' cellpadding='3'>" ;
			foreach( $block['rows'] as $row ) {
				$buffer.= "<tr>" ;
				$buffer.= "<td width='30%' height='{$row['height']}' bgcolor='{$bgcolor}'>".$row['title']."</td>" ;
				$buffer.= "<td width='70%' height='{$row['height']}'>".$row['value']."</td>" ;
				$buffer.= "</tr>" ;
			}
			$buffer.= "</table>" ;
			
			$buffer.= "<br/><br/>" ;
		}
		
		$buffer.= "<br/><br/>" ;
		
		$buffer.= "<table width='800' border='1' cellspacing='0' cellpadding='4'>" ;
			$buffer.= "<tr><td height='60' valign='top'>Emetteur :</td></tr>" ;
			$buffer.= "<tr><td height='100'  valign='top'>Commentaires :</td></tr>" ;
			$buffer.= "<tr><td>" ;
				$buffer.= "<table height='60' width='100%'><tr>" ;
					$buffer.= "<td width='50%' valign='top'>Date de clôture de l'action immédiate:</td>" ;
					$buffer.= "<td width='50%' valign='top'>Nom:</td>" ;
				$buffer.= "</tr></table>" ;
			$buffer.= "</td></tr>" ;
		$buffer.= "</table>" ;
		
		$buffer.= "<br/><br/>" ;
		
		$buffer.= "<hr/>" ;
		$buffer.= "<table width='800' border='0' cellspacing='0' cellpadding='4' bgcolor='#dddddd'>" ;
			$buffer.= "<tr><td height='40' valign='middle' align='center'><span class=\"mybig\">";
				$buffer.= "Document reference QUA/FOR/L/S20-SDLR/3-1-1 version 04 (10/2017)";
			$buffer.= "</span></td></tr>" ;
		$buffer.= "</table>" ;
	
	
	$app_root = $GLOBALS['app_root'] ;
	$resources_root=$app_root.'/resources' ;
	$templates_dir=$resources_root.'/server/templates' ;
	$inputFileName = $templates_dir.'/'.'DBS_TRACY_blank.html' ;
	$inputBinary = file_get_contents($inputFileName) ;
	
	
	//echo $inputFileName ;
	$doc = new DOMDocument();
	@$doc->loadHTML($inputBinary);
	
	$elements = $doc->getElementsByTagName('body');
	$i = $elements->length - 1;
	while ($i > -1) {
		$body_element = $elements->item($i); 
		$i--; 
		
		libxml_use_internal_errors(true);

		$tpl = new DOMDocument;
		$tpl->loadHtml('<?xml encoding="UTF-8">'.$buffer);
		libxml_use_internal_errors(false);

		
		$body_element->appendChild($doc->importNode($tpl->documentElement, TRUE)) ;
	}
	
	$html = $doc->saveHTML() ;
	return array('success'=>true, 'html'=>$html, 'pdf_base64'=>base64_encode(media_pdf_html2pdf($html,'A4')) ) ;
}







function specDbsTracy_ticket_lib_syncEzeer_byOrder( $order_filerecord_id ) {
	global $_opDB ;
	
	$query = "SELECT t.filerecord_id
				FROM view_file_CDE c
				JOIN view_file_CDE_TICKET ct ON ct.filerecord_parent_id=c.filerecord_id
				JOIN view_file_TICKET t ON t.filerecord_id=ct.field_FILE_TICKET_ID
				WHERE c.filerecord_id='{$order_filerecord_id}'" ;
	$result = $_opDB->query($query) ;
	$arr_ticketFilerecordIds = array() ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		$arr_ticketFilerecordIds[] = $arr[0];
	}
	
	foreach( $arr_ticketFilerecordIds as $ticket_filerecord_id ) {
		specDbsTracy_ticket_lib_syncEzeer($ticket_filerecord_id);
	}
}
function specDbsTracy_ticket_lib_syncEzeer($ticket_filerecord_id) {
	global $_opDB ;
	
	$fn_getIncidentCfgEzeer = function($incident_code) {
		$incident_cfg_obj = NULL ;
		$ttmp = specDbsTracy_cfg_getConfig() ;
		$json_cfg = $ttmp['data'] ;
		foreach( $json_cfg['cfg_incident'] as $iter_incident ) {
			if( $iter_incident['incident_code'] == $incident_code ) {
				$incident_cfg_obj = $iter_incident ;
				break ;
			}
		}
		if( $incident_cfg_obj ) {
			return $incident_cfg_obj['flow_ezeer_obj'] ;
		}
		return null;
	};
	
	// Safe stop if not FLOW_EZEER_JSON $.(id_soc)
	$json = specDbsTracy_ticket_getRecord(array('ticket_filerecord_id'=>$ticket_filerecord_id)) ;
	$row_ticket = $json['data'];
	$id_soc = $row_ticket['id_soc'];
	$cfg_ezeer_obj = $fn_getIncidentCfgEzeer($row_ticket['incident_code']);
	if( !$cfg_ezeer_obj || !$cfg_ezeer_obj[$id_soc] ) {
		return ;
	}
	
	
	$_ez_api_baseUrl = NULL ;
	if( TRUE ) {
		$query = "SELECT field_OUT_PARAMS FROM view_bible_CFG_EDI_entry WHERE entry_key='TICKET_EZEER'" ;
		$params = $_opDB->query_uniqueValue($query) ;
		foreach( explode(';',$params) as $keyval ) {
			$ttmp = explode('=',$keyval,2) ;
			$mkey = trim($ttmp[0]) ;
			$mval = trim($ttmp[1]) ;
			$arr_params[$mkey] = $mval ;
		}
		if( $arr_params['API_URL'] ) {
			$_ez_api_baseUrl = $arr_params['API_URL'] ;
		}
	}
	if( $GLOBALS['__OPTIMA_TEST'] ) {
		$_ez_api_baseUrl = NULL ;
		if( $GLOBALS['paracrm_self'] ) {
			$_ez_api_baseUrl = $GLOBALS['paracrm_self'].'/rest/ezeer/' ;
		}
	}
	if( !$_ez_api_baseUrl ) {
		throw new Exception("TRACY : missing Ezeer API");
	}
	
	
	$json = specDbsTracy_ticket_getRecord(array('ticket_filerecord_id'=>$ticket_filerecord_id)) ;
	$row_ticket = $json['data'];
	foreach( $row_ticket['links'] as $row_ticketlink ) {
		switch( $row_ticketlink['link_type'] ) {
			case 'order' :
				$ttmp = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($row_ticketlink['link_filerecord_id'])))) ;
				$row_order = $ttmp['data'][0] ;
				break 2 ;
			default :
				break ;
		}
	}
	
	$ezproxy_obj = NULL ;
	// IF no ticket >> create + first ACTION+feuille LITIGE
	$query = "SELECT field_EZPROXY_JSON FROM view_file_TICKET WHERE filerecord_id='{$ticket_filerecord_id}'" ;
	$ezproxy_obj = json_decode($_opDB->query_uniqueValue($query),true);
	if( !$ezproxy_obj ) {
		$ezproxy_obj = array() ;
	}
	if( !$ezproxy_obj['ezeer'] ){
		// Cfg Ezeer
		$id_soc = $row_ticket['id_soc'];
		$cfg_ezeer_obj = $fn_getIncidentCfgEzeer($row_ticket['incident_code']);
		if( !$cfg_ezeer_obj ) {
			return ;
		}
		$cfg_ezeerSoc_obj = $cfg_ezeer_obj[$id_soc] ;
		if( !$cfg_ezeerSoc_obj ) {
			return ;
		}
		
		// target people_group
		$targetEzeer_peopleGroup = $cfg_ezeerSoc_obj['people_group'] ;
		if( !$targetEzeer_peopleGroup ) {
			return ;
		}
		
		// create ticket
		$postData = array(
			'prop_title' => $row_order['id_dn'].' / '.$row_ticket['incident_code'],
			'prop_links' => array(
				array('link_cfgcode'=>'tracy','link_id'=>'cde:'.$row_order['order_filerecord_id'],'link_txt'=>$row_order['id_soc'].'/'.$row_order['id_dn'])
			),
			'prop_people' => array(
				array('people_type'=>'group','people_id'=>$targetEzeer_peopleGroup)
			),
		);
		//print_r($postData) ;
		$json_ezeer = specDbsTracy_lib_httpClient($_ez_api_baseUrl.'/post-ticket-new',$postData) ;
		if( $json_ezeer['ticket_filerecord_id'] ) {
			$ezproxy_obj['ezeer'] = array('ticket_filerecord_id'=>$json_ezeer['ticket_filerecord_id'],'sync_actions'=>array());
		} else {
			return ; //error
		}
	}
	
	// synchro POST actions sortantes
	foreach( $row_ticket['actions'] as $row_ticketaction ) {
		$ticketaction_filerecord_id = $row_ticketaction['ticketaction_filerecord_id'] ;
		foreach( $ezproxy_obj['ezeer']['sync_actions'] as $sync_action ) {
			if( $sync_action['tracy_ticketaction_filerecord_id'] == $ticketaction_filerecord_id ) {
				continue 2 ;
			}
		}
		
		// post ACTION !
		$postData = array(
			'action_user' => $row_ticketaction['action_user'],
			'action_date' => $row_ticketaction['action_date'],
			'body_txt' => $row_ticketaction['body_txt'],
		);
		if( $row_ticketaction['attachments'] ) {
			$postData['attachments'] = array() ;
			foreach( $row_ticketaction['attachments'] as $row_ticketattach ) {
				$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
				$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
				media_contextOpen( $_sdomain_id ) ;
				$postData['attachments'][] = array(
					'attach_filename' => $row_ticketattach['attach_filename'],
					'attach_base64' => base64_encode(media_bin_getBinary(media_bin_toolFile_getId('TICKET_ATTACH',$row_ticketattach['ticketattach_filerecord_id']))),
				);
				media_contextClose() ;
			}
		}
		//print_r($postData) ;
		$json_ezeer = specDbsTracy_lib_httpClient($_ez_api_baseUrl.'/post-ticket-action'.'/'.$ezproxy_obj['ezeer']['ticket_filerecord_id'],$postData) ;
		if( $json_ezeer['ticketaction_filerecord_id'] ) {
			$ezproxy_obj['ezeer']['sync_actions'][] = array(
				'tracy_ticketaction_filerecord_id'=>$ticketaction_filerecord_id,
				'ezeer_ticketaction_filerecord_id'=>$json_ezeer['ticketaction_filerecord_id'],
			);
		} else {
			return ; //error
		}
	}
	
	// synchro GT actions entrantes
	$row_ezeerTicket = specDbsTracy_lib_httpClient($_ez_api_baseUrl.'/get-ticket'.'/'.$ezproxy_obj['ezeer']['ticket_filerecord_id']) ;
	if( !$row_ezeerTicket ) {
		return ; //error
	}
	$fn_sortActions = function($r1,$r2) {
		return $r1['ticketaction_filerecord_id'] - $r2['ticketaction_filerecord_id'] ;
	};
	usort($row_ezeerTicket['actions'],$fn_sortActions) ;
	$map_ezeerActionId_row_ezeerTicketAction = array() ;
	foreach( $row_ezeerTicket['actions'] as $row_ezeerTicketAction ) {
		$ezeerActionId = $row_ezeerTicketAction['ticketaction_filerecord_id'] ;
		$map_ezeerActionId_row_ezeerTicketAction[$ezeerActionId] = $row_ezeerTicketAction ;
	}
	$hack_firstOutEmail = FALSE ;
	foreach( $row_ezeerTicket['actions'] as &$row_ezeerTicketAction ) {
		if( $row_ezeerTicketAction['spec_email_is_on'] ) {
			if( $row_ezeerTicketAction['spec_email_is_inbox'] ) {
				$row_ezeerTicketAction['_sync'] = false ;
			}
			if( $row_ezeerTicketAction['spec_email_is_outbox'] ) {
				if( $hack_firstOutEmail ) {
					$row_ezeerTicketAction['_sync'] = false ;
				} else {
					$row_ezeerTicketAction['_sync'] = true ;
					$hack_firstOutEmail = true ;
				}
			}
			continue ;
		}
		if( !$row_ezeerTicketAction['body_txt'] && !$row_ezeerTicketAction['body_html'] ) {
			//$row_ezeerTicketAction['_sync'] = false ;
			//continue ;
		}
		$row_ezeerTicketAction['_sync'] = $row_ezeerTicketAction['extlink_is_sync'] ;
		if( $row_ezeerTicketAction['extlink_is_sync'] && $row_ezeerTicketAction['extlink_sync_obj'] ) {
			if( $child_ids = $row_ezeerTicketAction['extlink_sync_obj']['child_ticketActionFilerecordIds'] ) {
				$row_ezeerTicketAction['_sync_childIds'] = $child_ids ;
			}
		}
		if( $row_ezeerTicketAction['extlink_is_sync'] ) {
			$row_ezeerTicketAction['_sync_notify'] = true ;
		}
	}
	unset($row_ezeerTicketAction);
	
	//print_r($row_ezeerTicket) ;
	
	$fn_importEzeerAction = function($row_ezeerTicketAction, $target_rowTicket) use ($_ez_api_baseUrl) {
		$target_ticketFilerecordId = $target_rowTicket['ticket_filerecord_id'];
		$arr_ins = array() ;
		$arr_ins['field_ACTION_USER'] = $row_ezeerTicketAction['action_user'] ;
		$arr_ins['field_ACTION_DATE'] = $row_ezeerTicketAction['action_date'] ;
		$arr_ins['field_BODY_HTML'] = $row_ezeerTicketAction['body_html'] ? true : false ;
		if( $row_ezeerTicketAction['spec_email_is_on'] ) {
			$v = array(
				'subject' => $row_ezeerTicketAction['spec_email_subject'],
				'date' => $row_ezeerTicketAction['spec_email_date'],
				'from' => $row_ezeerTicketAction['spec_email_from'],
				'to' => $row_ezeerTicketAction['spec_email_to'],
				'cc' => $row_ezeerTicketAction['spec_email_cc'],
			);
			if( $row_ezeerTicketAction['spec_email_is_inbox'] ) {
				$arr_ins['field_EMAILFROM_JSON'] = json_encode($v);
			}
			if( $row_ezeerTicketAction['spec_email_is_outbox'] ) {
				$arr_ins['field_EMAILTO_JSON'] = json_encode($v);
			}
		} else {
			$v = array(
				'subject' => $target_rowTicket['incident_no'],
				'date' => $row_ezeerTicketAction['action_date'],
				'from' => $row_ezeerTicketAction['action_user'],
				//'to' => 'tracy@dbs',
			);
			$arr_ins['field_EMAILFROM_JSON'] = json_encode($v);
		}
		$ticketaction_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ACTION', $target_ticketFilerecordId, $arr_ins );
		
		if( $row_ezeerTicketAction['body_html'] ) {
			$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
			$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
			media_contextOpen( $_sdomain_id ) ;
			$tmp_id = media_bin_processBuffer($row_ezeerTicketAction['body_html']) ;
			media_bin_move($tmp_id,media_bin_toolFile_getId('TICKET_ACTION',$ticketaction_filerecord_id)) ;
			media_contextClose();
		}
		
		if( $row_ezeerTicketAction['attachments'] ) {
			foreach( $row_ezeerTicketAction['attachments'] as $row_ezeerTicketActionAttach ) {
				if( $row_ezeerTicketActionAttach['status_is_cancel'] ) {
					continue ;
				}
				$attach_filerecord_id = $row_ezeerTicketActionAttach['attach_filerecord_id'] ;
				$row_ezeerAttach = specDbsTracy_lib_httpClient($_ez_api_baseUrl.'/get-attach'.'/'.$attach_filerecord_id) ;
				if( $row_ezeerAttach['bin_base64'] ) {
					$arr_ins = array() ;
					$arr_ins['field_ATTACH_FILENAME'] = $row_ezeerTicketActionAttach['attach_filename'] ;
					$arr_ins['field_ATTACH_DATE'] = $row_ezeerTicketActionAttach['attach_date'] ;
					$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id;
					$arr_ins['field_TICKET_IS_HEADER'] = 0 ;
					$ticketattach_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ATTACH', $target_ticketFilerecordId, $arr_ins );
					
					$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
					$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
					
					media_contextOpen( $_sdomain_id ) ;
					$tmp_media_id = media_bin_processBuffer( base64_decode($row_ezeerAttach['bin_base64']) ) ;
					media_bin_move($tmp_media_id,media_bin_toolFile_getId('TICKET_ATTACH',$ticketattach_filerecord_id)) ;
					media_contextClose();
				}
			}
		}
		
		return $ticketaction_filerecord_id ;
	};
	foreach( $row_ezeerTicket['actions'] as $row_ezeerTicketAction ) {
		$ezeer_ticketaction_filerecord_id = $row_ezeerTicketAction['ticketaction_filerecord_id'] ;
		foreach( $ezproxy_obj['ezeer']['sync_actions'] as $sync_action ) {
			if( $sync_action['ezeer_ticketaction_filerecord_id'] == $ezeer_ticketaction_filerecord_id ) {
				continue 2 ;
			}
		}
		if( !$row_ezeerTicketAction['_sync'] ) {
			$ezproxy_obj['ezeer']['sync_actions'][] = array(
				'tracy_ticketaction_filerecord_id'=>0,
				'ezeer_ticketaction_filerecord_id'=>$ezeer_ticketaction_filerecord_id,
			);
			continue ;
		}
		
		if( $row_ezeerTicketAction['_sync_childIds'] ) {
			foreach( $row_ezeerTicketAction['_sync_childIds'] as $ezeerActionId ) {
				$row_ezeerTicketActionChild = $map_ezeerActionId_row_ezeerTicketAction[$ezeerActionId] ;
				if( $row_ezeerTicketActionChild ) {
					$ticketaction_filerecord_id = $fn_importEzeerAction($row_ezeerTicketActionChild,$row_ticket);
					$ezproxy_obj['ezeer']['sync_actions'][] = array(
						'tracy_ticketaction_filerecord_id'=>$ticketaction_filerecord_id,
						'ezeer_ticketaction_filerecord_id'=>0,
					);
				}
			}
		}
		$ticketaction_filerecord_id = $fn_importEzeerAction($row_ezeerTicketAction,$row_ticket);
		$ezproxy_obj['ezeer']['sync_actions'][] = array(
			'tracy_ticketaction_filerecord_id'=>$ticketaction_filerecord_id,
			'ezeer_ticketaction_filerecord_id'=>$ezeer_ticketaction_filerecord_id,
		);
		
		if( $row_ezeerTicketAction['_sync_notify'] ) {
			$date_now = date('Y-m-d H:i:s');
			paracrm_lib_data_updateRecord_file( 'TICKET', array('field_DATE_UPDATE'=>$date_now,'field_STATUS_IS_HIGHLIGHT'=>1), $ticket_filerecord_id );
		}
	}
	
	//print_r($row_ezeerTicket) ;
	$id_soc = $row_ticket['id_soc'];
	$cfg_ezeer_obj = $fn_getIncidentCfgEzeer($row_ticket['incident_code']);
	if( !$cfg_ezeer_obj ) {
		return ;
	}
	$close_forward = FALSE ;
	$cfg_ezeerSoc_obj = $cfg_ezeer_obj[$id_soc] ;
	if( is_string($cfg_ezeerSoc_obj['close_forward']) ) {
		$forwardClose_stepCode = $cfg_ezeerSoc_obj['close_forward'] ;
		if( $row_order ) {
			foreach( $row_order['steps'] as $row_orderstep ) {
				if( ($row_orderstep['step_code'] == $forwardClose_stepCode) && !!$row_orderstep['status_is_ok'] ) {
					$close_forward = TRUE ;
					break ;
				}
			}
		}
	} elseif( !($cfg_ezeerSoc_obj['close_forward']===FALSE) ) {
		if( $row_ticket['closed_is_on'] ) {
			$close_forward = TRUE ;
		}
	}
	if( $close_forward ) {
		if( !$ezproxy_obj['ezeer']['closed_is_on'] ) {
			// TODO cleaner ?
			$post_obj = array();
			if( $cfg_ezeerSoc_obj['close_reason'] ) {
				$post_obj['close_reason'] = $cfg_ezeerSoc_obj['close_reason'];
			}
			$json_ezeer = specDbsTracy_lib_httpClient($_ez_api_baseUrl.'/post-ticket-close'.'/'.$ezproxy_obj['ezeer']['ticket_filerecord_id'],$post_obj) ;
			$ezproxy_obj['ezeer']['closed_is_on'] = TRUE ;
		}
	}
	
	
	
	$_opDB->update('view_file_TICKET',array('field_EZPROXY_JSON'=>json_encode($ezproxy_obj)),array('filerecord_id'=>$ticket_filerecord_id));
}

function specDbsTracy_ticket_lib_setWarning( $arr_links, $incident_code, $incident_txt=NULL ) {
	$new_arrLinks = array() ;
	foreach( $arr_links as $row_ticketlink ) {
		switch( $row_ticketlink['link_type'] ) {
			case 'order' :
				$ttmp = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($row_ticketlink['link_filerecord_id'])))) ;
				$row_order = $ttmp['data'][0] ;
				foreach( $row_order['tickets'] as $row_orderticket ) {
					if( $row_orderticket['closed_is_on'] ) {
						continue ;
					}
					if( $row_orderticket['incident_code'] == $p_formData['incident_code'] ) {
						continue 3 ;
					}
				}
				$new_arrLinks[] = $row_ticketlink;
				break ;
			default :
				break ;
		}
	}
	if( !$new_arrLinks ) {
		return ;
	}
	
	$incident_cfg_obj = NULL ;
	$ttmp = specDbsTracy_cfg_getConfig() ;
	$json_cfg = $ttmp['data'] ;
	foreach( $json_cfg['cfg_incident'] as $iter_incident ) {
		if( $iter_incident['incident_code'] == $incident_code ) {
			$incident_cfg_obj = $iter_incident ;
			break ;
		}
	}
	if( !$incident_cfg_obj ) {
		return ;
	}
	
	// forward post
	$forward_post = array(
		'ticket_is_new' => true,
		'data' => json_encode(array(
			'links' => $new_arrLinks,
			'incident_code' => $incident_code,
			'incident_cfg_obj' => $incident_cfg_obj,
			'incident_txt' => $incident_txt ?? $incident_cfg_obj['incident_desc_full'],
		)),
	);
	$json = specDbsTracy_ticket_saveHeader($forward_post) ;
	return ;
}

?>
