<?php

function specDbsTracy_reportList( $post_data ) {
	global $_opDB ;
	
	// delegate userId cfg
	$json_auth = specDbsTracy_cfg_getAuth( array() ) ;
	
	$TAB = array() ;
	$TAB[] = array('id'=>'RCL_VL02NPOD','text'=>'RCL_VL02NPOD') ;
	$TAB[] = array('id'=>'RCL_VL02NAWB','text'=>'RCL_VL02NAWB') ;
	if( is_array($json_auth['allowedQueries']) ) {
		$TAB = array() ;
	}
	
	$query = "SELECT qsql_id, qsql_name 
		FROM qsql JOIN input_query_src ON input_query_src.target_qsql_id = qsql.qsql_id
		ORDER BY qsql_name" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
		if( is_array($json_auth['allowedQueries']) && !in_array($arr[1],$json_auth['allowedQueries']) ) {
			continue ;
		}
		$TAB[] = array('id'=>'QSQL::'.$arr[0],'text'=>'QSQL / '.$arr[1]) ;
	}
	
	return array('success'=>true, 'data'=>$TAB) ;
}


function specDbsTracy_report( $post_data ) {
	$form_data = json_decode($post_data['data'],true) ;
	
	// Specs
	switch( $form_data['file_model'] ) {
		case 'RCL_VL02NPOD' :
			$csv_buffer = specDbsTracy_report_RCL_VL02NPOD_tmp($form_data) ;
			break ;
		case 'RCL_VL02NAWB' :
			$csv_buffer = specDbsTracy_report_RCL_VL02NAWB_tmp($form_data) ;
			break ;
		default :
			if( strpos($form_data['file_model'],'QSQL::')===0 ) {
				$ttmp = explode('::',$form_data['file_model']) ;
				$qsql_id = $ttmp[1] ;
				specDbsTracy_report_qsql($qsql_id,$form_data) ;
				die() ;
			}
			return array('success'=>false);
	}
	
	$filename = 'OP5report_TRACY_.'.$form_data['file_model'].'_'.time().'.'.'csv' ;
	if( $xml_filename ) {
		$filename = $xml_filename ;
	}
	header("Content-Type: application/force-download; name=\"$filename\""); 
	header("Content-Disposition: attachment; filename=\"$filename\""); 
	echo $csv_buffer ;
	die() ;
}
function specDbsTracy_report_qsql( $qsql_id, $form_data ) {
	global $_opDB ;
	
	$query = "SELECT * FROM qsql WHERE qsql_id='{$qsql_id}'" ;
	$result = $_opDB->query($query) ;
	if( $_opDB->num_rows($result) != 1 ) {
		return array('success'=>false) ;
	}
	$arr = $_opDB->fetch_assoc($result) ;
	$qsql_name = preg_replace("/[^a-zA-Z0-9]/", "", $arr['qsql_name']) ;
	$sql_querystring = $arr['sql_querystring'] ;
	
	$TAB = paracrm_queries_qsql_lib_exec($sql_querystring,$is_rw=FALSE,$auth_bypass=TRUE,$vars=$form_data) ;
	
	$objPHPExcel = paracrm_queries_xls_build( $TAB, NULL ) ;
	if( !$objPHPExcel ) {
		die() ;
	}
	
	$tmpfilename = tempnam( sys_get_temp_dir(), "FOO");
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
	$objWriter->save($tmpfilename);
	$objPHPExcel->disconnectWorksheets();
	unset($objPHPExcel) ;
	
	$filename = 'OP5report_TRACY_.'.$qsql_name.'_'.time().'.'.'xlsx' ;
	header("Content-Type: application/force-download; name=\"$filename\""); 
	header("Content-Disposition: attachment; filename=\"$filename\""); 
	readfile($tmpfilename) ;
	unlink($tmpfilename) ;
	die() ;
}


function specDbsTracy_report_RCL_VL02NPOD_tmp( $form_data, $use_log=FALSE ) {
	global $_opDB ;
	$date_now = date('Y-m-d H:i:s') ;
	
	$query = "SELECT c.filerecord_id, c.field_ID_DN, cs90.field_DATE_ACTUAL
					FROM view_file_CDE c
					JOIN view_file_CDE_STEP cs90 
					ON cs90.filerecord_parent_id=c.filerecord_id AND cs90.field_STEP_CODE='90_POD'
					WHERE c.field_ID_SOC='ACL' AND cs90.field_STATUS_IS_OK='1'
					AND cs90.field_DATE_ACTUAL BETWEEN '{$form_data['date_start']}' AND '{$form_data['date_end']}'
					ORDER BY c.filerecord_id DESC" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) !=  FALSE ) {
		$order_filerecord_id = $arr[0] ;
		$id_dn = $arr[1] ;
		$date_actual = $arr[2] ;
	
		if( $use_log ) {
			$query = "SELECT count(*) FROM view_file_Z_ACL180612_LOG WHERE field_QUERY_CODE='POD' AND field_LINK_FILERECORD_ID='{$order_filerecord_id}'" ;
			if( $_opDB->query_uniqueValue($query) > 0 ) {
				continue ;
			}
			$arr_ins = array() ;
			$arr_ins['field_QUERY_CODE'] = 'POD' ;
			$arr_ins['field_LINK_FILERECORD_ID'] = $order_filerecord_id ;
			$arr_ins['field_EXPORT_DATE'] = $date_now ;
			paracrm_lib_data_insertRecord_file( 'Z_ACL180612_LOG' , 0 , $arr_ins ) ;
		}
		
		$csv_buffer.= $id_dn.';'.date('d.m.Y',strtotime($date_actual)).';'.date('H:i',strtotime($date_actual))."\r\n" ;
	}
	return $csv_buffer ;
}
function specDbsTracy_report_RCL_VL02NAWB_tmp( $form_data, $use_log=FALSE ) {
	global $_opDB ;
	$date_now = date('Y-m-d H:i:s') ;

	$csv_buffer = '' ;
	$query = "SELECT c.field_ID_DN, t.field_FLIGHT_AWB, c.filerecord_id, t.filerecord_id
				FROM view_file_CDE c, view_file_TRSPT_CDE tc, view_file_TRSPT t
				WHERE c.filerecord_id = tc.field_FILE_CDE_ID AND tc.field_LINK_IS_CANCEL='0'
				AND tc.filerecord_parent_id = t.filerecord_id
				AND c.field_ID_SOC='ACL' AND t.field_FLIGHT_AWB<>'' AND DATE(t.field_DATE_CREATE) BETWEEN '{$form_data['date_start']}' AND '{$form_data['date_end']}'" ;
	$result = $_opDB->query($query) ;
	while( ($arr = $_opDB->fetch_row($result)) !=  FALSE ) {
		$order_filerecord_id = $arr[2] ;
		$trspt_filerecord_id = $arr[3] ;
		
		if( $use_log ) {
			$query = "SELECT count(*) FROM view_file_Z_ACL180612_LOG WHERE field_QUERY_CODE='AWB' AND field_LINK_FILERECORD_ID='{$order_filerecord_id}'" ;
			if( $_opDB->query_uniqueValue($query) > 0 ) {
				continue ;
			}
			$arr_ins = array() ;
			$arr_ins['field_QUERY_CODE'] = 'AWB' ;
			$arr_ins['field_LINK_FILERECORD_ID'] = $order_filerecord_id ;
			$arr_ins['field_EXPORT_DATE'] = $date_now ;
			paracrm_lib_data_insertRecord_file( 'Z_ACL180612_LOG' , 0 , $arr_ins ) ;
			
			$arr_ins = array() ;
			$arr_ins['field_SWORD_EDI_3_SENT'] = 1 ;
			$arr_ins['field_SWORD_EDI_3_SENTAWB'] = $arr[1] ;
			$arr_ins['field_SWORD_EDI_3_SENTDATE'] = date('Y-m-d H:i:s') ;
			paracrm_lib_data_updateRecord_file( 'TRSPT' , $arr_ins , $trspt_filerecord_id ) ;
		}
		
		$csv_buffer.= $arr[0].';'.$arr[1]."\r\n" ;
	}
	
	return $csv_buffer ;
}







function specDbsTracy_xls_create($post_data) {
	$json_cfg = $ttmp['data'] ;

	$data = json_decode($post_data['data'],true) ;
	$columns = json_decode($post_data['columns'],true) ;
	
	
	
	
	if( !class_exists('PHPExcel') )
		return FALSE ;
	
	
	// ******* Load du template ********
	$ttmp = paracrm_queries_gridTemplate( array('_subaction'=>'load') ) ;
	$template_cfg = $ttmp['data_templatecfg'] ;
	if( !$template_cfg || !$template_cfg['template_is_on'] )
		unset($template_cfg) ;
	if( $template_cfg ) {
		$style_header = array(                  
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb'=>substr($template_cfg['colorhex_columns'],1,6)),
			)
		);
		$style_row = array(                  
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb'=>substr($template_cfg['colorhex_row'],1,6)),
			)
		);
		$style_rowalt = array(                  
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb'=>substr($template_cfg['colorhex_row_alt'],1,6)),
			)
		);

		$style_group = array(                  
			'fill' => array(
				'type' => PHPExcel_Style_Fill::FILL_SOLID,
				'color' => array('rgb'=>substr('#00D563',1,6)),
			)
		);
	}
	// ***********************************
	
	
	$objPHPExcel = new PHPExcel() ;
	$objPHPExcel->getDefaultStyle()->getFont()->setName('Arial');
	$objPHPExcel->getDefaultStyle()->getFont()->setSize( 10 );

	$objPHPExcel->setActiveSheetIndex(0);
	$obj_sheet = $objPHPExcel->getActiveSheet() ;
	
	$row_data_min = 2 ;
	$row_data_max = count($data) + $group_count + 1 ;
	
	$row = 1 ;
	$cell_min = $cell = 'A' ;
	
	foreach( $columns as $col ) {
		$col['text'] = strip_tags($col['text']);
		$obj_sheet->SetCellValue("{$cell}{$row}", $col['text']);
		$obj_sheet->getColumnDimension($cell)->setWidth(20);
		$obj_sheet->getStyle("{$cell}{$row}")->getFont()->setBold(TRUE);
		if( $template_cfg ) {
			$phpexcelalign = "" ;
			switch( $template_cfg['data_align'] ) {
				case 'left' : $phpexcelalign=PHPExcel_Style_Alignment::HORIZONTAL_LEFT ; break ;
				case 'center' : $phpexcelalign=PHPExcel_Style_Alignment::HORIZONTAL_CENTER ; break ;
				case 'right' : $phpexcelalign=PHPExcel_Style_Alignment::HORIZONTAL_RIGHT ; break ;
			}
			$obj_sheet->getStyle("{$cell}1:{$cell}{$row_data_max}")->getAlignment()->setHorizontal($phpexcelalign);
		}
		$cell_max = $cell ;
		$cell++ ;
	}
	if( $style_header ) {
		$obj_sheet->getStyle("{$cell_min}{$row}:{$cell_max}{$row}")->applyFromArray( $style_header );
	}

	foreach( $data as $record ) {
		if( $group_dataIndex && $group_currentValue != $record[$group_dataIndex] ) {
			$row++ ;
			$cell = 'A' ;
			
			$group_currentValue = $record[$group_dataIndex] ;
			$obj_sheet->SetCellValue("{$cell}{$row}", $group_currentValue );
			$obj_sheet->getStyle("{$cell_min}{$row}:{$cell_max}{$row}")->applyFromArray( $style_group );
		}
		
		$row++ ;
		$cell = 'A' ;
		foreach( $columns as $col ) {
			$value = $record[$col['dataIndex']] ;
			if( $col['dataIndexString'] ) {
				$obj_sheet->setCellValueExplicit("{$cell}{$row}", $value,PHPExcel_Cell_DataType::TYPE_STRING);
			} else {
				if( is_numeric($value) && $value != ceil($value) ) {
					$value = round($value,2) ;
				}
				$obj_sheet->SetCellValue("{$cell}{$row}", $value );
			}
			$cell++ ;
		}
		
		if( $style_row && $style_rowalt ) {
			$style_toapply = ($row%2 == 0 )?$style_row:$style_rowalt ;
			$obj_sheet->getStyle("{$cell_min}{$row}:{$cell_max}{$row}")->applyFromArray( $style_toapply );
		}
	}


	$tmpfilename = tempnam( sys_get_temp_dir(), "FOO");
	$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
	$objWriter->save($tmpfilename);
	$objPHPExcel->disconnectWorksheets();
	unset($objPHPExcel) ;
	//$objPHPExcel->setActiveSheetIndex(0);
	
	$filename = 'XLS_Export'.'_'.time().'.xlsx' ;
	if( $post_data['exportBase64'] ) {
		$xls_binary = file_get_contents($tmpfilename) ;
		unlink($tmpfilename) ;
		sleep(1) ;
		return array('success'=>true, 'xls_base64'=>base64_encode($xls_binary), 'xls_filename'=>$filename) ;
	}
	header("Content-Type: application/force-download; name=\"$filename\"");
	header("Content-Disposition: attachment; filename=\"$filename\"");
	readfile($tmpfilename) ;
	unlink($tmpfilename) ;
	die() ;
}










function specDbsTracy_upload( $post_data ) {
	global $_opDB ;
	
	$handle = fopen($_FILES['file_upload']['tmp_name'],"rb") ;
	$file_model = $post_data['file_model'] ;
	
	// Specs
	switch( $file_model ) {
		case 'DATAIMPORT_INPUTPODLTA' :
			$ret = specDbsTracy_upload_DATAIMPORT($handle,'INPUT_PODLTA') ;
			break ;
		default :
			return array('success'=>false);
	}
	
	return array('success'=>$ret) ;
}

function specDbsTracy_upload_DATAIMPORT( $handle, $file_code ) {
	rewind($handle) ;
	$handle = paracrm_lib_dataImport_preHandle($handle) ;
	rewind($handle) ;
	paracrm_lib_dataImport_commit_processHandle( 'file', $file_code, $handle ) ;
	return true ;
}






$GLOBALS['__specDbsTracy_tmpClone_URL'] = '' ;
/*
$GLOBALS['__specDbsTracy_tmpClone_URL'] = 'https://10-39-10-205.int.mirabel-sil.com/paracrm.master/server/report.xml.php/data?PHP_AUTH_USER=admin%40dbs&PHP_AUTH_PW=password&_sdomainId=tracy&_moduleId=spec_dbs_tracy&_action=upload_tmpCloneActiveGet' ;
*/

$GLOBALS['__specDbsTracy_tmpClone_URL'] = 'https://services.schenkerfrance.fr/paracrm/server/report.xml.php/data?PHP_AUTH_USER=reports%40dbs&PHP_AUTH_PW=reports&_sdomainId=tracy&_moduleId=spec_dbs_tracy&_action=upload_tmpCloneActiveGet' ;


function specDbsTracy_upload_tmpCloneActiveGet($post_data) {
	global $_opDB ;
	
	$handle = tmpfile() ;
	
	$arr_tables = array('store_file_CDE','store_file_HAT','store_file_TRSPT','store_file_TRSPTPICK','store_file_TRSPTPOD','store_file_TICKET') ;
	foreach( $arr_tables as $table_base ) {
		$arr_db_tabs = array() ;
		$query = "SHOW FULL TABLES LIKE '{$table_base}%'" ;
		$result = $_opDB->query($query) ;
		while( ($arr = $_opDB->fetch_row($result)) != FALSE )
		{
			if( $arr[1] && $arr[1] != 'BASE TABLE' ) {
				continue ;
			}
			$arr_db_tabs[] = $arr[0] ;
		}
		
		foreach($arr_db_tabs as $db_tab) {
			fwrite($handle,"***BEGIN_TABLE**{$db_tab}***\r\n") ;
		
			$arr_columns = array() ;
			$query = "SHOW COLUMNS FROM $db_tab" ;
			$result = $_opDB->query($query) ;
			while( ($arr = $_opDB->fetch_row($result)) != FALSE )
			{
				$arr_columns[] = $arr[0] ;
			}
			fwrite($handle,implode(',',$arr_columns)."\r\n") ;

			if( $db_tab==$table_base ) {
				$query = "SELECT t.* FROM $table_base t
							WHERE t.field_ARCHIVE_IS_ON_int='0'" ;
			} else {
				$query = "SELECT t.* FROM $db_tab t
							JOIN $table_base p ON p.filerecord_id=t.filerecord_parent_id
							WHERE p.field_ARCHIVE_IS_ON_int='0'" ;
			}
			$result = $_opDB->query($query) ;
			while( ($arr = $_opDB->fetch_row($result)) != FALSE )
			{
				DatabaseMgr_Util::my_fputcsv( $handle , $arr , ',' ,'"') ;
			}
		}
	}
	
	fseek($handle,0) ;
	$binary = stream_get_contents($handle) ;
	fclose($handle) ;
	return array('success'=>true,'data'=>$binary) ;
}

function specDbsTracy_upload_tmpCloneActiveFetch($post_data) {
	global $_opDB ;
	if( !$GLOBALS['__OPTIMA_TEST'] ) {
		return array('success'=>false);
	}
	if( !$GLOBALS['__specDbsTracy_tmpClone_URL'] ) {
		return array('success'=>false);
	}
	
	$binary_csv = file_get_contents($GLOBALS['__specDbsTracy_tmpClone_URL']) ;
	if( !$binary_csv ) {
		return array('success'=>false);
	}
	
	
	$t = new DatabaseMgr_Sdomain( DatabaseMgr_Base::dbCurrent_getDomainId() );
	$current_db = $t->getSdomainDb( DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ) ;
	
	$handle = tmpfile() ;
	fwrite($handle,$binary_csv) ;
	fseek($handle,0) ;
	DatabaseMgr_Util::feed_DB( $handle, $current_db, FALSE, TRUE ) ;  // restauration complete
	fclose($handle) ;
	
	return array('success'=>true);
}

?>
