<?php

/*
.htaccess :
    RewriteEngine On
    RewriteRule rest/(.*)$ server/rest.php/$1 [L,QSA]
*/

/*
Test Curl :

curl -v --location --request PUT 'https://services.schenkerfrance.fr/_paracrm/rest////test/tracy//sna-extlabel' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJpc3MiOiJDb21mb3VyIERFViIsInN1YiI6Im9saXZpZXItZ2F1ZGV0QGx1dGVjZS1ncGZiLmNvbSIsImV4cCI6MTY1MDg3MzA0MX0.FQdVGjz0ZnRXpYyrGtZ2j7zFMzmhOoK4ugSreoEcpTqpfzZ38Ts9CJ9-o22P1kehEEdPdMD1AzykXr1UwbuYBg'

curl -v --location --request PUT 'https://10-39-10-205.int.mirabel-sil.com/paracrm.master/rest////test/tracy//sna-extlabel' \
--header 'Accept: application/json' \
--header 'Authorization: Bearer eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzUxMiJ9.eyJpc3MiOiJDb21mb3VyIERFViIsInN1YiI6Im9saXZpZXItZ2F1ZGV0QGx1dGVjZS1ncGZiLmNvbSIsImV4cCI6MTY1MDg3MzA0MX0.FQdVGjz0ZnRXpYyrGtZ2j7zFMzmhOoK4ugSreoEcpTqpfzZ38Ts9CJ9-o22P1kehEEdPdMD1AzykXr1UwbuYBg'

*/



/*
 * Gateway proxy Schenker
 * 
 * Token Prod : Bearer eyJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJzYWZyYW5zbHMiLCJpc3MiOiJFWFQiLCJpYXQiOjE3MzI3MjY0MzgsImF1ZCI6ImFwaWdhdGV3YXkvcmVzdC90cmFjeSIsImp0aSI6IjRjYmMzYjg2LWU2ZjgtNDYyYS04OTEzLTQ1ZTAwYzdkODQ0MyJ9.rGH_UY1-xXp3jveMmONDrl6owgFclYaX5qbReZZGwQrnpl2Gq5bpZ8NSc7AheiXHcdvyv3pVLIAgf8N9Z4BO2AOKQEF_3WnwqFr4HjMdLa72A6pjLL20B8UrStooJ60wda9J5TtMsfw9tWIpEsLYjkSdy7a6WAr0ktpKql_5qGbkga79ZE58YjWuNpoxLMO7JNyo7f3u1YYyMY4o7OSx_pQPsFyJK-Py7PXFRbajIJSFfGMDIOYt6hojsBr0diOnhQk397PhczlH8klOV9Bmf-ylJn2L0gPoAhCwLiimGcsz0kJ2xESY7sNyQdzrddSDS2iZ6ZAaMUFm17ebrkbMXQ
 * Token Preprod : Bearer eyJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJzYWZyYW5zbHMiLCJpc3MiOiJFWFQiLCJpYXQiOjE3MzI3Mjc5MzcsImF1ZCI6ImFwaWdhdGV3YXkvcmVzdC90cmFjeSIsImp0aSI6IjIxMWM0Njk1LTFhMTktNDBiNC04MmEyLWExNWM2N2Q5MThkYyJ9.daGPfvctYPhSJZhAI11pjGwJ711WXxSBpuQr-xsIuyhbS8AiE0dX4p2U57y0JMfrl3jJ1aJW38lQD1oJwBLz01U9VHjBGvpRtvg6JmZmf7JL0fDmXXykQHsBNTxYfjf8eofUpK_IWDwvr6g1GJTY9ePvtCdbkhbfaw_UxNMDdghLOA9zjcYdb4RT6lGVKsVfZbvzfpED70JBP-PUSnv8U4ArP7vUSI9hhET9kkueFl8HmWqmkZgedKcmPTX0M5BFfts0X1PDIYRFw0n0-3MhgZiX3-TFBOeh4NjxdqZmRYsLN9-VCSilxPuJZP6k4Dd-seJZ3rWL63_tbQ4LlIVvHQ
 * 
 */

$app_root='..' ;
$server_root='.' ;
$resources_root=$app_root.'/resources' ;



class Op5RestUtils {
	static function normalizePath($path)
	{
		return array_reduce(explode('/', $path), function($a, $b) {
			if ($a === null) {
					$a = "/";
			}
			if ($b === "" || $b === ".") {
					return $a;
			}
			if ($b === "..") {
					return dirname($a);
			}
	
			return strtolower(preg_replace("/\/+/", "/", "$a/$b"));
		});
	}
	/** 
	* Get hearder Authorization
	* */
	static function getAuthorizationHeader(){
		$requestHeaders = apache_request_headers();
		if( isset($requestHeaders['Authparacrm'])) {
			return trim($requestHeaders['Authparacrm']);
		}
		if( isset($requestHeaders['Authorization'])) {
			return trim($requestHeaders['Authorization']);
		}
		return null;
	}
	/**
	* get access token from header
	* */
	static function getBearerToken() {
		$headers = self::getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
					return $matches[1];
			}
		}
		return null;
	}
	static function getAndroidId() {
		$headers = self::getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/AndroidId\s(\S+)/', $headers, $matches)) {
					return $matches[1];
			}
		}
		return null;
	}
}

$_http_method = $_SERVER['REQUEST_METHOD'] ;
$_rest_path = explode('/',Op5RestUtils::normalizePath($_SERVER['PATH_INFO'])) ;
$_token = Op5RestUtils::getBearerToken() ;
$_androidId = Op5RestUtils::getAndroidId() ;

if( $_androidId ) {
	if( $redirections = @file('./rest.redirections.txt',FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) ) {
		foreach( $redirections as $line ) {
			$ttmp = explode(':',$line,2) ;
			if( count($ttmp) != 2 ) {
				continue ;
			}
			if( trim($ttmp[0]) == $_androidId ) {
				$url_redirect = trim($ttmp[1]) ;
				
				header("HTTP/1.0 301 Redirected");
				header("Location: ".$url_redirect);
				die() ;
			}
		}
	}
}


switch( $_rest_path[1] ) {
	case 'ezeer' :
		$_domainId = 'dbs' ;
		$_sdomainId = 'ezeer' ;
		include("$server_root/modules/spec_dbs_ezeer/backend_spec_dbs_ezeer.inc.php");
		break ;
	case 'tracy' :
		$_domainId = 'dbs' ;
		$_sdomainId = 'tracy' ;
		include("$server_root/modules/spec_dbs_tracy/backend_spec_dbs_tracy.inc.php");
		break ;
	default :
		break ;
}

include("$server_root/include/config.inc.php");
include("$server_root/include/toolfunctions.inc.php");

include("$server_root/modules/media/include/media.inc.php");

include( "$server_root/include/database/mysql_DB.inc.php" ) ;
$_opDB = new mysql_DB( );
$_opDB->connect_mysql( $mysql_host, '', $mysql_user, $mysql_pass );
$_opDB->query("SET NAMES UTF8") ;

// *** Check DATABASES to issue 404 if not found ***
$obj_dmgr_base = new DatabaseMgr_Base() ;
$obj_dmgr_sdomain = new DatabaseMgr_Sdomain( $_domainId ) ;
if( !$obj_dmgr_base->baseDb_exists($_domainId) || !$obj_dmgr_sdomain->sdomainDb_exists($_sdomainId) ) {
	header("HTTP/1.0 404 Not Found");
	die() ;
}
$_opDB->select_db( $obj_dmgr_sdomain->getSdomainDb($_sdomainId) ) ;

$GLOBALS['mysql_db'] = $obj_dmgr_base->getBaseDb( $_domainId ) ;


switch( $_rest_path[1] ) {
	case 'ezeer' :
	switch( $_rest_path[2] ) {
		case 'get-ticket' :
			$p_ticketFilerecordId = urldecode($_rest_path[3]) ;
			$json = specDbsEzeer_ticket_getRecord(array(
				'ticket_filerecord_id' => $p_ticketFilerecordId,
				'do_flag' => 1,
			)) ;
			if( $json['success'] ) {
				$row_ticket = $json['data'] ;
				header("HTTP/1.0 200 OK");
				die( json_encode($row_ticket) ) ;
			}
			header("HTTP/1.0 404 Not Found");
			exit ;
		case 'get-attach' :
			$p_attachFilerecordId = urldecode($_rest_path[3]) ;
			$json = specDbsEzeer_attach_downloadB64( array('file_code'=>'ATTACH','filerecord_id'=>$p_attachFilerecordId) );
			if( $json['success'] ) {
				unset($json['success']) ;
				header("HTTP/1.0 200 OK");
				die( json_encode($json) ) ;
			}
			header("HTTP/1.0 404 Not Found");
			exit ;
			
		case 'post-ticket-new' :
			$post_content = file_get_contents('php://input');
			$p_formData = json_decode($post_content,true) ;
			
			$date_now = date('Y-m-d H:i:s') ;
			$arr_update = array() ;
			$arr_update['field_PROP_TITLE'] = $p_formData['prop_title'] ;
			$arr_update['field_PROP_PEOPLE'] = true ;
			$arr_update['field_PROP_LINKS'] = true ;
			$arr_update['field_STATUS_IS_NEW'] = 1;
			$arr_update['field_DATE_CREATE'] = $date_now ;
			$arr_update['field_DATE_UPDATE'] = $date_now ;
			$ticket_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET', 0, $arr_update );
			
			foreach( $p_formData['prop_people'] as $people_row ) {
				if( !$people_row['people_txt'] ) {
					$query = NULL ;
					switch( $people_row['people_type'] ) {
						case 'user' :
							$query = "SELECT field_USER_NAME FROM view_bible_PPL_USER_entry WHERE entry_key='{$people_row['people_id']}'" ;
							break ;
						case 'group' :
							$query = "SELECT field_GROUP_TXT FROM view_bible_PPL_GROUP_tree WHERE treenode_key='{$people_row['people_id']}'" ;
							break ;
					}
					if( $query ) {
						$people_row['people_txt'] = $_opDB->query_uniqueValue($query) ;
					}
				}
				
				$arr_ins = array() ;
				$arr_ins['field_PEOPLE_TYPE'] = $people_row['people_type'] ;
				$arr_ins['field_PEOPLE_ID'] = $people_row['people_id'] ;
				$arr_ins['field_PEOPLE_TXT'] = $people_row['people_txt'] ;
				$arr_ins['field_OWNER_IS_ON'] = 1 ;
				$prop_people_id = paracrm_lib_data_insertRecord_file( 'TICKET_PROP_PEOPLE', $ticket_filerecord_id, $arr_ins );
				
				$arr_ins = array() ;
				$arr_ins['field_PROPPEOPLE_ID'] = $prop_people_id ;
				$arr_ins['field_ASSIGN_IS_ON'] = 1 ;
				$arr_ins['field_DATE_ASSIGN'] = date('Y-m-d H:i:s') ;
				paracrm_lib_data_insertRecord_file( 'TICKET_ASSIGN', $ticket_filerecord_id, $arr_ins );
			}
			
			foreach( $p_formData['prop_links'] as $link_row ) {
				$arr_ins = array() ;
				$arr_ins['field_LINK_CFGCODE'] = $link_row['link_cfgcode'] ;
				$arr_ins['field_LINK_ID'] = $link_row['link_id'] ;
				$arr_ins['field_LINK_TXT'] = $link_row['link_txt'] ;
				paracrm_lib_data_insertRecord_file( 'TICKET_PROP_LINK', $ticket_filerecord_id, $arr_ins );
			}
			
			die( json_encode(array(
				'ticket_filerecord_id'=>$ticket_filerecord_id,
			)) ) ;
			
			
		case 'post-ticket-action' :
			$p_ticketFilerecordId = urldecode($_rest_path[3]) ;
			$post_content = file_get_contents('php://input');
			$p_formData = json_decode($post_content,true) ;
			
			$query = "SELECT count(*) FROM view_file_TICKET_ACTION WHERE filerecord_parent_id='{$p_ticketFilerecordId}'" ;
			if( $_opDB->query_uniqueValue($query) == 0 ) {
				// Has been linked !
				$query = "SELECT filerecord_parent_id FROM view_file_TICKET_ACTION
								WHERE field_BASE_TICKET_ID='{$p_ticketFilerecordId}'" ;
				if( $new_ticket_filerecord_id = $_opDB->query_uniqueValue($query) ) {
					$p_ticketFilerecordId = $new_ticket_filerecord_id ;
				}
			}
			
			$date_now = date('Y-m-d H:i:s') ;
			paracrm_lib_data_updateRecord_file( 'TICKET', array('field_DATE_UPDATE'=>$date_now), $p_ticketFilerecordId );
			
			$query = "SELECT field_PROP_TITLE FROM view_file_TICKET WHERE filerecord_id='{$p_ticketFilerecordId}'" ;
			$prop_title = $_opDB->query_uniqueValue($query) ;
			
			$arr_ins = array();
			$arr_ins['field_ACTION_USER'] = $p_formData['action_user'] ;
			$arr_ins['field_ACTION_DATE'] = $p_formData['action_date'] ;
			$arr_ins['field_BODY_TXT'] = $p_formData['body_txt'] ;
			$arr_ins['field_EMAILFROM_JSON'] = json_encode(array(
				'subject' => $prop_title,
				'date' => $date_now,
				//'from' => 'tracy@dbs',
				//'to' => 'ezeer@dbs',
			));
			$ticketaction_filerecord_id = paracrm_lib_data_insertRecord_file( 'TICKET_ACTION', $p_ticketFilerecordId, $arr_ins );
			
			if( $p_formData['attachments'] ) {
				foreach( $p_formData['attachments'] as $at ) {
					$arr_ins = array() ;
					$arr_ins['field_ATTACH_FILENAME'] = $at['attach_filename'] ;
					$arr_ins['field_ATTACH_DATE'] = $date_now ;
					$arr_ins['field_TICKETACTION_ID'] = $ticketaction_filerecord_id ;
					$attach_filerecord_id = paracrm_lib_data_insertRecord_file( 'ATTACH', 0, $arr_ins );
					
					$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
					$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
					media_contextOpen( $_sdomain_id ) ;
					$tmp_media_id = media_bin_processBuffer( base64_decode($at['attach_base64']) ) ;
					media_bin_move( $tmp_media_id , media_bin_toolFile_getId('ATTACH',$attach_filerecord_id) ) ;
					media_contextClose() ;
				}
			}
			
			specDbsEzeer_ticket_lib_pushNotification($p_ticketFilerecordId);
			
			die( json_encode(array(
				'ticket_filerecord_id'=>$p_ticketFilerecordId,
				'ticketaction_filerecord_id'=>$ticketaction_filerecord_id,
			)) ) ;
			
			
		case 'post-ticket-close' :
			$p_ticketFilerecordId = urldecode($_rest_path[3]) ;
			$post_content = file_get_contents('php://input');
			$p_formData = json_decode($post_content,true) ;
			
			$date_now = date('Y-m-d H:i:s') ;
			$arr_update = array(
				'field_CLOSED_IS_ON' => 1,
				'field_CLOSED_DATE' => $date_now,
			);
			if( $p_formData && $p_formData['close_reason'] ) {
				$arr_update['field_CLOSED_CODE'] = $p_formData['close_reason'];
			}
			paracrm_lib_data_updateRecord_file( 'TICKET', $arr_update, $p_ticketFilerecordId );
			die( json_encode(array(
				'ticket_filerecord_id'=>$p_ticketFilerecordId,
			)) ) ;
			
			
		case 'mach-email' :
			$post_content = file_get_contents('php://input');
			$p_formData = json_decode($post_content,true) ;
			
			$email_mbox = $p_formData['email_from'];
			
			$json_cfg = specDbsEzeer_cfg_getConfig() ;
			$map_peopleGroupId_group = array() ;
			foreach( $json_cfg['data']['cfg_people_group'] as $row ) {
				$map_peopleGroupId_group[$row['group_id']] = $row ;
			}
			
			$prop_people = array() ;
			$prop_people_owner = NULL ;
			$people_group_id = $people_user_id = NULL ;
			$query = "SELECT field_MAP_TO_GROUP FROM view_bible_EMAIL_entry WHERE entry_key='$email_mbox'" ;
			if( $tstr = $_opDB->query_uniqueValue($query) ) {
				$ttmp = explode(':',$tstr,2) ;
				$people_group_id = $ttmp[0] ;
				$people_user_id = $ttmp[1] ;
			}
			if( $people_group_id && $map_peopleGroupId_group[$people_group_id] ) {
				$prop_people_owner = array(
					'people_type' => 'group',
					'people_id' => $people_group_id,
					'people_txt' => $map_peopleGroupId_group[$people_group_id]['group_txt']
				);
				$prop_people[] = $prop_people_owner ;
			}
			
			$date_now = date('Y-m-d H:i:s') ;
			
			// create ticket
			$form_data = array(
				'body_html' => "Automated Email from Mach<br>Picking : {$p_formData['picking_id']}<br>",
				'prop_people' => $prop_people,
				'prop_people_owner' => $prop_people_owner,
				'date_now' => $date_now,
				'prop_links' => array(),
				'prop_title' => $p_formData['email_subject'],
				'emailfrom_data' => array(
					'subject' => $p_formData['email_subject'],
					'date' => $date_now,
					'from' => $p_formData['email_to'],
					'to' => $p_formData['email_from'],
				),
				'attachments' => array(),
			);
			$json = specDbsEzeer_ticket_postAction( array(
				'form_data' => json_encode($form_data)
			));
			$ticket_filerecord_id = $json['ticket_filerecord_id'];
			
			$form_data = array(
				'body_html' => nl2br($p_formData['email_body']),
				'prop_people' => $prop_people,
				'prop_people_owner' => $prop_people_owner,
				'date_now' => $date_now,
				'prop_links' => array(),
				'prop_title' => $p_formData['email_subject'],
				'outemail_is_on' => true,
				'outemail_from' => $p_formData['email_from'],
				'outemail_to' => array($p_formData['email_to']),
				'outemail_cc' => array(),
				'attachments' => array(),
			);
			$json = specDbsEzeer_ticket_postAction( array(
				'ticket_filerecord_id' => $ticket_filerecord_id,
				'form_data' => json_encode($form_data)
			));
			
			die( json_encode(array(
				'ticket_filerecord_id'=>$ticket_filerecord_id,
			)) ) ;
			break ;
			
			
		default :
			header("HTTP/1.0 404 Not Found");
			exit ;
	}
	case 'tracy' :
	switch( $_rest_path[2] ) {
		case 'ezeer-ping' :
			$post_content = file_get_contents('php://input');
			$p_formData = json_decode($post_content,true) ;
			if( !$p_formData['ticket_filerecord_id'] ) {
				header("HTTP/1.0 500 Internal Server Error");
				exit ;
			}
			$_pEzeerTicketFilerecordId = $p_formData['ticket_filerecord_id'] ;
			$query = "SELECT filerecord_id
						FROM view_file_TICKET
						WHERE JSON_VALUE(field_EZPROXY_JSON,'$.ezeer.ticket_filerecord_id')='{$_pEzeerTicketFilerecordId}'" ;
			$result = $_opDB->query($query) ;
			if( $_opDB->num_rows($result)==0 ) {
				header("HTTP/1.0 204 No Content");
				exit ;
			}
			while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
				$ticket_filerecord_id = $arr[0];
				specDbsTracy_ticket_lib_syncEzeer($ticket_filerecord_id) ;
			}
			header("HTTP/1.0 202 Accepted");
			exit ;
		case 'pod-ping' :
			if( paracrm_lib_android_authDevice_ping($_androidId,true,"TracyPod-220816") ) {
				header("HTTP/1.0 204 No Content");
			} else {
				header("HTTP/1.0 403 Forbidden");
			}
			exit ;
		case 'pod-scan' :
			//sleep(1) ;
			$scanQueryString = urldecode($_rest_path[3]) ;
			
			while( TRUE ) {
				$obj = NULL ;
			
				$do_sanitize = FALSE ;
				$hat_filerecord_id = NULL ;
				while( TRUE ) {
					$p_scanval = $scanQueryString ;
					if( $do_sanitize ) {
						$p_scanval_new = $scanQueryString ;
						$p_scanval_new = preg_replace("/[^0-9\s]/", "", $p_scanval_new) ;
						$p_scanval_new = (string)(int)$p_scanval_new ;
						if( $p_scanval_new==$p_scanval ) {
							break ;
						}
						$p_scanval = $p_scanval_new ;
					}
					$p_scanval = $_opDB->escape_string($p_scanval) ;
				
					// TODO : into Tracy libraries
					$query = "SELECT h.filerecord_id
								FROM view_file_CDE q
								JOIN view_file_HAT_CDE qh ON qh.field_FILE_CDE_ID=q.filerecord_id AND field_LINK_IS_CANCEL='0'
								JOIN view_file_HAT h ON h.filerecord_id=qh.filerecord_parent_id
								WHERE 1
								AND q.field_ARCHIVE_IS_ON='0'
								AND q.field_ID_DN='{$p_scanval}'" ;
					if( $hat_filerecord_id = $_opDB->query_uniqueValue($query) ) {
						break ;
					}
					
					$query = "SELECT q.filerecord_id
								FROM view_file_HAT q
								WHERE 1
								AND q.field_ARCHIVE_IS_ON='0'
								AND q.field_ID_HAT='{$p_scanval}'" ;
					if( $hat_filerecord_id = $_opDB->query_uniqueValue($query) ) {
						break ;
					}
				
					if( !$do_sanitize ) {
						$do_sanitize = TRUE ;
						continue ;
					}
					break ;
				}
				if( !$hat_filerecord_id ) {
					$error = "Scan not recognized" ;
					break ;
				}
				
				$getHatObj = function($hat_filerecord_id) use ( $_opDB ) {
					$query = "SELECT field_ID_HAT FROM view_file_HAT WHERE filerecord_id='{$hat_filerecord_id}'" ;
					$id_hat = $_opDB->query_uniqueValue($query) ;
					
					$obj = array() ;
					$obj += array(
						'hat_filerecord_id' => $hat_filerecord_id,
						'id_hat' => $id_hat,
						'atr_consignee' => '',
						'cdes' => array()
					) ;
					
					$query = "SELECT c.field_ATR_CONSIGNEE, cfg.field_NAME
								FROM view_file_HAT h
								JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=h.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
								JOIN view_file_CDE c ON c.filerecord_id=hc.field_FILE_CDE_ID
								LEFT OUTER JOIN view_bible_LIST_CONSIGNEE_entry cfg ON cfg.entry_key=c.field_ATR_CONSIGNEE
								WHERE h.filerecord_id='{$hat_filerecord_id}'
								LIMIT 1" ;
					$result = $_opDB->query($query) ;
					if( $_opDB->num_rows($result) == 1 ) {
						$arr = $_opDB->fetch_row($result) ;
						$obj['atr_consignee'] = $arr[0] ;
						$obj['atr_consignee_txt'] = $arr[1] ;
					}
					
					$query = "SELECT c.filerecord_id, c.field_ID_DN, max(cs.field_STEP_CODE)
								FROM view_file_HAT h
								JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=h.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
								JOIN view_file_CDE c ON c.filerecord_id=hc.field_FILE_CDE_ID
								JOIN view_file_CDE_STEP cs ON cs.filerecord_parent_id=c.filerecord_id AND field_STATUS_IS_OK='1'
								WHERE h.filerecord_id='{$hat_filerecord_id}'
								GROUP BY c.filerecord_id" ;
					$result = $_opDB->query($query) ;
					while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
						$obj['cdes'][] = array(
							'cde_filerecord_id' => $arr[0],
							'id_dn' => $arr[1],
							'status' => $arr[2]
						);
					}
					return $obj ;
				};
				$obj = $getHatObj($hat_filerecord_id) ;
				
				$ready_for_POD = FALSE ;
				foreach( $obj['cdes'] as $cde ) {
					if( $cde['status'] == '70_PICKUP' ) {
						$ready_for_POD = TRUE ;
					}
				}
				if( !$ready_for_POD ) {
					$error = 'Barcode <'.$scanQueryString.'>'."\n";
					$error.= 'for shipment : '.$obj['id_hat']."\n" ;
					$error.= 'is not ready for POD' ;
					$obj = NULL ;
					break ;
				}
				
				$query = "SELECT distinct tp.filerecord_id
							FROM view_file_HAT h
							JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=h.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
							JOIN view_file_CDE c ON c.filerecord_id=hc.field_FILE_CDE_ID
							JOIN view_file_TRSPT_CDE tc ON tc.field_FILE_CDE_ID=c.filerecord_id AND tc.field_LINK_IS_CANCEL='0'
							JOIN view_file_TRSPT t ON t.filerecord_id=tc.filerecord_parent_id
							JOIN view_file_TRSPTPICK_TRSPT tpt ON tpt.field_FILE_TRSPT_ID=t.filerecord_id AND tpt.field_LINK_IS_CANCEL='0'
							JOIN view_file_TRSPTPICK tp ON tp.filerecord_id=tpt.filerecord_parent_id
							WHERE h.filerecord_id='{$hat_filerecord_id}'" ;
				$result = $_opDB->query($query) ;
				if( $_opDB->num_rows($result) == 1 ) {
					$arr = $_opDB->fetch_row($result) ;
					$trsptpick_filerecord_id = $arr[0] ;
				}
				if( $trsptpick_filerecord_id ) {
					$query = "SELECT p.filerecord_id as trsptpick_filerecord_id
									, p.field_ID_PICK as trsptpick_id
									, car.field_NAME as mvt_carrier_txt
								FROM view_file_TRSPTPICK p
								JOIN view_file_TRSPTPICK_TRSPT pt ON pt.filerecord_parent_id=p.filerecord_id AND pt.field_LINK_IS_CANCEL='0'
								JOIN view_file_TRSPT t ON t.filerecord_id=pt.field_FILE_TRSPT_ID
								JOIN view_bible_LIST_CARRIER_entry car ON car.entry_key=t.field_MVT_CARRIER
								WHERE p.filerecord_id='{$trsptpick_filerecord_id}'" ;
					$result = $_opDB->query($query) ;
					while( ($arr = $_opDB->fetch_assoc($result)) != FALSE ) {
						$obj['link_trsptpickObj'] = $arr ;
					}
					
					$arr_hatFilerecordIds = array() ;
					$query = "SELECT distinct h.filerecord_id
								FROM view_file_TRSPTPICK tp
								JOIN view_file_TRSPTPICK_TRSPT tpt ON tpt.filerecord_parent_id=tp.filerecord_id AND tpt.field_LINK_IS_CANCEL='0'
								JOIN view_file_TRSPT t ON t.filerecord_id = tpt.field_FILE_TRSPT_ID
								JOIN view_file_TRSPT_CDE tc ON tc.filerecord_parent_id=t.filerecord_id AND tc.field_LINK_IS_CANCEL='0'
								JOIN view_file_CDE c ON c.filerecord_id = tc.field_FILE_CDE_ID
								JOIN view_file_HAT_CDE hc ON hc.field_FILE_CDE_ID=c.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
								JOIN view_file_HAT h ON h.filerecord_id=hc.filerecord_parent_id
								WHERE tp.filerecord_id='$trsptpick_filerecord_id'" ;
					$result = $_opDB->query($query) ;
					while( ($arr = $_opDB->fetch_row($result)) != FALSE ) {
						$arr_hatFilerecordIds[] = $arr[0] ;
					}
					$obj['link_hats'] = array() ;
					foreach( $arr_hatFilerecordIds as $hat_filerecord_id ) {
						$sub_obj = $getHatObj($hat_filerecord_id) ;
						
						$ready_for_POD = FALSE ;
						foreach( $sub_obj['cdes'] as $cde ) {
							if( $cde['status'] == '70_PICKUP' ) {
								$ready_for_POD = TRUE ;
							}
						}
						if( !$ready_for_POD ) {
							continue ;
						}
						
						$obj['link_hats'][] = $sub_obj ;
					}
				}
				
				break ;
			}
			if( !$obj ) {
				header("HTTP/1.0 404 Not Found");
				if( $error ) {
					die( json_encode( array('error'=>$error) ) );
				}
			}
			header("HTTP/1.0 200 OK");
			die( json_encode($obj) ) ;
			exit ;
			
		case 'pod-submit' :
			$post_content = file_get_contents('php://input');
			$filename = time().'.'.implode('_',$_rest_path).'.bin' ;
			$filepath = '/var/lib/optima5/dbs_prod/tracy/tmp/'.$filename ;
			
			@file_put_contents($filepath,$post_content) ;
			
			$obj = json_decode($post_content,true) ;
			
			$date_now = date('Y-m-d H:i:s') ;
			
			$prefix = 'POD/' ;
			$prefix_len = strlen($prefix) ;
			$offset = $prefix_len+1 ;
			$query = "SELECT max(substring(field_ID_POD,{$offset},5)) FROM view_file_TRSPTPOD WHERE field_ID_POD LIKE '{$prefix}%'" ;
			$max_idx = $_opDB->query_uniqueValue($query) ;
			$max_idx++ ;
			
			$arr_ins = array() ;
			$arr_ins['field_ID_POD'] = $prefix.str_pad((float)$max_idx, 5, "0", STR_PAD_LEFT) ;
			$arr_ins['field_DATE_CREATE'] = $date_now ;
			$arr_ins['field_SIGN_ANDROID'] = $_androidId ;
			$arr_ins['field_DRIVER_NAME'] = $obj['objFields']['driver_name'] ;
			$arr_ins['field_RECEIVER_NAME'] = $obj['objFields']['receiver_name'] ;
			$arr_ins['field_SIGN_JPEG64'] = $obj['signatureBase64'] ;
			$trsptpod_filerecord_id = paracrm_lib_data_insertRecord_file( 'TRSPTPOD', 0, $arr_ins );
			$arrDB_trsptpod = $arr_ins ;
			
			foreach( $obj['arrBase64Photos'] as $photo_base64 ) {
				$arr_ins = array() ;
				$arr_ins['field_PHOTO_ID'] = time().'-'.'Android' ;
				$podphoto_filerecord_id = paracrm_lib_data_insertRecord_file( 'TRSPTPOD_PHOTO', $trsptpod_filerecord_id, $arr_ins );
				
				$jpg_path = tempnam( sys_get_temp_dir(), "FOO");
				rename($jpg_path,$jpg_path.'.jpg') ;
				$jpg_path.= '.jpg' ;
				file_put_contents( $jpg_path, base64_decode($photo_base64) ) ;
				
					$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
					$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
					media_contextOpen( $_sdomain_id ) ;
					$tmp_media_id = media_img_processUploaded( $jpg_path ) ;
					media_img_move( $tmp_media_id , media_bin_toolFile_getId('TRSPTPOD_PHOTO',$podphoto_filerecord_id) ) ;
					media_contextClose() ;
					
				unlink($jpg_path) ;
			}
			
			$_androidId_logUser = $_androidId ;
			$query = "SELECT device_desc FROM auth_android WHERE device_android_id='{$_androidId}'" ;
			if( ($tstr = $_opDB->query_uniqueValue($query)) ) {
				$_androidId_logUser = $tstr ;
			}
			foreach( $obj['arrHatFilerecordIds'] as $hat_filerecord_id ) {
				$query = "UPDATE view_file_HAT h
							JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=h.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
							JOIN view_file_CDE c ON c.filerecord_id=hc.field_FILE_CDE_ID
							JOIN view_file_CDE_STEP cs90 ON cs90.filerecord_parent_id=c.filerecord_id AND cs90.field_STEP_CODE='90_POD'
							SET cs90.field_STATUS_IS_OK='1', cs90.field_DATE_ACTUAL='{$date_now}', cs90.field_LOG_USER='{$_androidId_logUser}'
							WHERE h.filerecord_id='{$hat_filerecord_id}' AND cs90.field_STATUS_IS_OK='0'" ;
				$_opDB->query($query) ;
				
				$query = "SELECT tc.filerecord_parent_id as trspt_filerecord_id
							FROM view_file_HAT h
							JOIN view_file_HAT_CDE hc ON hc.filerecord_parent_id=h.filerecord_id AND hc.field_LINK_IS_CANCEL='0'
							JOIN view_file_CDE c ON c.filerecord_id=hc.field_FILE_CDE_ID
							JOIN view_file_TRSPT_CDE tc ON tc.field_FILE_CDE_ID=c.filerecord_id AND tc.field_LINK_IS_CANCEL='0'
							WHERE h.filerecord_id='{$hat_filerecord_id}'" ;
				$trspt_filerecord_id = $_opDB->query_uniqueValue($query) ;
				if( $trspt_filerecord_id ) {
					// insert TRSPTPOD_TRSPT
					$query = "UPDATE view_file_TRSPTPOD_TRSPT
								SET field_LINK_IS_CANCEL='1'
								WHERE field_FILE_TRSPT_ID='{$trspt_filerecord_id}' AND filerecord_parent_id<>'$trsptpod_filerecord_id'" ;
					$_opDB->query($query) ;
					$arr_ins = array();
					$arr_ins['field_FILE_TRSPT_ID'] = $trspt_filerecord_id ;
					$arr_ins['field_LINK_IS_CANCEL'] = 0 ;
					$podphoto_filerecord_id = paracrm_lib_data_insertRecord_file( 'TRSPTPOD_TRSPT', $trsptpod_filerecord_id, $arr_ins );
					
					// insert event
					$event_txt = "POD document {$arrDB_trsptpod['field_ID_POD']}"."\n" ;
					$event_txt.= '- Driver : '.$arrDB_trsptpod['field_DRIVER_NAME']."\n" ;
					$event_txt.= '- Receiver : '.$arrDB_trsptpod['field_RECEIVER_NAME']."\n" ;
					$arr_ins = array() ;
					$arr_ins['field_EVENT_DATE'] = date('Y-m-d H:i:s') ;
					$arr_ins['field_EVENT_USER'] = 'POD' ;
					$arr_ins['field_EVENT_TXT'] = $event_txt ;
					$arr_ins['field_EVENTLINK_FILE'] = 'TRSPTPOD' ;
					$arr_ins['field_EVENTLINK_IDS_JSON'] = json_encode(array('PRINT'=>$trsptpod_filerecord_id)) ;
					$trsptevent_filerecord_id = paracrm_lib_data_insertRecord_file( 'TRSPT_EVENT', $trspt_filerecord_id, $arr_ins );
				}
			}
			
			// PDF create
			$json_pdf = specDbsTracy_trsptpod_printDoc(array(
				'trsptpod_filerecord_id'=>$trsptpod_filerecord_id
			)) ;
			if( $json_pdf['pdf_base64'] ) {
				$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
				$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
				media_contextOpen( $_sdomain_id ) ;
				$tmp_media_id = media_bin_processBuffer( base64_decode($json_pdf['pdf_base64']) ) ;
				media_bin_move( $tmp_media_id , media_bin_toolFile_getId('TRSPTPOD',$trsptpod_filerecord_id) ) ;
				media_contextClose() ;
			}
			
			header("HTTP/1.0 202 Accepted");
			exit ;
			
		case 'sna-extlabel' :
			$post_content = file_get_contents('php://input');
			$filename = time().'.'.implode('_',$_rest_path).'.bin' ;
			$filepath = '/var/lib/optima5/dbs_prod/tracy/tmp/'.$filename ;
			
			@file_put_contents($filepath,$post_content) ;
			
			$recv_obj = json_decode($post_content,true) ;
			
			$forward_extRef = ltrim($recv_obj['deliveryReference'],'0') ;
			$forward_obj = array(
				'trackingNumber' => $recv_obj['trackingNumber'],
				'labelData' => reset($recv_obj['files'])
			);
			specDbsTracy_lib_TMS_storeExtLabel($forward_obj,$forward_extRef,array('trackingNumber'=>$forward_obj['trackingNumber']));
			
			header("HTTP/1.0 202 Accepted");
			exit ;
		case 'search' :
			$searchString = urldecode($_rest_path[3]) ;
			if( !$searchString || strlen($searchString)<3 ) {
				die(json_encode(array('error'=>'Search string must be >3')));
			}
			
			$arr_orderFilerecordIds = array();
			
			$query = "SELECT filerecord_id FROM view_file_CDE WHERE field_ID_DN='{$searchString}' OR field_REF_PO='{$searchString}' OR field_REF_INVOICE='{$searchString}'" ;
			$result = $_opDB->query($query);
			if( $_opDB->num_rows($result) > 10 ) {
				die(json_encode(array('error'=>'Too many results')));
			}
			while( ($arr = $_opDB->fetch_row($result))) {
				$arr_orderFilerecordIds[] = $arr[0];
			}
			
			$query = "SELECT c.filerecord_id
					FROM view_file_TRSPT t
					JOIN view_file_TRSPT_CDE tc ON tc.filerecord_parent_id=t.filerecord_id
					JOIN view_file_CDE c ON c.filerecord_id=tc.field_FILE_CDE_ID AND tc.field_LINK_IS_CANCEL='0'
					WHERE t.field_FLIGHT_AWB='{$searchString}'";
			$result = $_opDB->query($query);
			while( ($arr = $_opDB->fetch_row($result))) {
				$arr_orderFilerecordIds[] = $arr[0];
			}
			
			if( !$arr_orderFilerecordIds ) {
				die(json_encode(array('orders'=>array())));
			}
			
			$TAB = array();
			$query = "SELECT c.filerecord_id as order_filerecord_id
						, c.field_ID_SOC as id_soc
						, c.field_ID_DN  as id_dn
						, c.field_REF_PO as ref_po
						, c.field_REF_INVOICE as ref_invoice
						FROM view_file_CDE c
						WHERE filerecord_id IN ".$_opDB->makeSQLlist($arr_orderFilerecordIds);
			$result = $_opDB->query($query);
			while( ($arr = $_opDB->fetch_assoc($result))) {
				$TAB[] = $arr;
			}
			header("HTTP/1.0 200 OK");
			die( json_encode(array('orders'=>$TAB)) ) ;
		case 'order' :
			// TEST : 83388696
			$order_filerecord_id = urldecode($_rest_path[3]) ;
			$json = specDbsTracy_order_getRecords(array('filter_orderFilerecordId_arr'=>json_encode(array($order_filerecord_id))));
			if( $json['success'] && (count($json['data'])==1) ) {
				$obj_order = reset($json['data']);
				
				$forward_props = array('steps','attachments');
				$props_toUnset = array();
				foreach( $obj_order as $mkey=>$mvalue ) {
					if( is_array($mvalue) && !in_array($mkey,$forward_props) ) {
						$props_toUnset[] = $mkey ;
					}
				}
				foreach( $props_toUnset as $mkey ) {
					unset($obj_order[$mkey]);
				}
				
				if( $obj_order['calc_hat_filerecord_id'] ) {
					$hat_filerecord_id = $obj_order['calc_hat_filerecord_id'];
					$json = specDbsTracy_hat_getRecords(array('filter_hatFilerecordId_arr'=>json_encode(array($hat_filerecord_id))));
					$obj_hat = reset($json['data']);
					
					$props_toCopy = array('parcels') ;
					foreach( $props_toCopy as $mkey ) {
						$obj_order[$mkey] = $obj_hat[$mkey];
					}
				}
				if( $obj_order['calc_link_trspt_filerecord_id'] ) {
					$trspt_filerecord_id = $obj_order['calc_link_trspt_filerecord_id'];
					$json = specDbsTracy_trspt_getRecords(array('filter_trsptFilerecordId_arr'=>json_encode(array($trspt_filerecord_id))));
					$obj_trspt = reset($json['data']);
					
					$obj_order['trspt_carrier'] = $obj_trspt['mvt_carrier'];
					$obj_order['trspt_carrier_prod'] = $obj_trspt['mvt_carrier_prod'];
					$obj_order['trspt_carrier_account'] = $obj_trspt['mvt_carrier_account'];
					$obj_order['trspt_carrier_tracking'] = $obj_trspt['flight_awb'];
					$obj_order['calc_step_next'] = $obj_trspt['calc_step_next'];
				}
				
				foreach( $obj_order['attachments'] as &$attach ) {
					$media_id = $attach['attachment_media_id'];
					
					$_domain_id = DatabaseMgr_Base::dbCurrent_getDomainId() ;
					$_sdomain_id = DatabaseMgr_Sdomain::dbCurrent_getSdomainId() ;
					media_contextOpen( $_sdomain_id ) ;
					switch( media_auto_getType($media_id) ) {
						case 'pdf' :
							$bin_main = media_pdf_getBinary($media_id);
							$ttmp = media_pdf_getPreviewsBinary($media_id);
							$bin_preview = reset($ttmp);
							$extension = 'pdf';
							break ;
						case 'img' :
							$bin_main = media_img_getBinary($media_id) ;
							$bin_preview = media_img_getBinary($media_id,true) ;
							$extension = 'jpg';
							break ;
						default :
							continue 2 ;
					}
					media_contextClose() ;
					
					$attach['bin_extension']=$extension;
					$attach['bin_b64_preview'] = base64_encode($bin_preview) ;
					$attach['bin_b64_file'] = base64_encode($bin_main) ;
				}
				
				header("HTTP/1.0 200 OK");
				die(json_encode($obj_order));
			}
			header("HTTP/1.0 404 Not Found");
			exit;
		default :
			header("HTTP/1.0 404 Not Found");
			exit ;
	}
	
	case 'test' :
		echo "METHOD = ".$_http_method."\n" ;
		echo "PATH_INFO = ".implode('/',$_rest_path)."\n" ;
		echo "TOKEN = ".$_token."\n" ;
		die() ;
	default :
		header("HTTP/1.0 404 Not Found");
		exit ;
}
?>
