<?php

$app_root='../..' ;
$server_root='..' ;
$resources_root=$app_root.'/resources' ;

class Op5RouterUtils {
	static function normalizePath($path)
	{
		return array_reduce(explode('/', $path), function($a, $b) {
			if ($a === null) {
					$a = "/";
			}
			if ($b === "" || $b === ".") {
					return $a;
			}
			if ($b === "..") {
					return dirname($a);
			}
	
			return (preg_replace("/\/+/", "/", "$a/$b"));
		});
	}
	/** 
	* Get hearder Authorization
	* */
	static function getAuthorizationHeader(){
		$requestHeaders = apache_request_headers();
		if( isset($requestHeaders['Authparacrm'])) {
			return trim($requestHeaders['Authparacrm']);
		}
		if( isset($requestHeaders['Authorization'])) {
			return trim($requestHeaders['Authorization']);
		}
		return null;
	}
	/**
	* get access token from header
	* */
	static function getBearerToken() {
		$headers = self::getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
					return $matches[1];
			}
		}
		return null;
	}
	static function getAndroidId() {
		$headers = self::getAuthorizationHeader();
		// HEADER: Get the access token from the header
		if (!empty($headers)) {
			if (preg_match('/AndroidId\s(\S+)/', $headers, $matches)) {
					return $matches[1];
			}
		}
		return null;
	}
}





$_http_method = $_SERVER['REQUEST_METHOD'] ;
$_router_path = explode('/',Op5RouterUtils::normalizePath($_SERVER['PATH_INFO'])) ;
if( !!$_router_path[0] ) {
	header("HTTP/1.0 500 Internal Server Error");
	exit ;
}
array_shift($_router_path);
//$_token = Op5RouterUtils::getBearerToken() ;

//print_r($_router_path) ;
$uuid = array_shift($_router_path);
$inner_path = "/".implode('/',$_router_path);


if( false ) {
	echo "METHOD = ".$_http_method."<br>" ;
	echo "UUID = ".$uuid."<br>" ;
	echo "PATH_INFO = ".$inner_path."<br>" ;
	//echo "TOKEN = ".$_token."\n" ;
	die();
}



include("$server_root/include/config.inc.php");
include("$server_root/include/toolfunctions.inc.php");

include("$server_root/modules/media/include/media.inc.php");

include( "$server_root/include/database/mysql_DB.inc.php" ) ;
$_opDB = new mysql_DB( );
$_opDB->connect_mysql( $mysql_host, '', $mysql_user, $mysql_pass );
$_opDB->query("SET NAMES UTF8") ;

include_once($server_root.'/router/router_lib.inc.php') ;

include_once("$server_root/modules/paracrm/backend_paracrm.inc.php");

$assets_prefix = '/assets' ;
if( strpos($inner_path,$assets_prefix)===0 ) {
	$file_path_client = substr($inner_path,1); // trim slash
	try {
		list($mimetype,$bin_text) = libRouter_assets_servePath($file_path_client);
	} catch( Exception $e ) {
		header("HTTP/1.0 404 Not Found");
		exit ;
	}	
	header("HTTP/1.0 200 OK");
	header('Content-type: '.$mimetype);
	die( $bin_text );
}


try {
	$build_is_tmp = libRouter_isTmp($uuid);
} catch( Exception $e ) {
	header("HTTP/1.0 404 Not Found");
	exit ;
}
if( $build_is_tmp ) {
	$auth_uuids = json_decode($_COOKIE['OP5APP'],true);
	if( !is_array($auth_uuids) || !in_array($uuid,$auth_uuids) ) {
		header('HTTP/1.0 403 Forbidden');
		exit;
	}
}

try {
	list($mimetype,$bin_base64) = libRouter_fetch($uuid,$inner_path);
} catch( Exception $e ) {
	header("HTTP/1.0 404 Not Found");
	exit ;
}

header("HTTP/1.0 200 OK");
header('Content-type: '.$mimetype);
die( base64_decode($bin_base64) );

?>
