<?php

function libRouter_init() {
	$getDbInitStatements = function() {
		$sql_statements = array() ;
		$sql_statements[] = <<<EOF
CREATE DATABASE IF NOT EXISTS `op5router` ;
EOF;
		$sql_statements[] = <<<EOF
CREATE TABLE IF NOT EXISTS `op5router`.`app` (
  `app_uuid` VARCHAR(50) NOT NULL PRIMARY KEY,
  `build_date` DATETIME NOT NULL,
  `build_is_tmp` INT NOT NULL
) ;
EOF;
		$sql_statements[] = <<<EOF
CREATE TABLE IF NOT EXISTS `op5router`.`app_qsql` (
  `app_uuid` VARCHAR(50) NOT NULL,
  `get_path` VARCHAR(500) NOT NULL,
  `domain_id` VARCHAR(50) NOT NULL,
  `sdomain_id` VARCHAR(50) NOT NULL,
  PRIMARY KEY (`app_uuid`, `get_path`)
) ;
EOF;
		$sql_statements[] = <<<EOF
CREATE TABLE IF NOT EXISTS `op5router`.`app_static` (
  `app_uuid` VARCHAR(50) NOT NULL,
  `get_path` VARCHAR(500) NOT NULL,
  `get_path_is_default` INT NOT NULL,
  `out_mimetype` VARCHAR(100) NOT NULL,
  `out_base64` LONGTEXT NOT NULL,
  PRIMARY KEY (`app_uuid`, `get_path`)
) ;
EOF;
		return $sql_statements ;
	};
	foreach( $getDbInitStatements() as $query ) {
		$GLOBALS['_opDB']->query($query) ;
	}
}






function libRouter_buildCreate($build_obj,$replace_uuid=null) {
	libRouter_init();
	
	$_opDB = $GLOBALS['_opDB'];
	
	if( $replace_uuid ) {
		$uuid = $replace_uuid ;
	} else {
		$uuid = vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex(random_bytes(16)), 4)) ;
		$query = "SELECT count(*) FROM op5router.app WHERE app_uuid='{$uuid}'" ;
		if( $_opDB->query_uniqueValue($query) > 0 ) {
			return null;
		}
	}
	
	$query = "DELETE FROM op5router.app WHERE app_uuid='{$uuid}'" ;
	$_opDB->query($query);
	
	$arr_ins = array();
	$arr_ins['app_uuid'] = $uuid ;
	$arr_ins['build_date'] = date('Y-m-d H:i:s');
	$arr_ins['build_is_tmp'] = $build_obj['build_is_tmp'] ? 1 : 0 ;
	$_opDB->insert('op5router.app',$arr_ins);
	
	$query = "DELETE FROM op5router.app_static WHERE app_uuid='{$uuid}'" ;
	$_opDB->query($query);
	
	foreach( $build_obj['static'] as $static ) {
		$arr_ins = array('app_uuid'=>$uuid);
		foreach( array('get_path','get_path_is_default','out_mimetype','out_base64') as $mkey ) {
			$arr_ins[$mkey] = $static[$mkey] ;
		}
		$_opDB->insert('op5router.app_static',$arr_ins);
	}
	
	return $uuid ;
}
function libRouter_buildDelete($build_uuid) {
	$tables = array('op5router.app','op5router.app_static','op5router.app_qsql');
	foreach( $tables as $table ) {
		$GLOBALS['_opDB']->query("DELETE FROM {$table} WHERE app_uuid='{$build_uuid}'") ;
	}
}












function libRouter_isTmp($app_uuid) {
	$_opDB = $GLOBALS['_opDB'];
	
	$query = "SELECT build_is_tmp FROM op5router.app
			WHERE app_uuid='{$app_uuid}'";
	$result = $_opDB->query($query);
	if( $_opDB->num_rows($result) != 1 ) {
		throw new Exception('404');
	}
	$arr = $_opDB->fetch_row($result);
	return !!$arr[0];
}
function libRouter_fetch($app_uuid,$get_path) {
	$_opDB = $GLOBALS['_opDB'];
	
	// HACK static /dwr => dwr@dbs
	if( strpos($get_path,'/dwr')===0 ) {
		$ttmp = explode('/',$get_path) ;
		$qsql_id = $ttmp[2] ;
		
		$domain_id = 'dbs';
		$sdomain_id = 'dwr' ;
		
		$t = new DatabaseMgr_Base();
		$domain_db = $t->getBaseDb( $domain_id ) ;
		$GLOBALS['mysql_db'] = $domain_db ;
		$t = new DatabaseMgr_Sdomain( $domain_id );
		$sdomain_db = $t->getSdomainDb( $sdomain_id ) ;
		$_opDB->select_db($sdomain_db) ;
		
		$json = paracrm_queries_direct(array('q_type'=>'qsql','q_id'=>$qsql_id), $auth_bypass=true, $is_rw=FALSE) ;
		
		$_opDB->select_db('') ;
		$GLOBALS['mysql_db'] = '' ;
		
		if( !$json['success'] ) {
			throw new Exception('404');
		}
		
		$qsql_tabs = array() ;
		foreach( $json['tabs'] as $tab ) {
			$rows = array() ;
			foreach( $tab['data'] as $srcData ) {
				$row = array() ;
				foreach( $tab['columns'] as $col ) {
					$val = $srcData[$col['dataIndex']] ;
					switch( $col['dataType'] ) {
						case 'number' :
							$val = (float)$val ;
							break ;
						case 'boolean' :
						case 'bool' :
							$val = !!$val ;
							break ;
						default :
							break ;
					}
					$row[$col['text']] = $val ;
				}
				$rows[] = $row ;
			}
			$tab['rows'] = $rows ;
			unset($tab['columns']);
			unset($tab['data']);
			$qsql_tabs[] = $tab ;
		}
		return array('application/json',base64_encode(json_encode($qsql_tabs)));
	}
	
	if( $get_path == '/' ) {
		$get_path = '/index.html';
	}
	$query = "SELECT out_mimetype, out_base64 FROM op5router.app_static
			WHERE app_uuid='{$app_uuid}' AND get_path='{$get_path}'";
	$result = $_opDB->query($query);
	if( $_opDB->num_rows($result) != 1 ) {
		throw new Exception('404');
	}
	$arr = $_opDB->fetch_row($result);
	
	$mimetype = $arr[0];
	$bin_base64 = $arr[1];
	
	return array($mimetype,$bin_base64);
}







function libRouter_assets_getRoot() {
	if( !$GLOBALS['resources_root'] ) {
		return null ;
	}
	return $GLOBALS['resources_root'].'/'.'assets';
}

function libRouter_assets_getList() {
	if( !libRouter_assets_getRoot() ) {
		return array() ;
	}
	$arr_assets = array() ;
	if( true ) {
		$arr_assets[] = array(
			'asset_id' => 'jquery',
			'asset_name' => 'jQuery',
			'asset_version' => '3.7.1',
			'include_dir' => 'jQuery-3.7.1-dist',
		);
	}
	if( true ) {
		$arr_assets[] = array(
			'asset_id' => 'bootstrap',
			'asset_name' => 'Bootstrap',
			'asset_version' => '5.3.3',
			'include_dir' => 'bootstrap-5.3.3-dist',
		);
	}
	if( true ) {
		$arr_assets[] = array(
			'asset_id' => 'gridjs',
			'asset_name' => 'Grid JS',
			'asset_version' => '0.1',
			'include_dir' => 'gridJs-dist',
		);
	}
	if( true ) {
		$arr_assets[] = array(
			'asset_id' => 'aggrid',
			'asset_name' => 'AG Grid',
			'asset_version' => '3.7.1',
			'include_dir' => 'agGrid-33.1.1-dist',
		);
	}
	foreach( $arr_assets as &$asset ) {
		$asset['paths'] = libRouter_assets_getPaths($asset['include_dir']);
	}
	return $arr_assets ;
}
function libRouter_assets_getPaths( $include_dir ) {
	$assets_root = libRouter_assets_getRoot();
	if( !$assets_root ){
		return null ;
	}
	$asset_dir = $assets_root.'/'.$include_dir ;
	if( !is_dir($asset_dir) ) {
		return null ;
	}
	
	$paths = array() ;
	foreach( array('css','js') as $sdir ) {
		$dir = $asset_dir.'/'.$sdir;
		if( is_dir($dir) ) {
			foreach( array_diff(scandir($dir), array('.', '..')) as $file ) {
				$file_path = $dir.'/'.$file ;
				if( pathinfo($file_path)['extension'] == $sdir ) {
					$file_path_client = substr($file_path,strlen($GLOBALS['resources_root'].'/'));
					$paths[] = $file_path_client ;
				}
			}
		}
	}
	return $paths ;
}
function libRouter_assets_servePath( $file_path_client ) {
	$assets_root = libRouter_assets_getRoot();
	if( !$assets_root ){
		throw new Exception('500');
	}
	$prefix = 'assets/' ;
	if( !(strpos($file_path_client,$prefix)===0) ) {
		throw new Exception('404');
	}
	
	$file_path = $assets_root.'/'.substr($file_path_client,strlen($prefix)) ;
	if( is_file($file_path) ) {
		$file_type = pathinfo($file_path)['extension'] ;
		$mimetype = 'text/plain' ;
		switch( $file_type ) {
			case 'js' :
				$mimetype = 'text/javascript' ;
				break ;
			case 'css' :
				$mimetype = 'text/css' ;
				break ;
		}
		return array($mimetype,file_get_contents($file_path));
	}
	throw new Exception('404');
}

?>
